/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.pms.schema.olap;

import java.util.ArrayList;
import java.util.List;
import org.pentaho.di.core.changed.ChangedFlag;
import org.pentaho.pms.schema.BusinessTable;
import org.pentaho.pms.schema.olap.OlapHierarchy;

public class OlapDimension
extends ChangedFlag
implements Cloneable {
    private String name;
    private boolean timeDimension;
    private List<OlapHierarchy> hierarchies = new ArrayList<OlapHierarchy>();

    public Object clone() {
        OlapDimension olapDimension = new OlapDimension();
        olapDimension.name = this.name;
        olapDimension.timeDimension = this.timeDimension;
        for (int i = 0; i < this.hierarchies.size(); ++i) {
            OlapHierarchy hierarchy = this.hierarchies.get(i);
            olapDimension.hierarchies.add((OlapHierarchy)hierarchy.clone());
        }
        return olapDimension;
    }

    public boolean equals(Object obj) {
        return this.name.equals(((OlapDimension)obj).getName());
    }

    public List<OlapHierarchy> getHierarchies() {
        return this.hierarchies;
    }

    public void setHierarchies(List<OlapHierarchy> hierarchies) {
        this.hierarchies = hierarchies;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isTimeDimension() {
        return this.timeDimension;
    }

    public void setTimeDimension(boolean timeDimension) {
        this.timeDimension = timeDimension;
    }

    public OlapHierarchy findOlapHierarchy(String thisName) {
        for (int i = 0; i < this.hierarchies.size(); ++i) {
            OlapHierarchy hierarchy = this.hierarchies.get(i);
            if (!hierarchy.getName().equalsIgnoreCase(thisName)) continue;
            return hierarchy;
        }
        return null;
    }

    public BusinessTable findBusinessTable() {
        for (int i = 0; i < this.hierarchies.size(); ++i) {
            OlapHierarchy hierarchy = this.hierarchies.get(i);
            if (hierarchy.getBusinessTable() == null) continue;
            return hierarchy.getBusinessTable();
        }
        return null;
    }

    public boolean hasChanged() {
        for (int i = 0; i < this.hierarchies.size(); ++i) {
            if (!this.hierarchies.get(i).hasChanged()) continue;
            return true;
        }
        return super.hasChanged();
    }

    public void clearChanged() {
        for (int i = 0; i < this.hierarchies.size(); ++i) {
            this.hierarchies.get(i).clearChanged();
        }
        this.setChanged(false);
    }
}

