/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.pms.schema.olap;

import java.util.ArrayList;
import java.util.List;
import org.pentaho.di.core.changed.ChangedFlag;
import org.pentaho.pms.schema.BusinessColumn;
import org.pentaho.pms.schema.olap.OlapHierarchy;

public class OlapHierarchyLevel
extends ChangedFlag
implements Cloneable {
    private String name;
    private BusinessColumn referenceColumn;
    private List<BusinessColumn> businessColumns;
    private boolean havingUniqueMembers;
    private OlapHierarchy olapHierarchy;

    public OlapHierarchyLevel(OlapHierarchy olapHierarchy) {
        this.olapHierarchy = olapHierarchy;
        this.businessColumns = new ArrayList<BusinessColumn>();
    }

    public OlapHierarchyLevel(OlapHierarchy olapHierarchy, String name, BusinessColumn referenceColumn, List<BusinessColumn> businessColumns) {
        this(olapHierarchy);
        this.name = name;
        this.referenceColumn = referenceColumn;
        this.businessColumns = businessColumns;
    }

    public Object clone() {
        OlapHierarchyLevel hierarchyLevel = new OlapHierarchyLevel(this.olapHierarchy);
        hierarchyLevel.name = this.name;
        if (this.referenceColumn != null) {
            hierarchyLevel.referenceColumn = (BusinessColumn)this.referenceColumn.clone();
        }
        for (int i = 0; i < this.businessColumns.size(); ++i) {
            BusinessColumn businessColumn = this.businessColumns.get(i);
            hierarchyLevel.businessColumns.add((BusinessColumn)businessColumn.clone());
        }
        hierarchyLevel.havingUniqueMembers = this.havingUniqueMembers;
        return hierarchyLevel;
    }

    public boolean equals(Object obj) {
        return this.name.equals(((OlapHierarchyLevel)obj).getName());
    }

    public List<BusinessColumn> getBusinessColumns() {
        return this.businessColumns;
    }

    public void setBusinessColumns(List<BusinessColumn> businessColumns) {
        this.businessColumns = businessColumns;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public BusinessColumn getReferenceColumn() {
        return this.referenceColumn;
    }

    public void setReferenceColumn(BusinessColumn referenceColumn) {
        this.referenceColumn = referenceColumn;
    }

    public BusinessColumn findBusinessColumn(String locale, String thisName) {
        if (this.referenceColumn != null && this.referenceColumn.getDisplayName(locale).equalsIgnoreCase(thisName)) {
            return this.referenceColumn;
        }
        for (int i = 0; i < this.businessColumns.size(); ++i) {
            BusinessColumn column = this.businessColumns.get(i);
            if (!column.getDisplayName(locale).equalsIgnoreCase(thisName)) continue;
            return column;
        }
        return null;
    }

    public OlapHierarchy getOlapHierarchy() {
        return this.olapHierarchy;
    }

    public void setOlapHierarchy(OlapHierarchy olapHierarchy) {
        this.olapHierarchy = olapHierarchy;
    }

    public boolean isHavingUniqueMembers() {
        return this.havingUniqueMembers;
    }

    public void setHavingUniqueMembers(boolean havingUniqueMembers) {
        this.havingUniqueMembers = havingUniqueMembers;
    }
}

