/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.jms;

import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import org.apache.oozie.jms.ConnectionContext;
import org.apache.oozie.jms.JMSConnectionInfo;
import org.apache.oozie.service.JMSAccessorService;
import org.apache.oozie.service.Services;
import org.apache.oozie.util.XLog;

public class JMSExceptionListener
implements ExceptionListener {
    private static XLog LOG = XLog.getLog(JMSExceptionListener.class);
    private JMSConnectionInfo connInfo;
    private ConnectionContext connCtxt;
    private boolean retry;

    public JMSExceptionListener(JMSConnectionInfo connInfo, ConnectionContext connCtxt, boolean retry) {
        this.connInfo = connInfo;
        this.connCtxt = connCtxt;
        this.retry = retry;
    }

    public void onException(JMSException exception) {
        LOG.warn("Received JMSException for [{0}]", new Object[]{this.connInfo, exception});
        this.connCtxt.close();
        if (this.retry) {
            JMSAccessorService jmsService = Services.get().get(JMSAccessorService.class);
            jmsService.reestablishConnection(this.connInfo);
        }
    }
}

