/*
 * Decompiled with CFR 0.152.
 */
package parquet.column.values.deltastrings;

import parquet.bytes.BytesInput;
import parquet.column.Encoding;
import parquet.column.values.ValuesWriter;
import parquet.column.values.delta.DeltaBinaryPackingValuesWriter;
import parquet.column.values.deltalengthbytearray.DeltaLengthByteArrayValuesWriter;
import parquet.io.api.Binary;

public class DeltaByteArrayWriter
extends ValuesWriter {
    private ValuesWriter prefixLengthWriter;
    private ValuesWriter suffixWriter;
    private byte[] previous;

    public DeltaByteArrayWriter(int initialCapacity, int pageSize) {
        this.prefixLengthWriter = new DeltaBinaryPackingValuesWriter(128, 4, initialCapacity, pageSize);
        this.suffixWriter = new DeltaLengthByteArrayValuesWriter(initialCapacity, pageSize);
        this.previous = new byte[0];
    }

    @Override
    public long getBufferedSize() {
        return this.prefixLengthWriter.getBufferedSize() + this.suffixWriter.getBufferedSize();
    }

    @Override
    public BytesInput getBytes() {
        return BytesInput.concat(this.prefixLengthWriter.getBytes(), this.suffixWriter.getBytes());
    }

    @Override
    public Encoding getEncoding() {
        return Encoding.DELTA_BYTE_ARRAY;
    }

    @Override
    public void reset() {
        this.prefixLengthWriter.reset();
        this.suffixWriter.reset();
        this.previous = new byte[0];
    }

    @Override
    public long getAllocatedSize() {
        return this.prefixLengthWriter.getAllocatedSize() + this.suffixWriter.getAllocatedSize();
    }

    @Override
    public String memUsageString(String prefix) {
        prefix = this.prefixLengthWriter.memUsageString(prefix);
        return this.suffixWriter.memUsageString(prefix + "  DELTA_STRINGS");
    }

    @Override
    public void writeBytes(Binary v) {
        int i = 0;
        byte[] vb = v.getBytes();
        int length = this.previous.length < vb.length ? this.previous.length : vb.length;
        for (i = 0; i < length && this.previous[i] == vb[i]; ++i) {
        }
        this.prefixLengthWriter.writeInteger(i);
        this.suffixWriter.writeBytes(v.slice(i, vb.length - i));
        this.previous = vb;
    }
}

