/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.apache.hadoop.hbase.classification.InterfaceAudience;

@InterfaceAudience.Private
public class ReflectionUtils {
    public static <T> T instantiateWithCustomCtor(String className, Class<?>[] ctorArgTypes, Object[] ctorArgs) {
        try {
            Class<?> resultType = Class.forName(className);
            Constructor<?> ctor = resultType.getDeclaredConstructor(ctorArgTypes);
            return (T)ReflectionUtils.instantiate(className, ctor, ctorArgs);
        }
        catch (ClassNotFoundException e) {
            throw new UnsupportedOperationException("Unable to find " + className, e);
        }
        catch (NoSuchMethodException e) {
            throw new UnsupportedOperationException("Unable to find suitable constructor for class " + className, e);
        }
    }

    private static <T> T instantiate(String className, Constructor<T> ctor, Object[] ctorArgs) {
        try {
            return ctor.newInstance(ctorArgs);
        }
        catch (IllegalAccessException e) {
            throw new UnsupportedOperationException("Unable to access specified class " + className, e);
        }
        catch (InstantiationException e) {
            throw new UnsupportedOperationException("Unable to instantiate specified class " + className, e);
        }
        catch (InvocationTargetException e) {
            throw new UnsupportedOperationException("Constructor threw an exception for " + className, e);
        }
    }

    public static <T> T newInstance(Class<T> type, Object ... params) {
        return ReflectionUtils.instantiate(type.getName(), ReflectionUtils.findConstructor(type, params), params);
    }

    public static <T> Constructor<T> findConstructor(Class<T> type, Object ... paramTypes) {
        Constructor<?>[] constructors;
        for (Constructor<?> ctor : constructors = type.getConstructors()) {
            Class<?>[] ctorParamTypes = ctor.getParameterTypes();
            if (ctorParamTypes.length != paramTypes.length) continue;
            boolean match = true;
            for (int i = 0; i < ctorParamTypes.length && match; ++i) {
                Class<?> paramType = paramTypes[i].getClass();
                match = !ctorParamTypes[i].isPrimitive() ? ctorParamTypes[i].isAssignableFrom(paramType) : Integer.TYPE.equals(ctorParamTypes[i]) && Integer.class.equals(paramType) || Long.TYPE.equals(ctorParamTypes[i]) && Long.class.equals(paramType) || Double.TYPE.equals(ctorParamTypes[i]) && Double.class.equals(paramType) || Character.TYPE.equals(ctorParamTypes[i]) && Character.class.equals(paramType) || Short.TYPE.equals(ctorParamTypes[i]) && Short.class.equals(paramType) || Boolean.TYPE.equals(ctorParamTypes[i]) && Boolean.class.equals(paramType) || Byte.TYPE.equals(ctorParamTypes[i]) && Byte.class.equals(paramType);
            }
            if (!match) continue;
            return ctor;
        }
        throw new UnsupportedOperationException("Unable to find suitable constructor for class " + type.getName());
    }
}

