/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.resourceloader.loader;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.libraries.base.util.IOUtils;
import org.pentaho.reporting.libraries.resourceloader.LibLoaderBoot;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceLoadingException;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;
import org.pentaho.reporting.libraries.resourceloader.loader.AbstractResourceData;

public class URLResourceData
extends AbstractResourceData {
    private static final Log logger = LogFactory.getLog(URLResourceData.class);
    private static final long serialVersionUID = -7183025686032509509L;
    private static Long fixedCacheDelay;
    private long lastDateMetaDataRead;
    private long modificationDate;
    private String filename;
    private Long contentLength;
    private String contentType;
    private boolean metaDataOK;
    private URL url;
    private ResourceKey key;
    private static Boolean fixBrokenWebServiceDateHeader;

    protected static long getFixedCacheDelay() {
        if (fixedCacheDelay == null) {
            fixedCacheDelay = new Long(LibLoaderBoot.getInstance().getExtendedConfig().getIntProperty("org.pentaho.reporting.libraries.resourceloader.config.url.FixedCacheDelay", 5000));
        }
        return fixedCacheDelay;
    }

    protected static boolean isFixBrokenWebServiceDateHeader() {
        if (fixBrokenWebServiceDateHeader == null) {
            fixBrokenWebServiceDateHeader = LibLoaderBoot.getInstance().getExtendedConfig().getBoolProperty("org.pentaho.reporting.libraries.resourceloader.config.url.FixBrokenWebServiceDateHeader", false);
        }
        return fixBrokenWebServiceDateHeader;
    }

    public URLResourceData(ResourceKey key) {
        if (key == null) {
            throw new NullPointerException();
        }
        this.modificationDate = -1L;
        this.key = key;
        this.url = (URL)key.getIdentifier();
        this.filename = IOUtils.getInstance().getFileName(this.url);
    }

    protected void setUrl(URL url) {
        this.url = url;
    }

    protected void setKey(ResourceKey key) {
        this.key = key;
    }

    protected void setFilename(String filename) {
        this.filename = filename;
    }

    protected URL getUrl() {
        return this.url;
    }

    protected String getFilename() {
        return this.filename;
    }

    private void readMetaData() throws IOException {
        if (this.metaDataOK) {
            if (System.currentTimeMillis() - this.lastDateMetaDataRead < URLResourceData.getFixedCacheDelay()) {
                return;
            }
            if (URLResourceData.isFixBrokenWebServiceDateHeader()) {
                return;
            }
        }
        URLConnection c = this.url.openConnection();
        c.setDoOutput(false);
        c.setAllowUserInteraction(false);
        if (c instanceof HttpURLConnection) {
            HttpURLConnection httpURLConnection = (HttpURLConnection)c;
            httpURLConnection.setRequestMethod("HEAD");
        }
        c.connect();
        this.readMetaData(c);
        c.getInputStream().close();
    }

    private void readMetaData(URLConnection c) {
        this.modificationDate = c.getHeaderFieldDate("last-modified", -1L);
        if (this.modificationDate <= 0L) {
            this.modificationDate = URLResourceData.isFixBrokenWebServiceDateHeader() ? System.currentTimeMillis() : -1L;
        }
        this.contentLength = new Long(c.getContentLength());
        this.contentType = c.getHeaderField("content-type");
        this.metaDataOK = true;
        this.lastDateMetaDataRead = System.currentTimeMillis();
    }

    @Override
    public InputStream getResourceAsStream(ResourceManager caller) throws ResourceLoadingException {
        try {
            URLConnection c = this.url.openConnection();
            c.setDoOutput(false);
            c.setAllowUserInteraction(false);
            c.connect();
            if (!URLResourceData.isFixBrokenWebServiceDateHeader()) {
                this.readMetaData(c);
            }
            return c.getInputStream();
        }
        catch (IOException e) {
            throw new ResourceLoadingException("Failed to open URL connection", e);
        }
    }

    @Override
    public Object getAttribute(String key) {
        if (key.equals("filename")) {
            return this.filename;
        }
        if (key.equals("content-length")) {
            try {
                if (!this.metaDataOK) {
                    this.readMetaData();
                }
                return this.contentLength;
            }
            catch (IOException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"No response metadata could be read from the input stream", (Throwable)e);
                }
                return null;
            }
        }
        if (key.equals("content-type")) {
            try {
                if (!this.metaDataOK) {
                    this.readMetaData();
                }
                return this.contentType;
            }
            catch (IOException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"No response metadata could be read from the input stream", (Throwable)e);
                }
                return null;
            }
        }
        return null;
    }

    @Override
    public long getVersion(ResourceManager caller) throws ResourceLoadingException {
        try {
            this.readMetaData();
            return this.modificationDate;
        }
        catch (IOException e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"No response metadata could be read from the input stream", (Throwable)e);
            }
            return -1L;
        }
    }

    @Override
    public ResourceKey getKey() {
        return this.key;
    }
}

