/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.binding.convert.converters;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.springframework.binding.convert.ConversionExecutor;
import org.springframework.binding.convert.ConversionService;
import org.springframework.binding.convert.converters.TwoWayConverter;
import org.springframework.core.GenericCollectionTypeResolver;

public class ArrayToCollection
implements TwoWayConverter {
    private ConversionService conversionService;
    private ConversionExecutor elementConverter;

    public ArrayToCollection(ConversionService conversionService) {
        this.conversionService = conversionService;
    }

    public ArrayToCollection(ConversionExecutor elementConverter) {
        this.elementConverter = elementConverter;
    }

    @Override
    public Class<?> getSourceClass() {
        return Object[].class;
    }

    @Override
    public Class<?> getTargetClass() {
        return Collection.class;
    }

    @Override
    public Object convertSourceToTargetClass(Object source, Class<?> targetClass) throws Exception {
        if (source == null) {
            return null;
        }
        Class<?> collectionImplClass = this.getCollectionImplClass(targetClass);
        Constructor<?> constructor = collectionImplClass.getConstructor(new Class[0]);
        Collection collection = (Collection)constructor.newInstance(new Object[0]);
        ConversionExecutor converter = this.getArrayElementConverter(source, targetClass);
        int length = Array.getLength(source);
        for (int i = 0; i < length; ++i) {
            Object value = Array.get(source, i);
            if (converter != null) {
                value = converter.execute(value);
            }
            collection.add(value);
        }
        return collection;
    }

    @Override
    public Object convertTargetToSourceClass(Object target, Class<?> sourceClass) throws Exception {
        if (target == null) {
            return null;
        }
        Collection collection = (Collection)target;
        Object array = Array.newInstance(sourceClass.getComponentType(), collection.size());
        int i = 0;
        for (Object value : collection) {
            if (value != null) {
                ConversionExecutor converter = this.elementConverter != null ? this.elementConverter : this.conversionService.getConversionExecutor(value.getClass(), sourceClass.getComponentType());
                value = converter.execute(value);
            }
            Array.set(array, i++, value);
        }
        return array;
    }

    private Class<?> getCollectionImplClass(Class<?> targetClass) {
        if (targetClass.isInterface()) {
            if (List.class.equals(targetClass)) {
                return ArrayList.class;
            }
            if (Set.class.equals(targetClass)) {
                return LinkedHashSet.class;
            }
            if (SortedSet.class.equals(targetClass)) {
                return TreeSet.class;
            }
            throw new IllegalArgumentException("Unsupported collection interface [" + targetClass.getName() + "]");
        }
        return targetClass;
    }

    private ConversionExecutor getArrayElementConverter(Object source, Class<?> targetClass) {
        if (this.elementConverter != null) {
            return this.elementConverter;
        }
        Class elementType = GenericCollectionTypeResolver.getCollectionType(targetClass);
        if (elementType != null) {
            Class<?> componentType = source.getClass().getComponentType();
            return this.conversionService.getConversionExecutor(componentType, elementType);
        }
        return null;
    }
}

