/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.logger.log4j;

import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.jfree.util.LogContext;

public class Log4JLogContext
extends LogContext {
    private Logger logger;

    public Log4JLogContext(String contextPrefix) {
        super(contextPrefix);
        this.logger = Logger.getLogger((String)contextPrefix);
    }

    public boolean isDebugEnabled() {
        return this.logger.isEnabledFor(Priority.DEBUG);
    }

    public boolean isErrorEnabled() {
        return this.logger.isEnabledFor(Priority.ERROR);
    }

    public boolean isInfoEnabled() {
        return this.logger.isEnabledFor(Priority.INFO);
    }

    public boolean isWarningEnabled() {
        return this.logger.isEnabledFor(Priority.WARN);
    }

    public void log(int level, Object message) {
        this.logger.log(this.translatePriority(level), message);
    }

    protected final Priority translatePriority(int level) {
        if (level == 3) {
            return Priority.DEBUG;
        }
        if (level == 2) {
            return Priority.INFO;
        }
        if (level == 1) {
            return Priority.WARN;
        }
        if (level == 0) {
            return Priority.ERROR;
        }
        return Priority.FATAL;
    }

    public void log(int level, Object message, Exception e) {
        this.logger.log(this.translatePriority(level), message, (Throwable)e);
    }
}

