/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.big.data.impl.shim.oozie;

import java.util.Properties;
import org.pentaho.big.data.impl.shim.oozie.OozieJobInfoDelegate;
import org.pentaho.bigdata.api.oozie.OozieJobInfo;
import org.pentaho.bigdata.api.oozie.OozieService;
import org.pentaho.bigdata.api.oozie.OozieServiceException;
import org.pentaho.oozie.shim.api.OozieClient;
import org.pentaho.oozie.shim.api.OozieClientException;
import org.pentaho.oozie.shim.api.OozieJob;

public class OozieServiceImpl
implements OozieService {
    private final OozieClient delegate;

    public OozieServiceImpl(OozieClient oozieClient) {
        this.delegate = oozieClient;
    }

    public String getClientBuildVersion() {
        return this.delegate.getClientBuildVersion();
    }

    public String getProtocolUrl() throws OozieServiceException {
        try {
            return this.delegate.getProtocolUrl();
        }
        catch (OozieClientException e) {
            throw new OozieServiceException((Throwable)e, e.getErrorCode());
        }
    }

    public boolean hasAppPath(Properties props) {
        return props.containsKey("oozie.wf.application.path") || props.containsKey("oozie.coord.application.path") || props.containsKey("oozie.bundle.application.path");
    }

    public OozieJobInfo run(Properties props) throws OozieServiceException {
        try {
            OozieJob job = this.delegate.run(props);
            return new OozieJobInfoDelegate(job);
        }
        catch (OozieClientException e) {
            throw new OozieServiceException((Throwable)e, e.getErrorCode());
        }
    }

    public void validateWSVersion() throws OozieServiceException {
        try {
            this.delegate.validateWSVersion();
        }
        catch (OozieClientException e) {
            throw new OozieServiceException((Throwable)e, e.getErrorCode());
        }
    }
}

