/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import java.net.URI;
import java.security.PrivilegedExceptionAction;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.shims.HadoopShims;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.JobProfile;
import org.apache.hadoop.mapred.JobStatus;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.TypeConverter;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.ApplicationClientProtocol;
import org.apache.hadoop.yarn.api.protocolrecords.ApplicationsRequestScope;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationsRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationsResponse;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.client.ClientRMProxy;
import org.apache.hadoop.yarn.client.api.YarnClient;
import org.apache.hadoop.yarn.exceptions.YarnException;

public class WebHCatJTShim23
implements HadoopShims.WebHCatJTShim {
    private static final Log LOG = LogFactory.getLog(WebHCatJTShim23.class);
    private JobClient jc;
    private final Configuration conf;

    public WebHCatJTShim23(final Configuration conf, UserGroupInformation ugi) throws IOException {
        try {
            this.conf = conf;
            this.jc = (JobClient)ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<JobClient>(){

                @Override
                public JobClient run() throws IOException, InterruptedException {
                    return new JobClient(conf);
                }
            });
        }
        catch (InterruptedException ex) {
            throw new RuntimeException("Failed to create JobClient", ex);
        }
    }

    public JobProfile getJobProfile(JobID jobid) throws IOException {
        RunningJob rj = this.getJob(jobid);
        if (rj == null) {
            return null;
        }
        JobStatus jobStatus = rj.getJobStatus();
        return new JobProfile(jobStatus.getUsername(), (org.apache.hadoop.mapreduce.JobID)jobStatus.getJobID(), jobStatus.getJobFile(), jobStatus.getTrackingUrl(), jobStatus.getJobName());
    }

    public JobStatus getJobStatus(JobID jobid) throws IOException {
        RunningJob rj = this.getJob(jobid);
        if (rj == null) {
            return null;
        }
        return rj.getJobStatus();
    }

    public void killJob(JobID jobid) throws IOException {
        RunningJob rj = this.getJob(jobid);
        if (rj == null) {
            return;
        }
        rj.killJob();
    }

    public JobStatus[] getAllJobs() throws IOException {
        return this.jc.getAllJobs();
    }

    public void close() {
        try {
            this.jc.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void addCacheFile(URI uri, Job job) {
        job.addCacheFile(uri);
    }

    private RunningJob getJob(JobID jobid) throws IOException {
        try {
            return this.jc.getJob(jobid);
        }
        catch (IOException ex) {
            String msg = ex.getMessage();
            if (msg != null && (msg.contains("ApplicationNotFoundException") || Pattern.compile("History file.*not found").matcher(msg).find())) {
                LOG.info((Object)("Job(" + jobid + ") not found: " + msg));
                return null;
            }
            throw ex;
        }
    }

    public void killJobs(String tag, long timestamp) {
        try {
            LOG.info((Object)"Looking for jobs to kill...");
            Set<ApplicationId> childJobs = this.getYarnChildJobs(tag, timestamp);
            if (childJobs.isEmpty()) {
                LOG.info((Object)"No jobs found from");
                return;
            }
            LOG.info((Object)String.format("Found MR jobs count: %d", childJobs.size()));
            LOG.info((Object)"Killing all found jobs");
            YarnClient yarnClient = YarnClient.createYarnClient();
            yarnClient.init(this.conf);
            yarnClient.start();
            for (ApplicationId app : childJobs) {
                LOG.info((Object)String.format("Killing job: %s ...", app));
                yarnClient.killApplication(app);
                LOG.info((Object)String.format("Job %s killed", app));
            }
        }
        catch (YarnException ye) {
            throw new RuntimeException("Exception occurred while killing child job(s)", ye);
        }
        catch (IOException ioe) {
            throw new RuntimeException("Exception occurred while killing child job(s)", ioe);
        }
    }

    public Set<String> getJobs(String tag, long timestamp) {
        Set<ApplicationId> childYarnJobs = this.getYarnChildJobs(tag, timestamp);
        HashSet<String> childJobs = new HashSet<String>();
        for (ApplicationId id : childYarnJobs) {
            String childJobId = TypeConverter.fromYarn((ApplicationId)id).toString();
            childJobs.add(childJobId);
        }
        return childJobs;
    }

    private Set<ApplicationId> getYarnChildJobs(String tag, long timestamp) {
        HashSet<ApplicationId> childYarnJobs = new HashSet<ApplicationId>();
        LOG.info((Object)String.format("Querying RM for tag = %s, starting with ts = %s", tag, timestamp));
        GetApplicationsRequest gar = GetApplicationsRequest.newInstance();
        gar.setScope(ApplicationsRequestScope.OWN);
        gar.setStartRange(timestamp, System.currentTimeMillis());
        gar.setApplicationTags(Collections.singleton(tag));
        try {
            ApplicationClientProtocol proxy = (ApplicationClientProtocol)ClientRMProxy.createRMProxy((Configuration)this.conf, ApplicationClientProtocol.class);
            GetApplicationsResponse apps = proxy.getApplications(gar);
            List appsList = apps.getApplicationList();
            for (ApplicationReport appReport : appsList) {
                childYarnJobs.add(appReport.getApplicationId());
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException("Exception occurred while finding child jobs", ioe);
        }
        catch (YarnException ye) {
            throw new RuntimeException("Exception occurred while finding child jobs", ye);
        }
        return childYarnJobs;
    }
}

