/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.trans.steps.teradatabulkloader;

import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.ui.core.PropsUI;
import org.pentaho.di.ui.core.widget.TextVar;
import org.pentaho.di.ui.trans.steps.teradatabulkloader.CompositeMenuItem;
import org.pentaho.di.ui.trans.steps.teradatabulkloader.TeraDataBulkLoaderDialog;

public abstract class TextVarMenuItem {
    private Label label;
    private Button button;
    private TextVar textvar;
    private Text text;
    private int type;
    int margin = 4;
    final int middle;
    SelectionListener selectionListener = null;

    TextVarMenuItem(Composite parent, PropsUI props, TransMeta transMeta, ModifyListener lsMod, TextVarMenuItem top, String labelProp, int buttonType) {
        this(parent, props, transMeta, lsMod, top.getButton(), labelProp, buttonType);
    }

    TextVarMenuItem(Composite parent, PropsUI props, TransMeta transMeta, ModifyListener lsMod, CompositeMenuItem top, String labelProp, int buttonType) {
        this(parent, props, transMeta, lsMod, (Control)top.getComposite(), labelProp, buttonType);
    }

    TextVarMenuItem(Composite parent, PropsUI props, TransMeta transMeta, ModifyListener lsMod, Control top, String labelProp, int buttonType) {
        this.middle = props.getMiddlePct();
        this.type = buttonType;
        this.button = new Button(parent, 0x1000008);
        this.button.setText(BaseMessages.getString(TeraDataBulkLoaderDialog.PKG, (String)"TeraDataBulkLoaderDialog.Browse.Button", (String[])new String[0]));
        props.setLook((Control)this.button);
        FormData fdb = new FormData();
        fdb.top = top == null ? new FormAttachment(0, this.margin) : new FormAttachment(top, this.margin);
        fdb.right = new FormAttachment(100, -this.margin);
        this.button.setLayoutData((Object)fdb);
        if (this.type == 0 || this.type == 16 || this.type == 8) {
            this.button.setVisible(false);
            this.button.dispose();
            this.button = null;
        }
        this.label = new Label(parent, 131072);
        this.label.setText(BaseMessages.getString(TeraDataBulkLoaderDialog.PKG, (String)labelProp, (String[])new String[0]));
        FormData fdl = new FormData();
        fdl.left = new FormAttachment(0, this.margin);
        fdl.top = top == null ? new FormAttachment(0, this.margin) : new FormAttachment(top, this.margin);
        if ((this.type & 8) != 0) {
            fdl.right = new FormAttachment(100, -this.margin);
            this.label.setLayoutData((Object)fdl);
            this.label.setAlignment(0x1000000);
            return;
        }
        fdl.right = new FormAttachment(this.middle, -this.margin);
        props.setLook((Control)this.label);
        this.label.setLayoutData((Object)fdl);
        FormData fdt = new FormData();
        fdt.left = new FormAttachment(this.middle, this.margin);
        fdt.top = top == null ? new FormAttachment(0, this.margin) : new FormAttachment(top, this.margin);
        fdt.right = this.type == 0 || this.type == 16 || this.type == 8 ? new FormAttachment(100, -this.margin) : new FormAttachment((Control)this.button, -this.margin);
        if (this.type == 16) {
            this.text = new Text(parent, 18436);
            props.setLook((Control)this.text);
            this.text.addModifyListener(lsMod);
            this.text.setLayoutData((Object)fdt);
        } else {
            this.textvar = new TextVar((VariableSpace)transMeta, parent, 18436);
            props.setLook((Control)this.textvar);
            this.textvar.addModifyListener(lsMod);
            this.textvar.setLayoutData((Object)fdt);
        }
        if (this.textvar != null && this.button != null) {
            this.selectionListener = new SelectionListener(){
                private SelectionListener selectionListener = null;
                private boolean initialized = false;

                private void initIfNecessary() {
                    if (!this.initialized) {
                        this.selectionListener = TextVarMenuItem.this.createSelectionListener(TextVarMenuItem.this.textvar);
                        this.initialized = true;
                    }
                }

                public void widgetSelected(SelectionEvent arg0) {
                    this.initIfNecessary();
                    if (this.selectionListener != null) {
                        this.selectionListener.widgetSelected(arg0);
                    }
                }

                public void widgetDefaultSelected(SelectionEvent arg0) {
                    this.initIfNecessary();
                    if (this.selectionListener != null) {
                        this.selectionListener.widgetDefaultSelected(arg0);
                    }
                }
            };
            this.button.addSelectionListener(this.selectionListener);
        }
    }

    public Control getButton() {
        return this.button != null ? this.button : (this.textvar != null ? this.textvar : this.label);
    }

    public TextVar getTextVar() {
        return this.textvar;
    }

    public void setText(String val) {
        if (this.type == 16) {
            this.text.setText(val);
        } else {
            this.textvar.setText(val);
        }
    }

    public String getText() {
        return this.type == 16 ? this.text.getText() : this.textvar.getText();
    }

    public void setVisible(boolean b) {
        if (this.button != null) {
            this.button.setVisible(b);
        }
        if (this.label != null) {
            this.label.setVisible(b);
        }
        if (this.textvar != null) {
            this.textvar.setVisible(b);
        }
    }

    protected abstract SelectionListener createSelectionListener(TextVar var1);
}

