/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.engine.core.system.boot;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.pentaho.platform.api.engine.IApplicationContext;
import org.pentaho.platform.api.engine.IPentahoDefinableObjectFactory;
import org.pentaho.platform.api.engine.IPentahoObjectFactory;
import org.pentaho.platform.api.engine.IPentahoPublisher;
import org.pentaho.platform.api.engine.IPentahoSystemListener;
import org.pentaho.platform.api.engine.ISessionStartupAction;
import org.pentaho.platform.api.engine.ISystemSettings;
import org.pentaho.platform.engine.core.messages.Messages;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.core.system.StandaloneApplicationContext;
import org.pentaho.platform.engine.core.system.boot.PlatformInitializationException;
import org.pentaho.platform.engine.core.system.objfac.StandaloneObjectFactory;

public class PentahoSystemBoot {
    private IPentahoObjectFactory factory;
    private String filePath;
    private String fullyQualifiedServerUrl;
    private List<IPentahoSystemListener> lifecycleListeners = new ArrayList<IPentahoSystemListener>();
    private List<ISessionStartupAction> startupActions = new ArrayList<ISessionStartupAction>();
    private List<IPentahoPublisher> adminActions = new ArrayList<IPentahoPublisher>();
    private ISystemSettings settingsProvider = null;
    private boolean initialized = false;

    public PentahoSystemBoot() {
        this.configure(null, null, null);
    }

    public PentahoSystemBoot(String solutionPath) {
        this.configure(solutionPath, null, null);
    }

    public PentahoSystemBoot(String solutionPath, String fullyQualifiedServerUrl) {
        this.configure(solutionPath, fullyQualifiedServerUrl, null);
    }

    public PentahoSystemBoot(String solutionPath, IPentahoDefinableObjectFactory factory) {
        this.configure(solutionPath, null, factory);
    }

    public PentahoSystemBoot(String solutionPath, String fullyQualifiedServerUrl, IPentahoDefinableObjectFactory factory) {
        this.configure(solutionPath, fullyQualifiedServerUrl, factory);
    }

    protected void configure(String userFilePath, String userFullyQualifiedServerUrl, IPentahoDefinableObjectFactory userFactory) {
        this.setFilePath(userFilePath != null ? userFilePath : new File(".").getAbsolutePath());
        this.setFullyQualifiedServerUrl(userFullyQualifiedServerUrl != null ? userFullyQualifiedServerUrl : "http://localhost:8080/pentaho/");
        this.setFactory((IPentahoObjectFactory)(userFactory != null ? userFactory : new StandaloneObjectFactory()));
        PentahoSystem.setSystemListeners(this.lifecycleListeners);
        PentahoSystem.setSessionStartupActions(this.startupActions);
        PentahoSystem.setAdministrationPlugins(this.adminActions);
    }

    public String getFilePath() {
        return this.filePath;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public void setFullyQualifiedServerUrl(String fullyQualifiedServerUrl) {
        this.fullyQualifiedServerUrl = fullyQualifiedServerUrl;
    }

    protected IApplicationContext createApplicationContext() {
        StandaloneApplicationContext appCtxt = new StandaloneApplicationContext(this.getFilePath(), "");
        appCtxt.setFullyQualifiedServerURL(this.fullyQualifiedServerUrl);
        return appCtxt;
    }

    public void init() {
        try {
            this.start();
        }
        catch (PlatformInitializationException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean start() throws PlatformInitializationException {
        this.initialized = false;
        try {
            this.initialized = PentahoSystem.init(this.createApplicationContext());
        }
        catch (Throwable t) {
            throw new PlatformInitializationException(Messages.getInstance().getErrorString("PentahoSystemBoot.ERROR_0001_PLATFORM_INIT_FAILED"), t);
        }
        if (!this.initialized) {
            throw new PlatformInitializationException(Messages.getInstance().getErrorString("PentahoSystemBoot.ERROR_0001_PLATFORM_INIT_FAILED"));
        }
        return this.initialized;
    }

    public boolean stop() {
        this.initialized = false;
        PentahoSystem.shutdown();
        return true;
    }

    public IPentahoObjectFactory getFactory() {
        return this.factory;
    }

    public void setFactory(IPentahoObjectFactory factory) {
        this.factory = factory;
        PentahoSystem.clearObjectFactory();
        PentahoSystem.registerPrimaryObjectFactory(factory);
    }

    public void addAdminAction(IPentahoPublisher adminAction) {
        this.adminActions.add(adminAction);
    }

    public void setAdminActions(List<IPentahoPublisher> adminActions) {
        this.adminActions = adminActions;
    }

    public void addLifecycleListener(IPentahoSystemListener lifecycleListener) {
        this.lifecycleListeners.add(lifecycleListener);
    }

    public List<IPentahoSystemListener> getLifecycleListeners() {
        return this.lifecycleListeners;
    }

    public void setLifecycleListeners(List<IPentahoSystemListener> lifecycleListeners) {
        this.lifecycleListeners = lifecycleListeners;
    }

    public ISystemSettings getSettingsProvider() {
        return this.settingsProvider;
    }

    public void setSettingsProvider(ISystemSettings settingsProvider) {
        PentahoSystem.setSystemSettingsService(settingsProvider);
        this.settingsProvider = settingsProvider;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public List<ISessionStartupAction> getStartupActions() {
        return this.startupActions;
    }

    public void setStartupActions(List<ISessionStartupAction> startupActions) {
        this.startupActions = startupActions;
    }

    public void addStartupAction(ISessionStartupAction startupAction) {
        this.startupActions.add(startupAction);
    }

    public PentahoSystemBoot define(String key, String implClassName, IPentahoDefinableObjectFactory.Scope scope) {
        if (!(this.factory instanceof IPentahoDefinableObjectFactory)) {
            throw new NoSuchMethodError("define is only supported by IPentahoDefinableObjectFactory");
        }
        IPentahoDefinableObjectFactory definableFactory = (IPentahoDefinableObjectFactory)this.getFactory();
        definableFactory.defineObject(key, implClassName, scope);
        return this;
    }

    public PentahoSystemBoot define(Class<?> interfaceClass, Class<?> implClass, IPentahoDefinableObjectFactory.Scope scope) {
        return this.define(interfaceClass.getSimpleName(), implClass.getName(), scope);
    }

    public PentahoSystemBoot define(String key, Class<?> implClass, IPentahoDefinableObjectFactory.Scope scope) {
        return this.define(key, implClass.getName(), scope);
    }

    public PentahoSystemBoot define(Class<?> interfaceClass, Class<?> implClass) {
        return this.define(interfaceClass.getSimpleName(), implClass.getName(), IPentahoDefinableObjectFactory.Scope.LOCAL);
    }

    public PentahoSystemBoot define(String key, Class<?> implClass) {
        return this.define(key, implClass.getName(), IPentahoDefinableObjectFactory.Scope.LOCAL);
    }

    public PentahoSystemBoot define(String key, Object instance) {
        if (!(this.factory instanceof IPentahoDefinableObjectFactory)) {
            throw new NoSuchMethodError("defineInstance is only supported by IPentahoDefinableObjectFactory");
        }
        IPentahoDefinableObjectFactory definableFactory = (IPentahoDefinableObjectFactory)this.getFactory();
        definableFactory.defineInstance(key, instance);
        return this;
    }
}

