/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.engine.security;

import java.util.Collection;
import java.util.List;
import org.springframework.security.access.AccessDecisionVoter;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;

public class PentahoSubstringRoleVoter
implements AccessDecisionVoter {
    private String processConfigAttributePrefix;

    public PentahoSubstringRoleVoter(String processConfigAttributePrefix) {
        this.processConfigAttributePrefix = processConfigAttributePrefix;
    }

    public boolean supports(ConfigAttribute attribute) {
        return attribute.getAttribute() != null && attribute.getAttribute().startsWith(this.processConfigAttributePrefix);
    }

    public boolean supports(Class clazz) {
        return true;
    }

    public int vote(Authentication authentication, Object object, Collection configAttributes) {
        int result = 0;
        List authorities = (List)this.extractAuthorities(authentication);
        for (ConfigAttribute attribute : configAttributes) {
            if (!this.supports(attribute)) continue;
            result = -1;
            for (int i = 0; i < authorities.size(); ++i) {
                if (!attribute.getAttribute().substring(this.processConfigAttributePrefix.length()).equals(((GrantedAuthority)authorities.get(i)).getAuthority())) continue;
                return 1;
            }
        }
        return result;
    }

    private Collection<? extends GrantedAuthority> extractAuthorities(Authentication authentication) {
        return authentication.getAuthorities();
    }
}

