/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.uifoundation.component;

import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.pentaho.platform.api.engine.IActionRequestHandler;
import org.pentaho.platform.api.engine.IParameterProvider;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.IPentahoUrlFactory;
import org.pentaho.platform.api.ui.IUIComponent;
import org.pentaho.platform.engine.services.PentahoMessenger;
import org.pentaho.platform.uifoundation.messages.Messages;
import org.pentaho.platform.util.messages.LocaleHelper;

public abstract class BaseUIComponent
extends PentahoMessenger
implements IUIComponent {
    private static final long serialVersionUID = -6768653568134000758L;
    public static final boolean debug = true;
    protected HashMap xslProperties;
    protected HashMap contentTypes;
    private IActionRequestHandler requestHandler;
    private IPentahoSession userSession;
    private HashMap parameterProviders;
    protected IPentahoUrlFactory urlFactory;
    private String sourcePath;

    @Override
    public abstract Log getLogger();

    public void handleRequest(OutputStream outputStream, IActionRequestHandler actionRequestHandler, String contentType, HashMap requestParameterProviders) throws IOException {
        this.parameterProviders = requestParameterProviders;
        this.requestHandler = actionRequestHandler;
        String content = this.getContent(contentType);
        if (content != null) {
            outputStream.write(content.getBytes(LocaleHelper.getSystemEncoding()));
        } else {
            this.error(Messages.getInstance().getString("BaseUI.ERROR_0001_NO_CONTENT"));
        }
    }

    protected void setSourcePath(String sourcePath) {
        this.sourcePath = sourcePath;
    }

    protected String getSourcePath() {
        return this.sourcePath;
    }

    public void setUrlFactory(IPentahoUrlFactory urlFactory) {
        this.urlFactory = urlFactory;
    }

    public void setRequestHandler(IActionRequestHandler actionRequestHandler) {
        this.requestHandler = actionRequestHandler;
    }

    public BaseUIComponent(IPentahoUrlFactory urlFactory, List messages, String sourcePath) {
        this.urlFactory = urlFactory;
        this.xslProperties = new HashMap();
        this.contentTypes = new HashMap();
        this.setMessages(messages);
        this.parameterProviders = new HashMap();
        this.sourcePath = sourcePath;
    }

    public void setParameterProvider(String name, IParameterProvider parameterProvider) {
        if (this.parameterProviders == null) {
            this.parameterProviders = new HashMap();
        }
        this.parameterProviders.put(name, parameterProvider);
    }

    public void setParameterProviders(HashMap parameterProviders) {
        this.parameterProviders = parameterProviders;
    }

    protected IPentahoUrlFactory getUrlFactory() {
        return this.urlFactory;
    }

    protected IActionRequestHandler getRequestHandler() {
        return this.requestHandler;
    }

    public HashMap getParameterProviders() {
        return this.parameterProviders;
    }

    public String getParameter(String name, String defaultValue) {
        IParameterProvider parameterProvider = (IParameterProvider)this.parameterProviders.get("options");
        String value = null;
        if (parameterProvider != null && (value = parameterProvider.getStringParameter(name, null)) != null) {
            return value;
        }
        parameterProvider = (IParameterProvider)this.parameterProviders.get("request");
        if (parameterProvider != null && (value = parameterProvider.getStringParameter(name, null)) != null) {
            return value;
        }
        if (parameterProvider != null && (value = parameterProvider.getStringParameter(name, null)) != null) {
            return value;
        }
        return defaultValue;
    }

    public Object getObjectParameter(String name, Object defaultValue) {
        IParameterProvider parameterProvider = (IParameterProvider)this.parameterProviders.get("options");
        Object value = null;
        if (parameterProvider != null && (value = parameterProvider.getParameter(name)) != null) {
            return value;
        }
        parameterProvider = (IParameterProvider)this.parameterProviders.get("request");
        if (parameterProvider != null && (value = parameterProvider.getParameter(name)) != null) {
            return value;
        }
        if (parameterProvider != null && (value = parameterProvider.getParameter(name)) != null) {
            return value;
        }
        return defaultValue;
    }

    public String[] getParameterAsArray(String name) {
        Object value;
        IParameterProvider parameterProvider = (IParameterProvider)this.parameterProviders.get("options");
        if (parameterProvider != null && (value = parameterProvider.getParameter(name)) != null) {
            return this.toStringArray(value);
        }
        parameterProvider = (IParameterProvider)this.parameterProviders.get("request");
        if (parameterProvider != null && (value = parameterProvider.getParameter(name)) != null) {
            return this.toStringArray(value);
        }
        parameterProvider = (IParameterProvider)this.parameterProviders.get("session");
        if (parameterProvider != null && (value = parameterProvider.getParameter(name)) != null) {
            return this.toStringArray(value);
        }
        return new String[0];
    }

    private String[] toStringArray(Object value) {
        if (value == null) {
            return new String[0];
        }
        if (value instanceof String[]) {
            return (String[])value;
        }
        return new String[]{value.toString()};
    }

    protected IPentahoSession getSession() {
        return this.userSession;
    }

    public void setXsl(String mimeType, String xslName) {
        this.contentTypes.put(mimeType, xslName);
    }

    public String getXsl(String mimeType) {
        return (String)this.contentTypes.get(mimeType);
    }

    public abstract boolean validate();

    public boolean validate(IPentahoSession session, IActionRequestHandler actionRequestHandler) {
        this.userSession = session;
        this.genLogIdFromSession(session);
        this.requestHandler = actionRequestHandler;
        return this.validate();
    }

    public void setXslProperty(String name, String value) {
        this.xslProperties.put(name, value);
    }

    public HashMap getXslProperties() {
        return this.xslProperties;
    }

    public abstract String getContent(String var1);

    public void done() {
    }
}

