/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.util;

import com.google.common.collect.ImmutableMap;
import java.awt.Color;
import java.util.Map;

public class ColorHelper {
    private static final Map<String, Color> colors;

    public static Color lookupColor(String col) {
        if (col == null) {
            return null;
        }
        return ColorHelper.lookupColor(col.toLowerCase(), null);
    }

    public static Color lookupColor(String col, Color def) {
        if (col == null) {
            return def;
        }
        Color rtn = colors.get(col.toLowerCase());
        return rtn != null ? rtn : def;
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)"alice blue", (Object)Color.decode("#f0f8ff"));
        builder.put((Object)"antique white", (Object)Color.decode("#faebd7"));
        builder.put((Object)"aquamarine", (Object)Color.decode("#7fffd4"));
        builder.put((Object)"azure", (Object)Color.decode("#f0ffff"));
        builder.put((Object)"beige", (Object)Color.decode("#f5f5dc"));
        builder.put((Object)"bisque", (Object)Color.decode("#ffe4c4"));
        builder.put((Object)"black", (Object)Color.decode("#000000"));
        builder.put((Object)"blanched almond", (Object)Color.decode("#ffebcd"));
        builder.put((Object)"blue", (Object)Color.decode("#0000ff"));
        builder.put((Object)"blue violet", (Object)Color.decode("#8a2be2"));
        builder.put((Object)"brown", (Object)Color.decode("#a52a2a"));
        builder.put((Object)"burlywood", (Object)Color.decode("#deb887"));
        builder.put((Object)"cadet blue", (Object)Color.decode("#5f9ea0"));
        builder.put((Object)"chartreuse", (Object)Color.decode("#7fff00"));
        builder.put((Object)"chocolate", (Object)Color.decode("#d2691e"));
        builder.put((Object)"coral", (Object)Color.decode("#ff7f50"));
        builder.put((Object)"cornflower blue", (Object)Color.decode("#6495ed"));
        builder.put((Object)"cornsilk", (Object)Color.decode("#fff8dc"));
        builder.put((Object)"crimson", (Object)Color.decode("#dc143c"));
        builder.put((Object)"cyan", (Object)Color.decode("#00ffff"));
        builder.put((Object)"dark blue", (Object)Color.decode("#00008b"));
        builder.put((Object)"dark cyan", (Object)Color.decode("#008b8b"));
        builder.put((Object)"dark goldenrod", (Object)Color.decode("#b8860b"));
        builder.put((Object)"dark gray", (Object)Color.decode("#a9a9a9"));
        builder.put((Object)"dark green", (Object)Color.decode("#006400"));
        builder.put((Object)"dark khaki", (Object)Color.decode("#bdb76b"));
        builder.put((Object)"dark magenta", (Object)Color.decode("#8b008b"));
        builder.put((Object)"dark olive green", (Object)Color.decode("#556b2f"));
        builder.put((Object)"dark orange", (Object)Color.decode("#ff8c00"));
        builder.put((Object)"dark orchid", (Object)Color.decode("#9932cc"));
        builder.put((Object)"dark red", (Object)Color.decode("#8b0000"));
        builder.put((Object)"dark salmon", (Object)Color.decode("#e9967a"));
        builder.put((Object)"dark seagreen", (Object)Color.decode("#8dbc8f"));
        builder.put((Object)"dark slate blue", (Object)Color.decode("#483d8b"));
        builder.put((Object)"dark slate gray", (Object)Color.decode("#2f4f4f"));
        builder.put((Object)"dark turquoise", (Object)Color.decode("#00ded1"));
        builder.put((Object)"dark violet", (Object)Color.decode("#9400d3"));
        builder.put((Object)"deep pink", (Object)Color.decode("#ff1493"));
        builder.put((Object)"deep sky blue", (Object)Color.decode("#00bfff"));
        builder.put((Object)"dim gray", (Object)Color.decode("#696969"));
        builder.put((Object)"dodger blue", (Object)Color.decode("#1e90ff"));
        builder.put((Object)"firebrick", (Object)Color.decode("#b22222"));
        builder.put((Object)"floral white", (Object)Color.decode("#fffaf0"));
        builder.put((Object)"forest green", (Object)Color.decode("#228b22"));
        builder.put((Object)"gainsboro", (Object)Color.decode("#dcdcdc"));
        builder.put((Object)"ghost white", (Object)Color.decode("#f8f8ff"));
        builder.put((Object)"gold", (Object)Color.decode("#ffd700"));
        builder.put((Object)"goldenrod", (Object)Color.decode("#daa520"));
        builder.put((Object)"gray", (Object)Color.decode("#808080"));
        builder.put((Object)"green", (Object)Color.decode("#008000"));
        builder.put((Object)"green yellow", (Object)Color.decode("#adff2f"));
        builder.put((Object)"honeydew", (Object)Color.decode("#f0fff0"));
        builder.put((Object)"hot pink", (Object)Color.decode("#ff69b4"));
        builder.put((Object)"indian red", (Object)Color.decode("#cd5c5c"));
        builder.put((Object)"indigo", (Object)Color.decode("#4b0082"));
        builder.put((Object)"ivory", (Object)Color.decode("#fffff0"));
        builder.put((Object)"khaki", (Object)Color.decode("#f0e68c"));
        builder.put((Object)"lavender", (Object)Color.decode("#e6e6fa"));
        builder.put((Object)"lavender blush", (Object)Color.decode("#fff0f5"));
        builder.put((Object)"lawngreen", (Object)Color.decode("#7cfc00"));
        builder.put((Object)"lemon chiffon", (Object)Color.decode("#fffacd"));
        builder.put((Object)"light blue", (Object)Color.decode("#add8e6"));
        builder.put((Object)"light coral", (Object)Color.decode("#f08080"));
        builder.put((Object)"light cyan", (Object)Color.decode("#e0ffff"));
        builder.put((Object)"light goldenrod yellow", (Object)Color.decode("#fafad2"));
        builder.put((Object)"light green", (Object)Color.decode("#90ee90"));
        builder.put((Object)"light grey", (Object)Color.decode("#d3d3d3"));
        builder.put((Object)"light pink", (Object)Color.decode("#ffb6c1"));
        builder.put((Object)"light salmon", (Object)Color.decode("#ffa07a"));
        builder.put((Object)"light seagreen", (Object)Color.decode("#20b2aa"));
        builder.put((Object)"light sky blue", (Object)Color.decode("#87cefa"));
        builder.put((Object)"light slate gray", (Object)Color.decode("#778899"));
        builder.put((Object)"light steel blue", (Object)Color.decode("#b0c4de"));
        builder.put((Object)"light yellow", (Object)Color.decode("#ffffe0"));
        builder.put((Object)"lime", (Object)Color.decode("#00ff00"));
        builder.put((Object)"lime green", (Object)Color.decode("#32cd32"));
        builder.put((Object)"linen", (Object)Color.decode("#faf0e6"));
        builder.put((Object)"magenta", (Object)Color.decode("#ff00ff"));
        builder.put((Object)"maroon", (Object)Color.decode("#800000"));
        builder.put((Object)"medium aquamarine", (Object)Color.decode("#66cdaa"));
        builder.put((Object)"medium blue", (Object)Color.decode("#0000cd"));
        builder.put((Object)"medium orchid", (Object)Color.decode("#ba55d3"));
        builder.put((Object)"medium purple", (Object)Color.decode("#9370db"));
        builder.put((Object)"medium sea green", (Object)Color.decode("#3cb371"));
        builder.put((Object)"medium slate blue", (Object)Color.decode("#7b68ee"));
        builder.put((Object)"medium spring green", (Object)Color.decode("#00fa9a"));
        builder.put((Object)"medium turquoise", (Object)Color.decode("#48d1cc"));
        builder.put((Object)"medium violet red", (Object)Color.decode("#c71585"));
        builder.put((Object)"midnight blue", (Object)Color.decode("#191970"));
        builder.put((Object)"mint cream", (Object)Color.decode("#f5fffa"));
        builder.put((Object)"misty rose", (Object)Color.decode("#ffe4e1"));
        builder.put((Object)"moccasin", (Object)Color.decode("#ffe4b5"));
        builder.put((Object)"navajo white", (Object)Color.decode("#ffdead"));
        builder.put((Object)"navy", (Object)Color.decode("#000080"));
        builder.put((Object)"old lace", (Object)Color.decode("#fdf5e6"));
        builder.put((Object)"olive drab", (Object)Color.decode("#6b8e23"));
        builder.put((Object)"orange", (Object)Color.decode("#ffa500"));
        builder.put((Object)"orange red", (Object)Color.decode("#ff4500"));
        builder.put((Object)"orchid", (Object)Color.decode("#da70d6"));
        builder.put((Object)"pale goldenrod", (Object)Color.decode("#eee8aa"));
        builder.put((Object)"pale green", (Object)Color.decode("#98fb98"));
        builder.put((Object)"pale turquoise", (Object)Color.decode("#afeeee"));
        builder.put((Object)"pale violet red", (Object)Color.decode("#db7093"));
        builder.put((Object)"papaya whip", (Object)Color.decode("#ffefd5"));
        builder.put((Object)"peach puff", (Object)Color.decode("#ffdab9"));
        builder.put((Object)"peru", (Object)Color.decode("#cd853f"));
        builder.put((Object)"pink", (Object)Color.decode("#ffc8cb"));
        builder.put((Object)"plum", (Object)Color.decode("#dda0dd"));
        builder.put((Object)"powder blue", (Object)Color.decode("#b0e0e6"));
        builder.put((Object)"purple", (Object)Color.decode("#800080"));
        builder.put((Object)"red", (Object)Color.decode("#ff0000"));
        builder.put((Object)"rosy brown", (Object)Color.decode("#bc8f8f"));
        builder.put((Object)"royal blue", (Object)Color.decode("#4169e1"));
        builder.put((Object)"saddle brown", (Object)Color.decode("#8b4513"));
        builder.put((Object)"salmon", (Object)Color.decode("#fa8072"));
        builder.put((Object)"sandy brown", (Object)Color.decode("#f4a460"));
        builder.put((Object)"sea green", (Object)Color.decode("#2e8b57"));
        builder.put((Object)"sea shell", (Object)Color.decode("#fff5ee"));
        builder.put((Object)"sienna", (Object)Color.decode("#a0522d"));
        builder.put((Object)"silver", (Object)Color.decode("#c0c0c0"));
        builder.put((Object)"sky blue", (Object)Color.decode("#87ceeb"));
        builder.put((Object)"slate blue", (Object)Color.decode("#6a5acd"));
        builder.put((Object)"snow", (Object)Color.decode("#fffafa"));
        builder.put((Object)"spring green", (Object)Color.decode("#00ff7f"));
        builder.put((Object)"steelblue", (Object)Color.decode("#4682b4"));
        builder.put((Object)"tan", (Object)Color.decode("#d2b48c"));
        builder.put((Object)"teal", (Object)Color.decode("#008080"));
        builder.put((Object)"thistle", (Object)Color.decode("#d8bfd8"));
        builder.put((Object)"tomato", (Object)Color.decode("#ff6347"));
        builder.put((Object)"turquoise", (Object)Color.decode("#40e0d0"));
        builder.put((Object)"violet", (Object)Color.decode("#ee82ee"));
        builder.put((Object)"wheat", (Object)Color.decode("#f5deb3"));
        builder.put((Object)"white", (Object)Color.decode("#ffffff"));
        builder.put((Object)"whitesmoke", (Object)Color.decode("#f5f5f5"));
        builder.put((Object)"yellow", (Object)Color.decode("#ffff00"));
        builder.put((Object)"yellow green", (Object)Color.decode("#9acd32"));
        colors = builder.build();
    }
}

