/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.workitem;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.UUID;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.workitem.IWorkItemLifecycleEvent;
import org.pentaho.platform.util.StringUtil;
import org.pentaho.platform.workitem.WorkItemLifecyclePhase;

@XmlRootElement
public class WorkItemLifecycleEvent
implements IWorkItemLifecycleEvent {
    private static final Log logger = LogFactory.getLog(WorkItemLifecycleEvent.class);
    private String workItemUid;
    private String workItemDetails;
    private WorkItemLifecyclePhase workItemLifecyclePhase;
    private String lifecycleDetails;
    private Date sourceTimestamp;
    private String sourceHostName;
    private String sourceHostIp;
    private static String HOST_NAME;
    private static String HOST_IP;

    public WorkItemLifecycleEvent() {
    }

    public WorkItemLifecycleEvent(String workItemUid, String workItemDetails, WorkItemLifecyclePhase workItemLifecyclePhase, String lifecycleDetails, Date sourceTimestamp) {
        this.workItemUid = workItemUid;
        this.workItemDetails = workItemDetails;
        this.workItemLifecyclePhase = workItemLifecyclePhase;
        this.lifecycleDetails = lifecycleDetails;
        this.sourceTimestamp = sourceTimestamp;
        if (StringUtil.isEmpty(this.workItemUid)) {
            this.workItemUid = UUID.randomUUID().toString();
        }
        if (this.sourceTimestamp == null) {
            this.sourceTimestamp = new Date();
        }
        this.sourceHostName = HOST_NAME;
        this.sourceHostIp = HOST_IP;
    }

    public String getWorkItemUid() {
        return this.workItemUid;
    }

    public void setWorkItemUid(String workItemUid) {
        this.workItemUid = workItemUid;
    }

    public String getWorkItemDetails() {
        return this.workItemDetails;
    }

    public void setWorkItemDetails(String workItemDetails) {
        this.workItemDetails = workItemDetails;
    }

    public WorkItemLifecyclePhase getWorkItemLifecyclePhase() {
        return this.workItemLifecyclePhase;
    }

    public void setWorkItemLifecyclePhase(WorkItemLifecyclePhase workItemLifecyclePhase) {
        this.workItemLifecyclePhase = workItemLifecyclePhase;
    }

    public String getLifecycleDetails() {
        return this.lifecycleDetails;
    }

    public void setLifecycleDetails(String lifecycleDetails) {
        this.lifecycleDetails = lifecycleDetails;
    }

    @XmlJavaTypeAdapter(value=DateAdapter.class)
    public Date getSourceTimestamp() {
        return this.sourceTimestamp;
    }

    public void setSourceTimestamp(Date sourceTimestamp) {
        this.sourceTimestamp = sourceTimestamp;
    }

    public String getSourceHostName() {
        return this.sourceHostName;
    }

    public void setSourceHostName(String sourceHostName) {
        this.sourceHostName = sourceHostName;
    }

    public String getSourceHostIp() {
        return this.sourceHostIp;
    }

    public void setSourceHostIp(String sourceHostIp) {
        this.sourceHostIp = sourceHostIp;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("workItemUid", (Object)this.workItemUid).append("workItemDetails", (Object)this.workItemDetails).append("workItemLifecyclePhase", (Object)this.workItemLifecyclePhase).append("lifecycleDetails", (Object)this.lifecycleDetails).append("sourceTimestamp", (Object)this.sourceTimestamp).append("sourceHostName", (Object)this.sourceHostName).append("sourceHostIp", (Object)this.sourceHostIp).toString();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.getWorkItemUid()).append((Object)this.getWorkItemLifecyclePhase()).toHashCode();
    }

    public boolean equals(Object other) {
        WorkItemLifecycleEvent otherCast = (WorkItemLifecycleEvent)other;
        if (this == otherCast) {
            return true;
        }
        if (otherCast == null) {
            return false;
        }
        return new EqualsBuilder().append((Object)this.getWorkItemUid(), (Object)otherCast.getWorkItemUid()).append((Object)this.getWorkItemLifecyclePhase(), (Object)otherCast.getWorkItemLifecyclePhase()).isEquals();
    }

    static {
        try {
            HOST_NAME = InetAddress.getLocalHost().getCanonicalHostName();
            HOST_IP = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException uhe) {
            logger.error((Object)uhe.getLocalizedMessage());
        }
    }

    public static class DateAdapter
    extends XmlAdapter<String, Date> {
        public String marshal(Date date) throws Exception {
            return date.getTime() + "";
        }

        public Date unmarshal(String dateStr) throws Exception {
            return new Date(Long.parseLong(dateStr));
        }
    }
}

