/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.jfreereport.castormodel.reportspec.types;

import java.util.HashMap;
import java.util.Map;

public enum ChartType {
    AREA("area"),
    BAR("bar"),
    LINE("line"),
    PIE("pie"),
    PIE_MULTI("pie-multi"),
    RING("ring"),
    WATERFALL("waterfall");

    private final String value;
    private static final Map<String, ChartType> enumConstants;

    private ChartType(String value) {
        this.value = value;
    }

    public static ChartType fromValue(String value) {
        ChartType c = enumConstants.get(value);
        if (c != null) {
            return c;
        }
        throw new IllegalArgumentException(value);
    }

    public void setValue(String value) {
    }

    public String toString() {
        return this.value;
    }

    public String value() {
        return this.value;
    }

    static {
        enumConstants = new HashMap<String, ChartType>();
        for (ChartType c : ChartType.values()) {
            enumConstants.put(c.value, c);
        }
    }
}

