/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.jfreereport.functions;

import java.awt.Color;
import org.pentaho.reporting.engine.classic.core.ReportElement;
import org.pentaho.reporting.engine.classic.core.function.AbstractElementFormatFunction;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleKeys;

public class ElementTrafficLightFunction
extends AbstractElementFormatFunction {
    private static final long serialVersionUID = -6498098209717367376L;
    private transient Color colorGreen = new Color(0, 255, 0);
    private transient Color colorYellow = new Color(0, 255, 255);
    private transient Color colorRed = new Color(255, 0, 0);
    private transient double greenValue = 50.0;
    private transient double redValue = 0.0;
    private transient boolean useAbsoluteValue = false;
    private transient boolean useOppositeLogic = false;
    private String field;

    protected boolean evaluateElement(ReportElement element) {
        Color color = this.colorYellow;
        if (this.getDataRow().get(this.field) instanceof Number) {
            Number n = (Number)this.getDataRow().get(this.field);
            double d = n.doubleValue();
            if (this.useAbsoluteValue) {
                d = Math.abs(d);
            }
            if (this.useOppositeLogic) {
                if (d >= this.redValue) {
                    color = this.colorRed;
                } else if (d < this.greenValue) {
                    color = this.colorGreen;
                }
            } else if (d >= this.greenValue) {
                color = this.colorGreen;
            } else if (d < this.redValue) {
                color = this.colorRed;
            }
        }
        element.getStyle().setStyleProperty(ElementStyleKeys.PAINT, (Object)color);
        return true;
    }

    public String getField() {
        return this.field;
    }

    public void setField(String field) {
        if (field == null) {
            throw new NullPointerException();
        }
        this.field = field;
    }

    public Color getColorGreen() {
        return this.colorGreen;
    }

    public void setColorGreen(Color colorGreen) {
        this.colorGreen = colorGreen;
    }

    public Color getColorRed() {
        return this.colorRed;
    }

    public void setColorRed(Color colorRed) {
        this.colorRed = colorRed;
    }

    public Color getColorYellow() {
        return this.colorYellow;
    }

    public void setColorYellow(Color colorYellow) {
        this.colorYellow = colorYellow;
    }

    public double getGreenValue() {
        return this.greenValue;
    }

    public void setGreenValue(double greenValue) {
        this.greenValue = greenValue;
    }

    public double getRedValue() {
        return this.redValue;
    }

    public void setRedValue(double redValue) {
        this.redValue = redValue;
    }

    public Object getValue() {
        return null;
    }

    public boolean isUseAbsoluteValue() {
        return this.useAbsoluteValue;
    }

    public void setUseAbsoluteValue(boolean useAbsoluteValue) {
        this.useAbsoluteValue = useAbsoluteValue;
    }

    public boolean isUseOppositeLogic() {
        return this.useOppositeLogic;
    }

    public void setUseOppositeLogic(boolean useOppositeLogic) {
        this.useOppositeLogic = useOppositeLogic;
    }
}

