/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.admin;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.admin.GatherStatsAction;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.IPentahoSystemListener;
import org.pentaho.platform.api.scheduler2.IJobTrigger;
import org.pentaho.platform.api.scheduler2.IScheduler;
import org.pentaho.platform.api.scheduler2.SimpleJobTrigger;
import org.pentaho.platform.engine.core.system.PentahoSystem;

public class GatherStatsListener
implements IPentahoSystemListener {
    private static final String JOB_NAME = "Gather Stats";
    private String transFileName;
    private static final Log logger = LogFactory.getLog(GatherStatsListener.class);
    private int intervalInSeconds = -1;
    Map<String, Serializable> jobMap = new HashMap<String, Serializable>();

    public void shutdown() {
    }

    public boolean startup(IPentahoSession arg0) {
        try {
            this.scheduleJob(this.intervalInSeconds);
        }
        catch (Exception e) {
            logger.error((Object)"Exception when scheduling stats job", (Throwable)e);
        }
        return true;
    }

    private void scheduleJob(int intervalInSeconds) throws Exception {
        IScheduler scheduler = (IScheduler)PentahoSystem.get(IScheduler.class, (String)"IScheduler2", null);
        SimpleJobTrigger trigger = new SimpleJobTrigger(new Date(), null, -1, (long)intervalInSeconds);
        this.jobMap.put("transFileName", (Serializable)((Object)this.getTransFileName()));
        scheduler.createJob(JOB_NAME, GatherStatsAction.class, this.jobMap, (IJobTrigger)trigger);
        logger.info((Object)"Statistics gathering jop has been scheduled.");
    }

    public int getIntervalInSeconds() {
        return this.intervalInSeconds;
    }

    public String getTransFileName() {
        return this.transFileName;
    }

    public void setTransFileName(String transfileName) {
        this.transFileName = transfileName;
    }

    public void setIntervalInSeconds(int intervalInSeconds) {
        this.intervalInSeconds = intervalInSeconds;
    }
}

