/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.config;

import java.io.File;
import java.io.IOException;
import org.dom4j.Branch;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.pentaho.platform.api.util.XmlParseException;
import org.pentaho.platform.config.DtdEntityResolver;
import org.pentaho.platform.config.IPdiConfig;
import org.pentaho.platform.config.messages.Messages;
import org.pentaho.platform.util.xml.dom4j.XmlDom4JHelper;
import org.xml.sax.EntityResolver;

public class PdiConfigXml
implements IPdiConfig {
    private static final String ROOT_ELEMENT = "kettle-repository";
    private static final String REPOSITORY_FILE_XPATH = "kettle-repository/repositories.xml.file";
    private static final String REPOSITORY_TYPE_XPATH = "kettle-repository/repository.type";
    private static final String REPOSITORY_NAME_XPATH = "kettle-repository/repository.name";
    private static final String REPOSITORY_USER_XPATH = "kettle-repository/repository.userid";
    private static final String REPOSITORY_PWD_XPATH = "kettle-repository/repository.password";
    Document document;

    public PdiConfigXml(File pentahoXmlFile) throws IOException, DocumentException {
        this(XmlDom4JHelper.getDocFromFile((File)pentahoXmlFile, (EntityResolver)new DtdEntityResolver()));
    }

    public PdiConfigXml(String xml) throws DocumentException, XmlParseException {
        this(XmlDom4JHelper.getDocFromString((String)xml, (EntityResolver)new DtdEntityResolver()));
    }

    public PdiConfigXml(Document doc) throws DocumentException {
        Element rootElement = doc.getRootElement();
        if (rootElement != null && !doc.getRootElement().getName().equals(ROOT_ELEMENT)) {
            throw new DocumentException(Messages.getInstance().getErrorString("GoogleMapsConfig.ERROR_0001_INVALID_ROOT_ELEMENT"));
        }
        this.document = doc;
    }

    public PdiConfigXml(IPdiConfig pdiConfig) {
        this();
        this.setRepositoryName(pdiConfig.getRepositoryName());
        this.setRepositoryPassword(pdiConfig.getRepositoryPassword());
        this.setRepositoryType(pdiConfig.getRepositoryType());
        this.setRepositoryUserId(pdiConfig.getRepositoryUserId());
        this.setRepositoryXmlFile(pdiConfig.getRepositoryXmlFile());
    }

    public PdiConfigXml() {
        this.document = DocumentHelper.createDocument();
        this.document.addElement(ROOT_ELEMENT);
    }

    @Override
    public String getRepositoryName() {
        return this.getValue(REPOSITORY_NAME_XPATH);
    }

    @Override
    public String getRepositoryPassword() {
        return this.getValue(REPOSITORY_PWD_XPATH);
    }

    @Override
    public String getRepositoryType() {
        return this.getValue(REPOSITORY_TYPE_XPATH);
    }

    @Override
    public String getRepositoryUserId() {
        return this.getValue(REPOSITORY_USER_XPATH);
    }

    @Override
    public String getRepositoryXmlFile() {
        return this.getValue(REPOSITORY_FILE_XPATH);
    }

    @Override
    public void setRepositoryName(String name) {
        this.setValue(REPOSITORY_NAME_XPATH, name);
    }

    @Override
    public void setRepositoryPassword(String password) {
        this.setValue(REPOSITORY_PWD_XPATH, password);
    }

    @Override
    public void setRepositoryType(String type) {
        this.setValue(REPOSITORY_TYPE_XPATH, type);
    }

    @Override
    public void setRepositoryUserId(String userId) {
        this.setValue(REPOSITORY_USER_XPATH, userId);
    }

    @Override
    public void setRepositoryXmlFile(String xmlFile) {
        this.setValue(REPOSITORY_FILE_XPATH, xmlFile);
    }

    private void setValue(String xPath, String value) {
        Element element = (Element)this.document.selectSingleNode(xPath);
        if (element == null) {
            element = DocumentHelper.makeElement((Branch)this.document, (String)xPath);
        }
        element.setText(value);
    }

    private String getValue(String xpath) {
        Element element = (Element)this.document.selectSingleNode(xpath);
        return element != null ? element.getText() : null;
    }
}

