/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.monitoring;

import com.google.common.eventbus.AsyncEventBus;
import com.google.common.eventbus.EventBus;
import java.util.Collections;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.pentaho.platform.api.engine.IPentahoObjectReference;
import org.pentaho.platform.api.monitoring.IMonitoringEvent;
import org.pentaho.platform.api.monitoring.IMonitoringService;
import org.pentaho.platform.api.monitoring.IMonitoringSubscriber;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.core.system.objfac.references.SingletonPentahoObjectReference;
import org.pentaho.platform.monitoring.subscribers.MonitoringDeadEventSubscriber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MonitoringService
implements IMonitoringService {
    private Logger logger = LoggerFactory.getLogger(MonitoringService.class);
    private AsyncEventBus asyncEventBus = new AsyncEventBus((Executor)Executors.newCachedThreadPool(new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = Executors.defaultThreadFactory().newThread(r);
            thread.setDaemon(true);
            thread.setName("MonitoringService pool");
            return thread;
        }
    }));

    public MonitoringService() {
        PentahoSystem.registerReference((IPentahoObjectReference)((SingletonPentahoObjectReference.Builder)((SingletonPentahoObjectReference.Builder)new SingletonPentahoObjectReference.Builder(EventBus.class).object((Object)this.asyncEventBus)).attributes(Collections.singletonMap("id", "monitoring"))).build(), (Class[])new Class[]{EventBus.class});
        MonitoringDeadEventSubscriber deadEventSubscriber = new MonitoringDeadEventSubscriber();
        this.getAsyncEventBus().register((Object)deadEventSubscriber);
        this.registerMyself();
    }

    public synchronized <T extends IMonitoringSubscriber> void register(T subscriber) {
        this.logger.debug("registering subscriber " + (subscriber != null ? subscriber.getSubscriberId() : "null"));
        this.getAsyncEventBus().register(subscriber);
    }

    public synchronized <T extends IMonitoringSubscriber> void unregister(T subscriber) {
        this.logger.debug("unregistering subscriber " + (subscriber != null ? subscriber.getSubscriberId() : "null"));
        this.getAsyncEventBus().unregister(subscriber);
    }

    public synchronized <T extends IMonitoringEvent> void post(T event) {
        this.logger.debug("posting event " + (event != null ? event.getId() : "null"));
        this.getAsyncEventBus().post(event);
    }

    private AsyncEventBus getAsyncEventBus() {
        return this.asyncEventBus;
    }

    private void registerMyself() {
        if (PentahoSystem.getInitializedOK()) {
            PentahoSystem.registerObject((Object)this);
        }
        if (!PentahoSystem.getInitializedOK() || PentahoSystem.get(IMonitoringService.class) == null) {
            this.logger.error("Unable to register Monitoring Event Bus Service in PentahoSystem");
        }
    }
}

