/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.action.builtin;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Node;
import org.pentaho.platform.api.engine.IActionParameter;
import org.pentaho.platform.api.engine.ISelectionMapper;
import org.pentaho.platform.engine.services.runtime.SelectionMapper;
import org.pentaho.platform.engine.services.solution.ComponentBase;
import org.pentaho.platform.plugin.action.messages.Messages;
import org.pentaho.platform.util.xml.dom4j.XmlDom4JHelper;

public class SecureFilterComponent
extends ComponentBase {
    private static final long serialVersionUID = 7119516440509549539L;
    List selList = new ArrayList();
    List hiddenList = new ArrayList();

    public Log getLogger() {
        return LogFactory.getLog(SecureFilterComponent.class);
    }

    protected boolean validateSystemSettings() {
        return true;
    }

    public boolean validateAction() {
        Node compDef = this.getComponentDefinition();
        List selNodes = compDef.selectNodes("selections/*");
        String inputName = null;
        boolean isOk = true;
        for (Node node : selNodes) {
            try {
                String dispCol;
                String valueCol;
                inputName = node.getName();
                IActionParameter inputParam = this.getInputParameter(inputName);
                String filterType = XmlDom4JHelper.getNodeText((String)"@filter", (Node)node, null);
                String optionalParm = XmlDom4JHelper.getNodeText((String)"@optional", (Node)node, (String)"false");
                boolean isOptional = "true".equals(optionalParm);
                if ("none".equalsIgnoreCase(filterType)) {
                    IActionParameter selectParam = this.getInputParameter(inputName);
                    String title = XmlDom4JHelper.getNodeText((String)"title", (Node)node, (String)inputName);
                    valueCol = "";
                    dispCol = "";
                    String displayStyle = XmlDom4JHelper.getNodeText((String)"@style", (Node)node, null);
                    boolean promptOne = "true".equalsIgnoreCase(XmlDom4JHelper.getNodeText((String)"@prompt-if-one-value", (Node)node, (String)"false"));
                    if ("hidden".equals(displayStyle)) {
                        this.hiddenList.add(new SelEntry(inputParam, selectParam, valueCol, dispCol, title, displayStyle, promptOne, isOptional));
                        continue;
                    }
                    this.selList.add(new SelEntry(inputParam, selectParam, valueCol, dispCol, title, displayStyle, promptOne, isOptional));
                    continue;
                }
                Node filterNode = node.selectSingleNode("filter");
                IActionParameter selectParam = this.getInputParameter(filterNode.getText().trim());
                valueCol = XmlDom4JHelper.getNodeText((String)"@value-col-name", (Node)filterNode, null);
                dispCol = XmlDom4JHelper.getNodeText((String)"@display-col-name", (Node)filterNode, null);
                String title = XmlDom4JHelper.getNodeText((String)"title", (Node)node, null);
                String displayStyle = XmlDom4JHelper.getNodeText((String)"@style", (Node)node, null);
                boolean promptOne = "true".equalsIgnoreCase(XmlDom4JHelper.getNodeText((String)"@prompt-if-one-value", (Node)node, (String)"false"));
                this.selList.add(new SelEntry(inputParam, selectParam, valueCol, dispCol, title, displayStyle, promptOne, isOptional));
            }
            catch (Exception e) {
                isOk = false;
                this.error(Messages.getInstance().getErrorString("SecureFilterComponent.ERROR_0001_PARAM_MISSING", new Object[]{inputName}));
            }
        }
        return isOk;
    }

    public boolean executeAction() {
        boolean parameterUINeeded = false;
        if (this.getOutputPreference() == 1) {
            parameterUINeeded = true;
        }
        boolean stopHere = this.getInputBooleanValue("handle-all-prompts", true);
        boolean isOk = true;
        boolean causingPrompting = false;
        for (SelEntry entry : this.selList) {
            SelectionMapper selMap = SelectionMapper.create((IActionParameter)entry.selectionParam, (String)entry.valueCol, (String)entry.dispCol, (String)entry.title, (String)entry.displayStyle);
            if ((entry.inputParam.hasValue() || entry.inputParam.hasDefaultValue() && !this.feedbackAllowed()) && !parameterUINeeded) {
                Object value = entry.inputParam.getValue();
                if (value instanceof String) {
                    if (selMap == null || selMap.hasValue((String)value) || entry.isOptional && "".equals(value)) continue;
                    this.error(Messages.getInstance().getErrorString("SecureFilterComponent.ERROR_0001_INVALID_SELECTION", new Object[]{entry.inputParam.getValue().toString(), entry.inputParam.getName()}));
                    isOk = false;
                    continue;
                }
                if (value instanceof Object[]) {
                    Object[] values;
                    if (selMap == null) continue;
                    for (Object element : values = (Object[])value) {
                        if (selMap.hasValue(element.toString()) || entry.isOptional && "".equals(value)) continue;
                        this.error(Messages.getInstance().getErrorString("SecureFilterComponent.ERROR_0001_INVALID_SELECTION", new Object[]{entry.inputParam.getValue().toString(), entry.inputParam.getName()}));
                        isOk = false;
                    }
                    continue;
                }
                this.error(Messages.getInstance().getErrorString("SecureFilterComponent.ERROR_0001_INVALID_SELECTION", new Object[]{entry.inputParam.getValue().toString(), entry.inputParam.getName()}));
                isOk = false;
                continue;
            }
            if (selMap == null) {
                entry.createFeedbackParam = true;
                if (entry.isOptional) continue;
                causingPrompting = true;
                continue;
            }
            if (!entry.promptOne && selMap.selectionCount() == 1) {
                entry.inputParam.setValue((Object)selMap.getValueAt(0));
                continue;
            }
            if (!this.feedbackAllowed() && entry.isOptional) {
                isOk = true;
                continue;
            }
            if (!this.feedbackAllowed()) {
                isOk = false;
                continue;
            }
            entry.createFeedbackParam = true;
            entry.selMap = selMap;
            if (entry.isOptional) continue;
            causingPrompting = true;
        }
        if (causingPrompting) {
            for (SelEntry entry : this.selList) {
                if (!entry.createFeedbackParam) continue;
                if (entry.selMap != null) {
                    this.createFeedbackParameter(entry.selMap, entry.inputParam.getName(), entry.inputParam.getValue(), entry.isOptional);
                } else {
                    this.createFeedbackParameter(entry.inputParam.getName(), entry.title, "", entry.inputParam.getValue().toString(), true, entry.isOptional);
                }
                entry.inputParam.setPromptStatus(3);
            }
            this.promptNeeded();
            if (stopHere) {
                this.promptNow();
            }
            for (int i = 0; i < this.hiddenList.size(); ++i) {
                SelEntry entry;
                entry = (SelEntry)this.hiddenList.get(i);
                Object value = entry.inputParam.getValue();
                if (value instanceof String) {
                    this.createFeedbackParameter(entry.inputParam.getName(), entry.inputParam.getName(), "", (String)value, false);
                    continue;
                }
                this.createFeedbackParameter(entry.inputParam.getName(), entry.inputParam.getName(), "", value.toString(), false);
            }
        }
        return isOk;
    }

    public void done() {
    }

    public boolean init() {
        return true;
    }

    class SelEntry {
        IActionParameter inputParam;
        IActionParameter selectionParam;
        String valueCol;
        String dispCol;
        String title;
        String displayStyle;
        boolean promptOne;
        ISelectionMapper selMap;
        boolean isOptional;
        boolean createFeedbackParam = false;

        SelEntry(IActionParameter inputParam, IActionParameter selectionParam, String valueCol, String dispCol, String title, String displayStyle, boolean promptOne, boolean optional) {
            this.inputParam = inputParam;
            this.selectionParam = selectionParam;
            this.valueCol = valueCol;
            this.dispCol = dispCol;
            this.title = title;
            this.displayStyle = displayStyle;
            this.promptOne = promptOne;
            this.isOptional = optional;
        }
    }
}

