/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.action.openflashchart.factory;

import ofc4j.model.elements.LineChart;
import org.dom4j.Node;
import org.pentaho.platform.plugin.action.openflashchart.factory.AbstractChartFactory;

public class LineChartFactory
extends AbstractChartFactory {
    private static final String LINE_WIDTH_NODE_LOC = "line-width";
    private static final String DOTSTYLE_NODE_LOC = "dot-style";
    private static final String DOT_WIDTH_NODE_LOC = "dot-width";
    private static final LineChart.Style LINECHART_STYLE_DEFAULT = LineChart.Style.NORMAL;
    protected LineChart.Style linechartstyle;
    protected Integer linechartwidth;
    protected Integer dotwidth;

    @Override
    protected void createElements() {
        if ("CategoryDataset".equals(this.datasetType)) {
            int columnCount = this.getColumnCount();
            for (int col = 0; col < columnCount; ++col) {
                this.elements.add(this.getLineChartFromColumn(col));
            }
        }
    }

    public LineChart getLineChartFromColumn(int col) {
        LineChart lc = new LineChart(this.linechartstyle);
        for (int row = 0; row < this.getRowCount(); ++row) {
            double d = ((Number)this.getValueAt(row, col)).doubleValue();
            LineChart.Dot dot = new LineChart.Dot((Number)d);
            if (this.dotwidth != null) {
                dot.setDotSize(this.dotwidth);
            }
            lc.addDots(new LineChart.Dot[]{dot});
        }
        if (this.linechartwidth != null) {
            lc.setWidth(this.linechartwidth);
        }
        lc.setColour(this.getColor(col));
        if (this.tooltipText != null) {
            lc.setTooltip(this.tooltipText);
        }
        lc.setText(this.getColumnHeader(col));
        if (null != this.baseURLTemplate) {
            lc.setOn_click(this.baseURLTemplate);
        }
        if (this.alpha != null) {
            lc.setAlpha(this.alpha);
        }
        return lc;
    }

    @Override
    protected void setupStyles() {
        super.setupStyles();
        Node temp = this.chartNode.selectSingleNode(DOTSTYLE_NODE_LOC);
        this.linechartstyle = LineChartFactory.getValue(temp) != null ? ("dot".equals(LineChartFactory.getValue(temp)) ? LineChart.Style.DOT : ("normal".equals(LineChartFactory.getValue(temp)) ? LineChart.Style.NORMAL : ("hollow".equals(LineChartFactory.getValue(temp)) ? LineChart.Style.HOLLOW : LINECHART_STYLE_DEFAULT))) : LINECHART_STYLE_DEFAULT;
        temp = this.chartNode.selectSingleNode(LINE_WIDTH_NODE_LOC);
        if (LineChartFactory.getValue(temp) != null) {
            this.linechartwidth = (int)Double.parseDouble(LineChartFactory.getValue(temp));
        }
        if (LineChartFactory.getValue(temp = this.chartNode.selectSingleNode(DOT_WIDTH_NODE_LOC)) != null) {
            this.dotwidth = Integer.parseInt(LineChartFactory.getValue(temp));
        }
    }
}

