/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.services.metadata;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.pentaho.metadata.model.concept.Concept;
import org.pentaho.metadata.model.concept.IConcept;
import org.pentaho.metadata.model.concept.security.Security;
import org.pentaho.metadata.model.concept.security.SecurityOwner;
import org.pentaho.platform.api.engine.IAclHolder;
import org.pentaho.platform.api.engine.IPentahoAclEntry;
import org.pentaho.platform.engine.security.acls.PentahoAclEntry;
import org.springframework.security.core.authority.SimpleGrantedAuthority;

public class PentahoMetadataAclHolder
implements IAclHolder {
    private List<IPentahoAclEntry> accessControls = new ArrayList<IPentahoAclEntry>();

    public PentahoMetadataAclHolder(IConcept aclHolder) {
        try {
            Security sec = (Security)aclHolder.getProperty(Concept.SECURITY_PROPERTY);
            if (sec != null) {
                Map securityMap = sec.getOwnerAclMap();
                SecurityOwner secOwn = null;
                for (Map.Entry entry : securityMap.entrySet()) {
                    secOwn = (SecurityOwner)entry.getKey();
                    int rights = (Integer)entry.getValue();
                    if (secOwn.getOwnerType() == SecurityOwner.OwnerType.USER) {
                        this.accessControls.add((IPentahoAclEntry)new PentahoAclEntry((Object)secOwn.getOwnerName(), rights));
                        continue;
                    }
                    this.accessControls.add((IPentahoAclEntry)new PentahoAclEntry((Object)new SimpleGrantedAuthority(secOwn.getOwnerName()), rights));
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public List<IPentahoAclEntry> getAccessControls() {
        return this.accessControls;
    }

    public List<IPentahoAclEntry> getEffectiveAccessControls() {
        return this.accessControls;
    }

    public void resetAccessControls(List<IPentahoAclEntry> acls) {
        throw new UnsupportedOperationException("Cannot set Metadata Acls yet");
    }

    public void setAccessControls(List<IPentahoAclEntry> acls) {
        throw new UnsupportedOperationException("Cannot set Metadata Acls yet");
    }
}

