/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.services.pluginmgr;

import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.IOCase;
import org.apache.commons.io.filefilter.NameFileFilter;
import org.dom4j.Document;
import org.dom4j.io.SAXReader;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.IPlatformPlugin;
import org.pentaho.platform.api.engine.PlatformPluginRegistrationException;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.plugin.services.messages.Messages;
import org.pentaho.platform.plugin.services.pluginmgr.PluginMessageLogger;
import org.pentaho.platform.plugin.services.pluginmgr.SystemPathXmlPluginProvider;
import org.pentaho.platform.util.logging.Logger;
import org.pentaho.platform.util.xml.XMLParserFactoryProducer;

public class FileSystemXmlPluginProvider
extends SystemPathXmlPluginProvider {
    @Override
    public List<IPlatformPlugin> getPlugins(IPentahoSession session) throws PlatformPluginRegistrationException {
        File[] kids;
        ArrayList<IPlatformPlugin> plugins = new ArrayList<IPlatformPlugin>();
        String systemPath = PentahoSystem.getApplicationContext().getSolutionPath("system");
        File systemDir = new File(systemPath);
        if (!systemDir.exists() || !systemDir.isDirectory()) {
            throw new PlatformPluginRegistrationException(Messages.getInstance().getErrorString("PluginManager.ERROR_0004_CANNOT_FIND_SYSTEM_FOLDER"));
        }
        for (File kid : kids = systemDir.listFiles()) {
            if (!kid.isDirectory()) continue;
            try {
                this.processDirectory(plugins, kid, session);
            }
            catch (Throwable t) {
                String msg = Messages.getInstance().getErrorString("SystemPathXmlPluginProvider.ERROR_0001_FAILED_TO_PROCESS_PLUGIN", new Object[]{kid.getAbsolutePath()});
                Logger.error((String)this.getClass().toString(), (String)msg, (Throwable)t);
                PluginMessageLogger.add(msg);
            }
        }
        return Collections.unmodifiableList(plugins);
    }

    @Override
    protected void processDirectory(List<IPlatformPlugin> plugins, File folder, IPentahoSession session) throws PlatformPluginRegistrationException {
        Document doc;
        NameFileFilter filter = new NameFileFilter("plugin.xml", IOCase.SENSITIVE);
        File[] kids = folder.listFiles((FilenameFilter)filter);
        if (kids == null || kids.length == 0) {
            return;
        }
        boolean hasLib = false;
        filter = new NameFileFilter("lib", IOCase.SENSITIVE);
        kids = folder.listFiles((FilenameFilter)filter);
        if (kids != null && kids.length > 0) {
            hasLib = kids[0].exists() && kids[0].isDirectory();
        }
        String path = "system" + File.separatorChar + folder.getName() + File.separatorChar + "plugin.xml";
        try {
            File f = new File(PentahoSystem.getApplicationContext().getSolutionPath(path));
            FileInputStream in = new FileInputStream(f);
            SAXReader reader = XMLParserFactoryProducer.getSAXReader(null);
            doc = reader.read((InputStream)in);
            if (doc != null) {
                plugins.add(this.createPlugin(doc, session, folder.getName(), hasLib));
            }
        }
        catch (Exception e) {
            throw new PlatformPluginRegistrationException(Messages.getInstance().getErrorString("PluginManager.ERROR_0005_CANNOT_PROCESS_PLUGIN_XML", new Object[]{path}), (Throwable)e);
        }
        if (doc == null) {
            throw new PlatformPluginRegistrationException(Messages.getInstance().getErrorString("PluginManager.ERROR_0005_CANNOT_PROCESS_PLUGIN_XML", new Object[]{path}));
        }
    }
}

