/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.services.pluginmgr;

import org.pentaho.platform.api.engine.IPentahoPublisher;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.IPentahoSystemListener;
import org.pentaho.platform.api.engine.IPluginManager;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.plugin.services.messages.Messages;
import org.pentaho.platform.plugin.services.pluginmgr.PluginMessageLogger;
import org.pentaho.platform.util.logging.Logger;

public class PluginAdapter
implements IPentahoSystemListener,
IPentahoPublisher {
    public boolean startup(IPentahoSession session) {
        IPluginManager pluginManager = (IPluginManager)PentahoSystem.get(IPluginManager.class, (String)"IPluginManager", (IPentahoSession)session);
        if (pluginManager == null) {
            Logger.error((String)this.getClass().toString(), (String)Messages.getInstance().getErrorString("PluginAdapter.ERROR_0001_PLUGIN_MANAGER_NOT_CONFIGURED"));
            return false;
        }
        pluginManager.reload();
        return true;
    }

    public void shutdown() {
        IPluginManager pluginManager = (IPluginManager)PentahoSystem.get(IPluginManager.class, null);
        if (pluginManager != null) {
            pluginManager.unloadAllPlugins();
        }
    }

    public String getDescription() {
        return Messages.getInstance().getString("PluginAdapter.USER_REFRESH_PLUGINS");
    }

    public String getName() {
        return Messages.getInstance().getString("PluginAdapter.USER_PLUGIN_MANAGER");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String publish(IPentahoSession session, int loggingLevel) {
        try {
            String rtn;
            PluginMessageLogger.clear();
            IPluginManager pluginManager = (IPluginManager)PentahoSystem.get(IPluginManager.class, (String)"IPluginManager", (IPentahoSession)session);
            if (pluginManager == null) {
                Logger.error((String)this.getClass().toString(), (String)Messages.getInstance().getErrorString("PluginAdapter.ERROR_0001_PLUGIN_MANAGER_NOT_CONFIGURED"));
                String string = Messages.getInstance().getString("PluginAdapter.ERROR_0001_PLUGIN_MANAGER_NOT_CONFIGURED");
                return string;
            }
            pluginManager.reload(session);
            String string = rtn = PluginMessageLogger.getAll().toString();
            return string;
        }
        finally {
            PluginMessageLogger.clear();
        }
    }
}

