/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.settings;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;
import java.util.HashSet;

public class PortFileManager {
    private final HashSet<Integer> usedPorts = new HashSet();
    static PortFileManager instance = new PortFileManager();

    private PortFileManager() {
    }

    public static PortFileManager getInstance() {
        if (instance == null) {
            instance = new PortFileManager();
        }
        return instance;
    }

    public boolean addPort(Integer port) {
        return this.usedPorts.add(port);
    }

    public boolean removePort(Integer port) {
        return this.usedPorts.remove(port);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeUsedPortFile(String filePath) throws FileNotFoundException, IOException {
        StringBuilder sb = new StringBuilder();
        for (Integer port : this.usedPorts) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(port.toString());
        }
        File usedPortFile = new File(filePath);
        usedPortFile.getParentFile().mkdirs();
        try (RandomAccessFile fileStore = new RandomAccessFile(usedPortFile, "rw");){
            this.getLock(fileStore);
            fileStore.writeUTF(sb.toString());
        }
    }

    private FileLock getLock(RandomAccessFile fileStore) {
        int retry = 0;
        FileLock lock = null;
        try {
            do {
                if ((lock = fileStore.getChannel().tryLock()) != null) {
                    return lock;
                }
                Thread.sleep(1000L);
            } while (++retry < 20);
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public void clear() {
        this.usedPorts.clear();
    }
}

