/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.web.http;

import java.io.InputStream;
import java.util.Locale;
import org.apache.commons.io.IOUtils;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.IUITemplater;
import org.pentaho.platform.api.util.IVersionHelper;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.services.actionsequence.ActionSequenceResource;
import org.pentaho.platform.util.messages.LocaleHelper;
import org.pentaho.platform.web.http.api.resources.utils.SystemUtils;
import org.pentaho.platform.web.http.messages.Messages;

public class WebTemplateHelper
implements IUITemplater {
    private static String footerTemplate = null;
    private static final String FOOTER_TEMPLATE_FILENAME = "template-footer.html";
    private String headerContent = "";

    public void setHeaderContent(String headerContent) {
        this.headerContent = headerContent;
    }

    public String processTemplate(String template, String title, String content, IPentahoSession session) {
        template = this.processTemplate(template, title, session);
        template = template.replaceFirst("\\{content\\}", content);
        return template;
    }

    public String processTemplate(String template, String title, IPentahoSession session) {
        if (footerTemplate == null) {
            footerTemplate = this.getTemplate(FOOTER_TEMPLATE_FILENAME, session);
        }
        template = template.replaceFirst("\\{footer\\}", footerTemplate);
        template = template.replaceAll("\\{title\\}", title);
        template = template.replaceAll("\\{home\\}", Messages.getInstance().getString("UI.USER_HOME"));
        template = template.replaceAll("\\{navigate\\}", Messages.getInstance().getString("UI.USER_NAVIGATE"));
        template = template.replaceAll("\\{solutions\\}", Messages.getInstance().getString("UI.USER_SOLUTIONS"));
        template = template.replaceAll("\\{file-cache\\}", Messages.getInstance().getString("UI.USER_FILE_CACHE"));
        template = template.replaceAll("\\{new-content\\}", Messages.getInstance().getString("UI.USER_NEW_CONTENT"));
        template = template.replaceAll("\\{file\\}", Messages.getInstance().getString("UI.USER_FILE"));
        template = template.replaceAll("\\{view\\}", Messages.getInstance().getString("UI.USER_VIEW"));
        template = template.replaceAll("\\{nightly\\}", Messages.getInstance().getString("UI.USER_NIGHTLY"));
        template = template.replaceAll("\\{tracker\\}", Messages.getInstance().getString("UI.USER_TRACKER"));
        template = template.replaceAll("\\{new-report\\}", Messages.getInstance().getString("UI.USER_NEW_REPORT"));
        template = template.replaceAll("\\{new-view", Messages.getInstance().getString("UI.USER_NEW_PIVOT"));
        template = template.replaceAll("\\{admin\\}", Messages.getInstance().getString("UI.USER_ADMIN"));
        template = template.replaceAll("\\{about\\}", Messages.getInstance().getString("UI.USER_ABOUT"));
        template = template.replaceAll("\\{pentaho.org\\}", Messages.getInstance().getString("UI.USER_PENTAHO.COM"));
        template = template.replaceAll("\\{close\\}", Messages.getInstance().getString("UI.USER_CLOSE"));
        template = template.replaceAll("\\{forums\\}", Messages.getInstance().getString("UI.USER_FORUMS"));
        template = template.replaceAll("\\{demos\\}", Messages.getInstance().getString("UI.USER_DEMOS"));
        template = template.replaceAll("\\{downloads\\}", Messages.getInstance().getString("UI.USER_DOWNLOADS"));
        template = template.replaceAll("text/html; charset=utf-8", "text/html; charset=" + LocaleHelper.getSystemEncoding());
        template = template.replaceAll("\\{text-direction\\}", LocaleHelper.getTextDirection());
        template = template.replaceAll("\\{logout\\}", Messages.getInstance().getString("UI.USER_LOGOUT"));
        template = template.replaceAll("\\{portal\\}", Messages.getInstance().getString("UI.USER_PORTAL"));
        if (PentahoSystem.getObjectFactory().objectDefined(IVersionHelper.class.getSimpleName())) {
            IVersionHelper versionHelper = (IVersionHelper)PentahoSystem.get(IVersionHelper.class, (IPentahoSession)session);
            template = template.replaceAll("\\{version\\}", "Version: " + versionHelper.getVersionInformation(PentahoSystem.class));
        }
        template = template.replaceAll("\\{system\\}", PentahoSystem.getSystemName());
        template = template.replaceAll("\\{isLoggedIn\\}", session.isAuthenticated() ? "true" : "false");
        template = template.replaceAll("\\{background-alert\\}", session.getBackgroundExecutionAlert() ? "true" : "false");
        template = template.replaceAll("\\{header-content\\}", this.headerContent);
        template = template.replaceAll("\\{body-tag\\}", "");
        template = template.replaceAll("\\{isAdmin\\}", SystemUtils.canAdminister() ? "true" : "false");
        template = template.replaceAll("\\{copyright\\}", Messages.getInstance().getString("UI.USER_COPYRIGHT"));
        return template;
    }

    public String getTemplate(String templateName, IPentahoSession session) {
        String template = null;
        try {
            byte[] bytes = IOUtils.toByteArray((InputStream)ActionSequenceResource.getInputStream((String)("system/custom/" + templateName), (Locale)LocaleHelper.getLocale()));
            template = new String(bytes, LocaleHelper.getSystemEncoding());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (template == null) {
            return Messages.getInstance().getString("UI.ERROR_0001_BAD_TEMPLATE", new Object[]{"system/custom/" + templateName});
        }
        return template;
    }

    public String[] breakTemplate(String templateName, String title, IPentahoSession session) {
        String template = this.getTemplate(templateName, session);
        return this.breakTemplateString(template, title, session);
    }

    public String[] breakTemplateString(String template, String title, IPentahoSession session) {
        String token = "{content}";
        int index = (template = this.processTemplate(template, title, session)).indexOf(token);
        if (index == -1) {
            return new String[]{template};
        }
        String[] sections = new String[]{template.substring(0, index), template.substring(index + token.length())};
        return sections;
    }
}

