/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.web.http.filters;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.pentaho.platform.web.http.messages.Messages;
import org.springframework.beans.factory.InitializingBean;

public class CheckRefererFilter
implements Filter,
InitializingBean {
    private String refererPrefix;
    private String redirectTo;
    private boolean checked;

    public void afterPropertiesSet() throws Exception {
        if (StringUtils.isBlank((String)this.refererPrefix)) {
            throw new ServletException(Messages.getInstance().getErrorString("CheckRefererFilter.ERROR_0001_REFERER_PREFIX_NOT_SPECIFIED"));
        }
        if (StringUtils.isBlank((String)this.redirectTo)) {
            throw new ServletException(Messages.getInstance().getErrorString("CheckRefererFilter.ERROR_0002_REDIRECT_NOT_SPECIFIED"));
        }
        this.checked = true;
    }

    public void setRefererPrefix(String value) {
        this.refererPrefix = value;
    }

    public void setRedirectTo(String value) {
        this.redirectTo = value;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        String header = req.getHeader("referer");
        if (header != null && header.startsWith(this.refererPrefix)) {
            chain.doFilter(request, response);
        } else {
            System.out.println("***** No Referrer: " + req.getRequestURL());
            HttpServletResponse resp = (HttpServletResponse)response;
            resp.sendRedirect(this.redirectTo);
        }
    }

    public void destroy() {
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        String pfx = filterConfig.getInitParameter("refererPrefix");
        String redirect = filterConfig.getInitParameter("redirectTo");
        if (!StringUtils.isBlank((String)pfx)) {
            this.setRefererPrefix(pfx);
        }
        if (!StringUtils.isBlank((String)redirect)) {
            this.setRedirectTo(redirect);
        }
        if (!this.checked) {
            try {
                this.afterPropertiesSet();
            }
            catch (Exception e) {
                throw new ServletException((Throwable)e);
            }
        }
    }
}

