/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.web.http.security;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.authentication.www.BasicAuthenticationEntryPoint;

public class PentahoBasicAuthenticationEntryPoint
extends BasicAuthenticationEntryPoint
implements AuthenticationEntryPoint,
InitializingBean {
    public void commence(HttpServletRequest request, HttpServletResponse response, AuthenticationException authException) throws IOException, ServletException {
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie c : cookies) {
                if (!c.getName().endsWith("session-flushed")) continue;
                c.setMaxAge(0);
                c.setPath(request.getContextPath() != null ? request.getContextPath() : "/");
                response.addCookie(c);
            }
        }
        super.commence(request, response, authException);
    }
}

