/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.web.servlet;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.pentaho.platform.api.engine.IActionRequestHandler;
import org.pentaho.platform.api.engine.IOutputHandler;
import org.pentaho.platform.api.engine.IParameterProvider;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.IPentahoUrlFactory;
import org.pentaho.platform.api.repository.IContentItem;
import org.pentaho.platform.api.ui.IUIComponent;
import org.pentaho.platform.engine.services.BaseRequestHandler;
import org.pentaho.platform.uifoundation.component.BaseUIComponent;
import org.pentaho.platform.web.http.request.HttpRequestParameterProvider;
import org.pentaho.platform.web.http.session.HttpSessionParameterProvider;

public class HttpServletRequestHandler
extends BaseRequestHandler {
    private HttpServletRequest request;

    public HttpServletRequestHandler(IPentahoSession session, String instanceId, HttpServletRequest request, IOutputHandler outputHandler, IPentahoUrlFactory urlFactory) {
        super(session, instanceId, outputHandler, null, urlFactory);
        HttpSessionParameterProvider sessionParameters = new HttpSessionParameterProvider(session);
        this.setParameterProvider("session", (IParameterProvider)sessionParameters);
        this.setRequest(request);
    }

    public void handleUIRequest(IUIComponent component, String contentType) throws IOException {
        IContentItem contentItem = this.getOutputHandler().getOutputContentItem("response", "content", this.getInstanceId(), null);
        OutputStream outputStream = contentItem.getOutputStream(this.getActionPath());
        ((BaseUIComponent)component).setUrlFactory(this.urlFactory);
        component.handleRequest(outputStream, (IActionRequestHandler)this, contentType, this.getParameterProviders());
    }

    public void setRequest(HttpServletRequest request) {
        this.request = request;
        HttpRequestParameterProvider requestParameters = new HttpRequestParameterProvider(request);
        this.setParameterProvider("request", (IParameterProvider)requestParameters);
    }

    public String getStringParameter(String name) {
        return this.request.getParameter(name);
    }

    public Set getParameterNames() {
        return this.request.getParameterMap().keySet();
    }
}

