/*
 * Decompiled with CFR 0.152.
 */
package com.infobright.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class ProcessUtil {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");

    private static String getCmdOutput(InputStream inputStream) {
        StringBuffer buf = new StringBuffer();
        BufferedReader in = new BufferedReader(new InputStreamReader(inputStream));
        try {
            String line = in.readLine();
            while (line != null) {
                buf.append(line);
                buf.append(LINE_SEPARATOR);
            }
        }
        catch (IOException e) {
            return "Operation failed";
        }
        return buf.toString();
    }

    public static void runCommand(String[] commandWithArgs) throws IOException {
        int status;
        Process proc = Runtime.getRuntime().exec(commandWithArgs);
        try {
            status = proc.waitFor();
        }
        catch (InterruptedException inte) {
            String cmdOutput = ProcessUtil.getCmdOutput(proc.getErrorStream());
            throw new IOException(commandWithArgs[0] + " interrupted: " + cmdOutput);
        }
        if (status != 0) {
            String cmdOutput = ProcessUtil.getCmdOutput(proc.getErrorStream());
            throw new IOException(commandWithArgs[0] + " failed: " + cmdOutput);
        }
    }
}

