/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.refinery.publish.util;

import com.google.common.annotations.VisibleForTesting;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.api.client.filter.HTTPBasicAuthFilter;
import com.sun.jersey.core.header.ContentDisposition;
import com.sun.jersey.core.header.FormDataContentDisposition;
import com.sun.jersey.multipart.FormDataMultiPart;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URLEncoder;
import javax.ws.rs.core.MediaType;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.protocol.HttpContext;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.refinery.publish.agilebi.BiServerConnection;
import org.pentaho.di.core.refinery.publish.model.ResponseStatus;
import org.pentaho.di.core.util.EnvUtil;
import org.pentaho.di.core.util.HttpClientManager;
import org.pentaho.di.core.util.HttpClientUtil;

public abstract class BaseRestUtil {
    protected static final String KETTLE_DATA_REFINERY_HTTP_CLIENT_TIMEOUT = "KETTLE_DATA_REFINERY_HTTP_CLIENT_TIMEOUT";

    protected Client getAnonymousClient() {
        DefaultClientConfig clientConfig = new DefaultClientConfig();
        clientConfig.getFeatures().put("com.sun.jersey.api.json.POJOMappingFeature", Boolean.TRUE);
        clientConfig.getProperties().put("com.sun.jersey.client.property.readTimeout", Const.toInt((String)EnvUtil.getSystemProperty((String)KETTLE_DATA_REFINERY_HTTP_CLIENT_TIMEOUT), (int)2000));
        return Client.create((ClientConfig)clientConfig);
    }

    protected Client getAuthenticatedClient(BiServerConnection connection) {
        Client client = this.getAnonymousClient();
        client.addFilter((ClientFilter)new HTTPBasicAuthFilter(connection.getUserId(), connection.getPassword()));
        return client;
    }

    protected WebResource getWebResource(BiServerConnection connection, String restUrl, Client client) {
        String url = connection.getUrl().endsWith("/") ? connection.getUrl() + restUrl : connection.getUrl() + "/" + restUrl;
        return client.resource(url);
    }

    protected ClientResponse httpGet(BiServerConnection connection, String restUrl, boolean authenticate) {
        Client client = this.getAnonymousClient();
        if (authenticate) {
            client = this.getAuthenticatedClient(connection);
        }
        WebResource resource = this.getWebResource(connection, restUrl, client);
        WebResource.Builder builder = this.getDefaultWebResourceBuilder(resource);
        return (ClientResponse)builder.get(ClientResponse.class);
    }

    protected ClientResponse httpPut(BiServerConnection connection, String restUrl, boolean authenticate, Object requestEntity) {
        Client client = this.getAnonymousClient();
        if (authenticate) {
            client = this.getAuthenticatedClient(connection);
        }
        WebResource resource = this.getWebResource(connection, restUrl, client);
        WebResource.Builder builder = this.getDefaultWebResourceBuilder(resource);
        return (ClientResponse)builder.put(ClientResponse.class, requestEntity);
    }

    protected FormDataMultiPart createFileUploadRequest(File file, String repositoryPath) throws Exception {
        FileInputStream in = new FileInputStream(file);
        FormDataMultiPart part = new FormDataMultiPart();
        part.field("importPath", (Object)repositoryPath, MediaType.MULTIPART_FORM_DATA_TYPE).field("fileUpload", (Object)in, MediaType.MULTIPART_FORM_DATA_TYPE).field("overwriteFile", (Object)String.valueOf(true), MediaType.MULTIPART_FORM_DATA_TYPE);
        part.getField("fileUpload").setContentDisposition((ContentDisposition)((FormDataContentDisposition.FormDataContentDispositionBuilder)FormDataContentDisposition.name((String)"fileUpload").fileName(URLEncoder.encode(file.getName(), "UTF-8"))).build());
        return part;
    }

    protected HttpGet createGetMethod(String url) {
        HttpGet get = new HttpGet(url);
        return get;
    }

    protected ResponseStatus simpleHttpGet(BiServerConnection connection, String restUrl, boolean authenticate) {
        ResponseStatus responseStatus = new ResponseStatus();
        HttpContext authContext = null;
        HttpClient client = null;
        client = authenticate ? this.getAuthenticateHttpClient(connection) : this.getSimpleHttpClient();
        String url = connection.getUrl().endsWith("/") ? connection.getUrl() + restUrl : connection.getUrl() + "/" + restUrl;
        HttpGet get = this.createGetMethod(url);
        try {
            HttpResponse response = authContext == null ? client.execute((HttpUriRequest)get) : client.execute((HttpUriRequest)get, authContext);
            responseStatus.setStatus(response.getStatusLine().getStatusCode());
            responseStatus.setMessage(this.getResponseString(response));
        }
        catch (Exception e) {
            responseStatus.setStatus(-1);
            responseStatus.setMessage(e.getMessage());
        }
        return responseStatus;
    }

    @VisibleForTesting
    HttpClient getSimpleHttpClient() {
        return HttpClientManager.getInstance().createDefaultClient();
    }

    @VisibleForTesting
    HttpClient getAuthenticateHttpClient(BiServerConnection connection) {
        HttpClientManager.HttpClientBuilderFacade clientBuilder = HttpClientManager.getInstance().createBuilder();
        clientBuilder.setCredentials(connection.getUserId(), connection.getPassword());
        return clientBuilder.build();
    }

    @VisibleForTesting
    String getResponseString(HttpResponse response) throws IOException {
        return HttpClientUtil.responseToString((HttpResponse)response);
    }

    protected WebResource.Builder getDefaultWebResourceBuilder(WebResource webResource) {
        return (WebResource.Builder)((WebResource.Builder)webResource.type("application/json").type("application/xml")).accept(new String[]{"*/*"});
    }

    private HttpClientContext createAuthContext(BiServerConnection connection) {
        HttpClientContext context = HttpClientContext.create();
        BasicCredentialsProvider provider = new BasicCredentialsProvider();
        UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(connection.getUserId(), connection.getPassword());
        provider.setCredentials(AuthScope.ANY, (Credentials)credentials);
        context.setCredentialsProvider((CredentialsProvider)provider);
        return context;
    }
}

