/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.job.entries.publish;

import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.pentaho.di.base.AbstractMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.refinery.UIBuilder;
import org.pentaho.di.core.refinery.publish.agilebi.BiServerConnection;
import org.pentaho.di.core.refinery.publish.model.DataSourcePublishModel;
import org.pentaho.di.core.refinery.publish.util.ObjectUtils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entries.JobEntryDialogBoilerplate;
import org.pentaho.di.job.entries.publish.JobEntryDatasourcePublish;
import org.pentaho.di.job.entry.JobEntryDialogInterface;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.util.TransUtil;
import org.pentaho.di.ui.core.widget.ComboVar;
import org.pentaho.di.ui.core.widget.TextVar;
import org.pentaho.di.ui.job.entries.common.ConnectionValidator;
import org.pentaho.di.ui.job.entries.common.ServerConnectionGroupWrapper;

public class JobEntryDatasourcePublishDialog
extends JobEntryDialogBoilerplate<JobEntryDatasourcePublish>
implements JobEntryDialogInterface {
    private final int SHELL_MIN_WIDTH = 435;
    private JobMeta jobMeta;
    private JobEntryDatasourcePublish jobEntry;
    private DataSourcePublishModel model;
    private Button bForceOverwrite;
    private ServerConnectionGroupWrapper serverConnectionGroupWrapper;
    private ComboVar wAccessType;
    private TextVar wUserOrRoleAcl;

    public JobEntryDatasourcePublishDialog(Shell parent, JobEntryInterface jobEntry, Repository rep, JobMeta jobMeta) throws KettleException {
        super(parent, jobEntry, rep, jobMeta);
        this.init(jobEntry, jobMeta);
        TransUtil.resetParams((AbstractMeta)jobMeta, jobEntry.getLogChannel());
    }

    protected void init(JobEntryInterface jobEntry, JobMeta jobMeta) throws KettleException {
        this.PKG = JobEntryDatasourcePublish.class;
        this.jobMeta = jobMeta;
        this.jobEntry = (JobEntryDatasourcePublish)jobEntry;
        this.model = this.jobEntry.getDataSourcePublishModel();
        if (this.model == null) {
            this.model = new DataSourcePublishModel();
        }
    }

    protected Composite createModelComposite(Composite main) {
        Composite composite = UIBuilder.createFormComposite(main);
        this.props.setLook((Control)composite);
        this.bForceOverwrite = new Button(composite, 32);
        this.bForceOverwrite.setToolTipText(this.getMsg("JobEntryDatasourcePublish.Overwrite.Tooltip"));
        this.bForceOverwrite.setText(this.getMsg("JobEntryDatasourcePublish.Overwrite.Label"));
        this.props.setLook((Control)this.bForceOverwrite);
        UIBuilder.positionControlBelow((Control)this.bForceOverwrite, null, 0);
        return composite;
    }

    protected Group createServerConnectionGroup(Composite main) {
        this.serverConnectionGroupWrapper = new ServerConnectionGroupWrapper(main, this.props, this.jobMeta, this.jobEntry, this.PKG);
        this.serverConnectionGroupWrapper.addSubmitButtonListener(new Listener(){

            public void handleEvent(Event event) {
                ConnectionValidator connectionValidator = new ConnectionValidator();
                connectionValidator.setConnection(JobEntryDatasourcePublishDialog.this.getDataSourcePublishModel(true).getBiServerConnection());
                connectionValidator.validateConnectionInDesignTime();
            }
        });
        return this.serverConnectionGroupWrapper.getGroup();
    }

    private Group createAclDefinitionGroup(Composite main) {
        Group group = UIBuilder.createFormGroup(main);
        group.setText(this.getMsg("AclDefinition.Group.Label"));
        this.props.setLook((Control)group);
        Label wlAccessType = new Label((Composite)group, 16384);
        wlAccessType.setText(this.getMsg("AclDefinition.AccessType.Label"));
        wlAccessType.setToolTipText(this.getMsg("AclDefinition.AccessType.Tooltip"));
        this.wAccessType = new ComboVar((VariableSpace)this.jobMeta, (Composite)group, 2048);
        this.wAccessType.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JobEntryDatasourcePublishDialog.this.jobEntry.setChanged();
                boolean textFieldEnabled = !JobEntryDatasourcePublishDialog.this.wAccessType.getText().equals(JobEntryDatasourcePublishDialog.this.getMsg("AclDefinition.AccessType.Everyone"));
                JobEntryDatasourcePublishDialog.this.wUserOrRoleAcl.setEnabled(textFieldEnabled);
                if (!textFieldEnabled) {
                    JobEntryDatasourcePublishDialog.this.wUserOrRoleAcl.setText("");
                    JobEntryDatasourcePublishDialog.this.wUserOrRoleAcl.getTextWidget().setBackground(JobEntryDatasourcePublishDialog.this.getParent().getDisplay().getSystemColor(22));
                } else {
                    JobEntryDatasourcePublishDialog.this.wUserOrRoleAcl.setForeground(null);
                    JobEntryDatasourcePublishDialog.this.wUserOrRoleAcl.setBackground(null);
                    JobEntryDatasourcePublishDialog.this.wUserOrRoleAcl.getTextWidget().setBackground(null);
                }
            }
        });
        this.wAccessType.setToolTipText(this.getMsg("AclDefinition.AccessType.Tooltip"));
        this.wAccessType.add(this.getMsg("AclDefinition.AccessType.Everyone"));
        this.wAccessType.add(this.getMsg("AclDefinition.AccessType.User"));
        this.wAccessType.add(this.getMsg("AclDefinition.AccessType.Role"));
        this.props.setLook((Control)wlAccessType);
        this.props.setLook((Control)this.wAccessType);
        Label wlUserOrRoleAcl = new Label((Composite)group, 16384);
        wlUserOrRoleAcl.setText(this.getMsg("AclDefinition.Role.Label"));
        wlUserOrRoleAcl.setToolTipText(this.getMsg("AclDefinition.Role.Tooltip"));
        this.wUserOrRoleAcl = new TextVar((VariableSpace)this.jobMeta, (Composite)group, 2048);
        this.wUserOrRoleAcl.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JobEntryDatasourcePublishDialog.this.jobEntry.setChanged();
            }
        });
        this.wUserOrRoleAcl.setToolTipText(this.getMsg("AclDefinition.Role.Tooltip"));
        this.props.setLook((Control)wlUserOrRoleAcl);
        this.props.setLook((Control)this.wUserOrRoleAcl);
        UIBuilder.positionLabelInputPairBelow(wlAccessType, (Control)this.wAccessType, null, 0, 7);
        ((FormData)this.wAccessType.getLayoutData()).width = 150;
        UIBuilder.positionLabelInputPairBelow(wlUserOrRoleAcl, (Control)this.wUserOrRoleAcl, (Control)this.wAccessType, 10, 7);
        ((FormData)this.wUserOrRoleAcl.getLayoutData()).width = 250;
        return group;
    }

    @Override
    protected void createControls(Shell shell, Control topControl, Control bottomControl, Composite main) {
        Composite modelComposite = this.createModelComposite(main);
        UIBuilder.positionControlBelow((Control)modelComposite, null, 15);
        Group serverGroup = this.createServerConnectionGroup(main);
        UIBuilder.positionControlBelow((Control)serverGroup, (Control)modelComposite, 15);
        Group aclGroup = this.createAclDefinitionGroup(main);
        UIBuilder.positionControlBelow((Control)aclGroup, (Control)serverGroup, 15);
        int minHeight = this.getMinHeight((Composite)shell);
        shell.setMinimumSize(435, minHeight);
        shell.setSize(435, minHeight);
    }

    @Override
    protected String getTitle() {
        return this.getMsg("JobEntryDatasourcePublish.JobName");
    }

    @Override
    protected void loadData(JobEntryDatasourcePublish jobEntry) {
        super.loadData(jobEntry);
        this.model = this.jobEntry.getDataSourcePublishModel();
        if (this.model == null) {
            this.model = new DataSourcePublishModel();
        }
        this.bForceOverwrite.setSelection(this.model.isOverride());
        if (this.model.getUserOrRole() != null) {
            this.wUserOrRoleAcl.setText(this.model.getUserOrRole());
        }
        if (this.model.getAccessType() != null) {
            if (this.model.getAccessType().equals("everyone")) {
                this.wAccessType.select(0);
            } else if (this.model.getAccessType().equals("user")) {
                this.wAccessType.select(1);
            } else if (this.model.getAccessType().equals("role")) {
                this.wAccessType.select(2);
            } else {
                this.wAccessType.setText(this.model.getAccessType());
            }
        } else {
            this.wAccessType.select(0);
        }
        if (this.model.getBiServerConnection() != null) {
            BiServerConnection biServerModel = this.model.getBiServerConnection();
            this.serverConnectionGroupWrapper.setBiServerConnection(biServerModel);
        }
    }

    @Override
    protected void saveData(JobEntryDatasourcePublish jobEntry) {
        super.saveData(jobEntry);
        this.model = this.getDataSourcePublishModel(false);
        DataSourcePublishModel copy = ObjectUtils.deepClone(this.model);
        copy.setModelName("");
        jobEntry.setDataSourcePublishModel(copy);
    }

    protected DataSourcePublishModel getDataSourcePublishModel(boolean resolveVariables) {
        DataSourcePublishModel dataSourcePublishModel = new DataSourcePublishModel();
        dataSourcePublishModel.setOverride(this.bForceOverwrite.getSelection());
        if (resolveVariables) {
            dataSourcePublishModel.setAccessType(this.getAccessTypeCodeFromDescription(this.jobMeta.environmentSubstitute(this.wAccessType.getText())));
            dataSourcePublishModel.setUserOrRole(this.jobMeta.environmentSubstitute(this.wUserOrRoleAcl.getText()));
        } else {
            dataSourcePublishModel.setAccessType(this.getAccessTypeCodeFromDescription(this.wAccessType.getText()));
            dataSourcePublishModel.setUserOrRole(this.wUserOrRoleAcl.getText());
        }
        BiServerConnection biServerModel = this.serverConnectionGroupWrapper.getBiServerConnection(resolveVariables);
        dataSourcePublishModel.setBiServerConnection(biServerModel);
        return dataSourcePublishModel;
    }

    private String getAccessTypeCodeFromDescription(String accessTypeDescription) {
        if (this.getMsg("AclDefinition.AccessType.Everyone").equals(accessTypeDescription)) {
            return "everyone";
        }
        if (this.getMsg("AclDefinition.AccessType.User").equals(accessTypeDescription)) {
            return "user";
        }
        if (this.getMsg("AclDefinition.AccessType.Role").equals(accessTypeDescription)) {
            return "role";
        }
        return accessTypeDescription;
    }

    @Override
    protected String getJobIcon() {
        return "publish.svg";
    }
}

