/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.accessinput;

import java.util.ArrayList;
import java.util.List;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.value.ValueMetaBase;
import org.pentaho.di.core.row.value.ValueMetaFactory;
import org.pentaho.di.trans.step.StepInjectionMetaEntry;
import org.pentaho.di.trans.step.StepMetaInjectionInterface;
import org.pentaho.di.trans.steps.accessinput.AccessInputField;
import org.pentaho.di.trans.steps.accessinput.AccessInputMeta;

public class AccessInputMetaInjection
implements StepMetaInjectionInterface {
    private AccessInputMeta meta;

    public AccessInputMetaInjection(AccessInputMeta meta) {
        this.meta = meta;
    }

    public List<StepInjectionMetaEntry> getStepInjectionMetadataEntries() throws KettleException {
        ArrayList<StepInjectionMetaEntry> all = new ArrayList<StepInjectionMetaEntry>();
        for (Entry entry : Entry.values()) {
            if (entry.getParent() != null || entry.getValueType() == 0) continue;
            all.add(new StepInjectionMetaEntry(entry.name(), entry.getValueType(), entry.getDescription()));
        }
        StepInjectionMetaEntry filesEntry = new StepInjectionMetaEntry(Entry.FILENAME_LINES.name(), 0, Entry.FILENAME_LINES.description);
        all.add(filesEntry);
        StepInjectionMetaEntry fileEntry = new StepInjectionMetaEntry(Entry.FILENAME_LINE.name(), 0, Entry.FILENAME_LINE.description);
        filesEntry.getDetails().add(fileEntry);
        for (Entry entry : Entry.values()) {
            if (entry.getParent() != Entry.FILENAME_LINE) continue;
            StepInjectionMetaEntry metaEntry = new StepInjectionMetaEntry(entry.name(), entry.getValueType(), entry.getDescription());
            fileEntry.getDetails().add(metaEntry);
        }
        StepInjectionMetaEntry fieldsEntry = new StepInjectionMetaEntry(Entry.FIELDS.name(), Entry.FIELDS.getValueType(), Entry.FIELDS.getDescription());
        all.add(fieldsEntry);
        StepInjectionMetaEntry fieldEntry = new StepInjectionMetaEntry(Entry.FIELD.name(), Entry.FIELD.getValueType(), Entry.FIELD.getDescription());
        fieldsEntry.getDetails().add(fieldEntry);
        for (Entry entry : Entry.values()) {
            if (entry.getParent() != Entry.FIELD) continue;
            StepInjectionMetaEntry metaEntry = new StepInjectionMetaEntry(entry.name(), entry.getValueType(), entry.getDescription());
            fieldEntry.getDetails().add(metaEntry);
        }
        return all;
    }

    public void injectStepMetadataEntries(List<StepInjectionMetaEntry> all) throws KettleException {
        ArrayList<AccessInputField> fields = new ArrayList<AccessInputField>();
        ArrayList<FileLine> fileLines = new ArrayList<FileLine>();
        block43: for (StepInjectionMetaEntry lookFields : all) {
            Entry fieldsEntry = Entry.findEntry(lookFields.getKey());
            if (fieldsEntry == null) continue;
            String lookValue = (String)lookFields.getValue();
            switch (fieldsEntry) {
                case FILENAME_LINES: {
                    String value;
                    Entry metaEntry;
                    List entries;
                    Entry fieldEntry;
                    for (StepInjectionMetaEntry lookField : lookFields.getDetails()) {
                        fieldEntry = Entry.findEntry(lookField.getKey());
                        if (fieldEntry != Entry.FILENAME_LINE) continue;
                        FileLine fileLine = new FileLine();
                        entries = lookField.getDetails();
                        for (StepInjectionMetaEntry entry : entries) {
                            metaEntry = Entry.findEntry(entry.getKey());
                            if (metaEntry == null) continue;
                            value = (String)entry.getValue();
                            switch (metaEntry) {
                                case FILENAME: {
                                    fileLine.filename = value;
                                    break;
                                }
                                case FILEMASK: {
                                    fileLine.includeMask = value;
                                    break;
                                }
                                case EXCLUDE_FILEMASK: {
                                    fileLine.excludeMask = value;
                                    break;
                                }
                                case FILE_REQUIRED: {
                                    fileLine.required = value;
                                    break;
                                }
                                case INCLUDE_SUBFOLDERS: {
                                    fileLine.includeSubfolders = value;
                                    break;
                                }
                            }
                        }
                        fileLines.add(fileLine);
                    }
                    continue block43;
                }
                case FIELDS: {
                    String value;
                    Entry metaEntry;
                    List entries;
                    Entry fieldEntry;
                    for (StepInjectionMetaEntry lookField : lookFields.getDetails()) {
                        fieldEntry = Entry.findEntry(lookField.getKey());
                        if (fieldEntry != Entry.FIELD) continue;
                        AccessInputField field = new AccessInputField();
                        entries = lookField.getDetails();
                        for (StepInjectionMetaEntry entry : entries) {
                            metaEntry = Entry.findEntry(entry.getKey());
                            if (metaEntry == null) continue;
                            value = (String)entry.getValue();
                            switch (metaEntry) {
                                case FIELD_NAME: {
                                    field.setName(value);
                                    break;
                                }
                                case FIELD_COLUMN: {
                                    field.setColumn(value);
                                    break;
                                }
                                case FIELD_LENGTH: {
                                    field.setLength(Const.toInt((String)value, (int)-1));
                                    break;
                                }
                                case FIELD_TYPE: {
                                    field.setType(ValueMetaFactory.getIdForValueMeta((String)value));
                                    break;
                                }
                                case FIELD_FORMAT: {
                                    field.setFormat(value);
                                    break;
                                }
                                case FIELD_TRIM_TYPE: {
                                    field.setTrimType(ValueMetaBase.getTrimTypeByCode((String)value));
                                    break;
                                }
                                case FIELD_PRECISION: {
                                    field.setPrecision(Const.toInt((String)value, (int)-1));
                                    break;
                                }
                                case FIELD_DECIMAL: {
                                    field.setDecimalSymbol(value);
                                    break;
                                }
                                case FIELD_GROUP: {
                                    field.setGroupSymbol(value);
                                    break;
                                }
                                case FIELD_CURRENCY: {
                                    field.setCurrencySymbol(value);
                                    break;
                                }
                                case FIELD_REPEAT: {
                                    field.setRepeated("Y".equalsIgnoreCase(value));
                                    break;
                                }
                            }
                        }
                        fields.add(field);
                    }
                    continue block43;
                }
                case INCLUDE_FILENAME: {
                    this.meta.setIncludeFilename("Y".equalsIgnoreCase(lookValue));
                    break;
                }
                case FILENAME_FIELD: {
                    this.meta.setFilenameField(lookValue);
                    break;
                }
                case INCLUDE_ROW_NUMBER: {
                    this.meta.setIncludeRowNumber("Y".equalsIgnoreCase(lookValue));
                    break;
                }
                case ROW_NUMBER_BY_FILE: {
                    this.meta.setResetRowNumber("Y".equalsIgnoreCase(lookValue));
                    break;
                }
                case ROW_NUMBER_FIELD: {
                    this.meta.setRowNumberField(lookValue);
                    break;
                }
                case ROW_LIMIT: {
                    this.meta.setRowLimit(Const.toInt((String)lookValue, (int)-1));
                    break;
                }
                case ACCEPT_FILE_NAMES: {
                    this.meta.setFileField("Y".equalsIgnoreCase(lookValue));
                    break;
                }
                case ACCEPT_FILE_FIELD: {
                    this.meta.setDynamicFilenameField(lookValue);
                    break;
                }
                case ADD_FILES_TO_RESULT: {
                    this.meta.setAddResultFile("Y".equalsIgnoreCase(lookValue));
                    break;
                }
                case FILE_SHORT_FILE_FIELDNAME: {
                    this.meta.setShortFileNameField(lookValue);
                    break;
                }
                case FILE_PATH_FIELDNAME: {
                    this.meta.setPathField(lookValue);
                    break;
                }
                case FILE_HIDDEN_FIELDNAME: {
                    this.meta.setIsHiddenField(lookValue);
                    break;
                }
                case FILE_LAST_MODIFICATION_FIELDNAME: {
                    this.meta.setLastModificationDateField(lookValue);
                    break;
                }
                case FILE_URI_FIELDNAME: {
                    this.meta.setUriField(lookValue);
                    break;
                }
                case FILE_EXTENSION_FIELDNAME: {
                    this.meta.setExtensionField(lookValue);
                    break;
                }
                case FILE_SIZE_FIELDNAME: {
                    this.meta.setSizeField(lookValue);
                    break;
                }
                case TABLENAME: {
                    this.meta.setTableName(lookValue);
                    break;
                }
                case INCLUDE_TABLENAME: {
                    this.meta.setIncludeTablename("Y".equalsIgnoreCase(lookValue));
                    break;
                }
                case TABLENAME_FIELD: {
                    this.meta.setTableName(lookValue);
                    break;
                }
            }
        }
        if (fields.size() > 0) {
            this.meta.setInputFields(fields.toArray(new AccessInputField[fields.size()]));
        }
        if (fileLines.size() > 0) {
            this.meta.allocateFiles(fileLines.size());
            for (int i = 0; i < fileLines.size(); ++i) {
                FileLine fileLine = (FileLine)fileLines.get(i);
                this.meta.getFileName()[i] = fileLine.filename;
                this.meta.getFileMask()[i] = fileLine.includeMask;
                this.meta.getExludeFileMask()[i] = fileLine.excludeMask;
                this.meta.getExludeFileMask()[i] = fileLine.excludeMask;
                this.meta.getFileRequired()[i] = fileLine.required;
                this.meta.getIncludeSubFolders()[i] = fileLine.includeSubfolders;
            }
        }
    }

    public List<StepInjectionMetaEntry> extractStepMetadataEntries() throws KettleException {
        return null;
    }

    public AccessInputMeta getMeta() {
        return this.meta;
    }

    public class ExcelInputSheet {
        public String sheetName;
        public int startCol;
        public int startRow;

        private ExcelInputSheet(String sheetName, int startCol, int startRow) {
            this.sheetName = sheetName;
            this.startCol = startCol;
            this.startRow = startRow;
        }
    }

    private static enum Entry {
        FILENAME_LINES(0, "The list of file definitions"),
        FILENAME_LINE(0, "One file definition line"),
        FILENAME(FILENAME_LINE, 2, "The filename or directory"),
        FILEMASK(FILENAME_LINE, 2, "The file mask (regex)"),
        EXCLUDE_FILEMASK(FILENAME_LINE, 2, "The mask for the files to exclude (regex)"),
        FILE_REQUIRED(FILENAME_LINE, 2, "Is this a required file (Y/N)"),
        INCLUDE_SUBFOLDERS(FILENAME_LINE, 2, "Include sub-folders when searching files? (Y/N)"),
        INCLUDE_FILENAME(2, "Include filename in the output? (Y/N)"),
        FILENAME_FIELD(2, "The name of the filename field in the output"),
        INCLUDE_TABLENAME(2, "Include the table name in the output? (Y/N)"),
        TABLENAME_FIELD(2, "The name of the table name field in the output"),
        INCLUDE_ROW_NUMBER(2, "Include a row number in the output? (Y/N)"),
        ROW_NUMBER_BY_FILE(2, "Reset the row number for each file? (Y/N)"),
        ROW_NUMBER_FIELD(2, "The name of the row number field in the output"),
        TABLENAME(2, "The name of the table to retrieve data from"),
        ROW_LIMIT(2, "The maximum number of lines to read."),
        FIELDS(0, "All the fields on the spreadsheets"),
        FIELD(0, "One field"),
        FIELD_NAME(FIELD, 2, "Field name"),
        FIELD_COLUMN(FIELD, 2, "Field source column name"),
        FIELD_TYPE(FIELD, 2, "Field data type"),
        FIELD_LENGTH(FIELD, 2, "Field length"),
        FIELD_PRECISION(FIELD, 2, "Field precision"),
        FIELD_TRIM_TYPE(FIELD, 2, "Field trim type (none, left, right, both)"),
        FIELD_FORMAT(FIELD, 2, "Field conversion format"),
        FIELD_CURRENCY(FIELD, 2, "Field currency symbol"),
        FIELD_DECIMAL(FIELD, 2, "Field decimal symbol"),
        FIELD_GROUP(FIELD, 2, "Field group symbol"),
        FIELD_REPEAT(FIELD, 2, "Field repeat (Y/N)"),
        ACCEPT_FILE_NAMES(2, "Accept file names? (Y/N)"),
        ACCEPT_FILE_FIELD(2, "The input field for the file names"),
        ADD_FILES_TO_RESULT(2, "Add file names to the result files? (Y/N)"),
        FILE_SHORT_FILE_FIELDNAME(2, "The short file output fieldname"),
        FILE_PATH_FIELDNAME(2, "The path output fieldname"),
        FILE_HIDDEN_FIELDNAME(2, "The hidden output fieldname"),
        FILE_LAST_MODIFICATION_FIELDNAME(2, "The last modification time output fieldname"),
        FILE_URI_FIELDNAME(2, "The URI output fieldname"),
        FILE_EXTENSION_FIELDNAME(2, "The extension output fieldname"),
        FILE_SIZE_FIELDNAME(2, "The file size output fieldname");

        private int valueType;
        private String description;
        private Entry parent;

        private Entry(int valueType, String description) {
            this.valueType = valueType;
            this.description = description;
        }

        private Entry(Entry parent, int valueType, String description) {
            this.parent = parent;
            this.valueType = valueType;
            this.description = description;
        }

        public int getValueType() {
            return this.valueType;
        }

        public String getDescription() {
            return this.description;
        }

        public static Entry findEntry(String key) {
            return Entry.valueOf(key);
        }

        public Entry getParent() {
            return this.parent;
        }
    }

    private class FileLine {
        String filename;
        String includeMask;
        String excludeMask;
        String required;
        String includeSubfolders;

        private FileLine() {
        }
    }
}

