/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.marketplace.domain.model.entities;

import org.pentaho.marketplace.domain.model.entities.interfaces.IVersionData;

public class VersionData
implements IVersionData {
    private int major;
    private int minor;
    private int patch;
    private String info;

    public VersionData(String info) {
        int majorStop;
        this.info = info;
        if (this.info == null) {
            this.info = "";
        }
        if ((majorStop = this.info.indexOf(".")) >= 0) {
            try {
                this.major = Integer.parseInt(this.info.substring(0, majorStop));
            }
            catch (Exception e) {
                this.major = Integer.MAX_VALUE;
                this.minor = Integer.MAX_VALUE;
                this.patch = Integer.MAX_VALUE;
                return;
            }
            int minorStop = this.info.indexOf(".", majorStop + 1);
            if (minorStop >= 0) {
                try {
                    this.minor = Integer.parseInt(this.info.substring(majorStop + 1, minorStop));
                }
                catch (Exception e) {
                    this.minor = Integer.MAX_VALUE;
                    this.patch = Integer.MAX_VALUE;
                    return;
                }
                int patchStop = this.info.indexOf(".", minorStop + 1);
                if (patchStop < 0) {
                    patchStop = this.info.indexOf("-", minorStop + 1);
                }
                if (patchStop < 0) {
                    patchStop = this.info.length();
                }
                try {
                    this.patch = Integer.parseInt(this.info.substring(minorStop + 1, patchStop));
                }
                catch (Exception e) {
                    this.patch = Integer.MAX_VALUE;
                    return;
                }
            }
            minorStop = this.info.indexOf("-", majorStop + 1);
            if (minorStop >= 0) {
                try {
                    this.minor = Integer.parseInt(this.info.substring(majorStop + 1, minorStop));
                }
                catch (Exception e) {
                    this.minor = Integer.MAX_VALUE;
                    this.patch = Integer.MAX_VALUE;
                    return;
                }
                this.patch = Integer.MAX_VALUE;
                return;
            }
            minorStop = this.info.length();
            try {
                this.minor = Integer.parseInt(this.info.substring(majorStop + 1, minorStop));
            }
            catch (Exception e) {
                this.minor = Integer.MAX_VALUE;
                this.patch = Integer.MAX_VALUE;
                return;
            }
            this.patch = 0;
            return;
        }
        majorStop = this.info.indexOf("-");
        if (majorStop >= 0) {
            try {
                this.major = Integer.parseInt(this.info.substring(0, majorStop));
            }
            catch (Exception e) {
                this.major = Integer.MAX_VALUE;
                this.minor = Integer.MAX_VALUE;
                this.patch = Integer.MAX_VALUE;
                return;
            }
            this.minor = Integer.MAX_VALUE;
            this.patch = Integer.MAX_VALUE;
            return;
        }
        try {
            this.major = Integer.parseInt(this.info);
        }
        catch (Exception e) {
            this.major = Integer.MAX_VALUE;
            this.minor = Integer.MAX_VALUE;
            this.patch = Integer.MAX_VALUE;
            return;
        }
        this.minor = 0;
        this.patch = 0;
        return;
    }

    @Override
    public int getMajor() {
        return this.major;
    }

    @Override
    public int getMinor() {
        return this.minor;
    }

    @Override
    public int getPatch() {
        return this.patch;
    }

    @Override
    public String getInfo() {
        return this.info;
    }

    @Override
    public boolean within(IVersionData min, IVersionData max) {
        if (min.getInfo().equals("") && max.getInfo().equals("")) {
            return true;
        }
        if (min.getInfo().equals(max.getInfo())) {
            return this.info.equals(min.getInfo());
        }
        return this.compareTo(min) <= 0 && this.compareTo(max) >= 0;
    }

    @Override
    public int compareTo(IVersionData versionData) {
        if (versionData.getMajor() > this.major) {
            return 1;
        }
        if (versionData.getMajor() < this.major) {
            return -1;
        }
        if (versionData.getMinor() > this.minor) {
            return 1;
        }
        if (versionData.getMinor() < this.minor) {
            return -1;
        }
        if (versionData.getPatch() > this.patch) {
            return 1;
        }
        if (versionData.getPatch() < this.patch) {
            return -1;
        }
        return 0;
    }
}

