/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.marketplace.endpoints.dtos.mappers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.pentaho.marketplace.domain.model.entities.DevelopmentStage;
import org.pentaho.marketplace.domain.model.entities.interfaces.IDevelopmentStage;
import org.pentaho.marketplace.domain.model.entities.interfaces.IPluginVersion;
import org.pentaho.marketplace.domain.model.factories.interfaces.IPluginVersionFactory;
import org.pentaho.marketplace.endpoints.dtos.entities.PluginVersionDTO;
import org.pentaho.marketplace.endpoints.dtos.mappers.interfaces.IPluginVersionDTOMapper;

public class PluginVersionDTOMapper
implements IPluginVersionDTOMapper {
    IPluginVersionFactory pluginVersionFactory;

    public PluginVersionDTOMapper(IPluginVersionFactory pluginVersionFactory) {
        this.pluginVersionFactory = pluginVersionFactory;
    }

    @Override
    public IPluginVersion toEntity(PluginVersionDTO dto) {
        IPluginVersion pluginVersion = (IPluginVersion)this.pluginVersionFactory.create();
        pluginVersion.setBranch(dto.branch);
        pluginVersion.setName(dto.name);
        pluginVersion.setVersion(dto.version);
        pluginVersion.setDownloadUrl(dto.downloadUrl);
        pluginVersion.setSamplesDownloadUrl(dto.samplesDownloadUrl);
        pluginVersion.setDescription(dto.description);
        pluginVersion.setChangelog(dto.changelog);
        pluginVersion.setBuildId(dto.buildId);
        pluginVersion.setReleaseDate(dto.releaseDate);
        pluginVersion.setMinParentVersion(dto.minParentVersion);
        pluginVersion.setMaxParentVersion(dto.maxParentVersion);
        DevelopmentStage devStage = new DevelopmentStage(dto.developmentStageLane, dto.developmentStagePhase);
        pluginVersion.setDevelopmentStage(devStage);
        return pluginVersion;
    }

    @Override
    public PluginVersionDTO toDTO(IPluginVersion pluginVersion) {
        PluginVersionDTO dto = new PluginVersionDTO();
        dto.branch = pluginVersion.getBranch();
        dto.name = pluginVersion.getName();
        dto.version = pluginVersion.getVersion();
        dto.downloadUrl = pluginVersion.getDownloadUrl();
        dto.samplesDownloadUrl = pluginVersion.getSamplesDownloadUrl();
        dto.description = pluginVersion.getDescription();
        dto.changelog = pluginVersion.getChangelog();
        dto.buildId = pluginVersion.getBuildId();
        dto.releaseDate = pluginVersion.getReleaseDate();
        dto.minParentVersion = pluginVersion.getMinParentVersion();
        dto.maxParentVersion = pluginVersion.getMaxParentVersion();
        IDevelopmentStage devStage = pluginVersion.getDevelopmentStage();
        if (devStage != null) {
            dto.developmentStageLane = devStage.getLane();
            dto.developmentStagePhase = devStage.getPhase();
        }
        return dto;
    }

    @Override
    public Collection<IPluginVersion> toEntities(List<PluginVersionDTO> dtos) {
        ArrayList<IPluginVersion> pluginVersions = new ArrayList<IPluginVersion>();
        for (PluginVersionDTO dto : dtos) {
            pluginVersions.add(this.toEntity(dto));
        }
        return pluginVersions;
    }

    @Override
    public List<PluginVersionDTO> toDTOs(Collection<IPluginVersion> pluginVersions) {
        ArrayList<PluginVersionDTO> pluginVersionDTOs = new ArrayList<PluginVersionDTO>();
        for (IPluginVersion pluginVersion : pluginVersions) {
            pluginVersionDTOs.add(this.toDTO(pluginVersion));
        }
        return pluginVersionDTOs;
    }
}

