/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.telemetry;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.concurrent.BlockingQueue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.telemetry.TelemetryEvent;

public class TelemetryEventKeeper
implements Runnable {
    protected static final String FILE_EXT = ".tel";
    private static final String UNABLE_TO_CREATE_FILE_MESSAGE = "Unable to create file for telemetry event";
    private static final String ERROR_CREATING_FILE_MESSAGE = "Error while creating file for telemetry event";
    private static final Log logger = LogFactory.getLog(TelemetryEventKeeper.class);
    private BlockingQueue<TelemetryEvent> eventQueue;
    private String telemetryDirPath;

    protected Log getLogger() {
        return logger;
    }

    protected BlockingQueue<TelemetryEvent> getEventQueue() {
        return this.eventQueue;
    }

    protected void setEventQueue(BlockingQueue<TelemetryEvent> eventQueue) {
        this.eventQueue = eventQueue;
    }

    protected String getTelemetryDirPath() {
        return this.telemetryDirPath;
    }

    protected void setTelemetryDirPath(String telemetryDirPath) {
        this.telemetryDirPath = telemetryDirPath;
    }

    public TelemetryEventKeeper(BlockingQueue<TelemetryEvent> eventQueue, File telemetryDir) {
        this.setEventQueue(eventQueue);
        this.setTelemetryDirPath(telemetryDir.getAbsolutePath());
    }

    @Override
    public void run() {
        try {
            while (true) {
                this.processEvent();
            }
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }

    protected void processEvent() throws InterruptedException {
        BlockingQueue<TelemetryEvent> eventQueue = this.getEventQueue();
        TelemetryEvent event = eventQueue.take();
        try {
            String filename = System.currentTimeMillis() + FILE_EXT;
            FileOutputStream fout = new FileOutputStream(this.getTelemetryDirPath() + "/" + filename);
            ObjectOutputStream oos = new ObjectOutputStream(fout);
            oos.writeObject(event);
            oos.close();
        }
        catch (FileNotFoundException fnfe) {
            this.getLogger().warn((Object)UNABLE_TO_CREATE_FILE_MESSAGE, (Throwable)fnfe);
        }
        catch (IOException ioe) {
            this.getLogger().error((Object)ERROR_CREATING_FILE_MESSAGE, (Throwable)ioe);
        }
    }
}

