/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.getxmldata;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.vfs2.FileObject;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleFileException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.steps.getxmldata.GetXMLData;
import org.pentaho.di.trans.steps.getxmldata.GetXMLDataMeta;
import org.pentaho.metaverse.api.IAnalysisContext;
import org.pentaho.metaverse.api.analyzer.kettle.step.BaseStepExternalResourceConsumer;
import org.pentaho.metaverse.api.model.ExternalResourceInfoFactory;
import org.pentaho.metaverse.api.model.IExternalResourceInfo;

public class GetXMLDataExternalResourceConsumer
extends BaseStepExternalResourceConsumer<GetXMLData, GetXMLDataMeta> {
    public boolean isDataDriven(GetXMLDataMeta meta) {
        return meta.isInFields();
    }

    public Collection<IExternalResourceInfo> getResourcesFromMeta(GetXMLDataMeta meta, IAnalysisContext context) {
        String[] paths;
        TransMeta parentTransMeta;
        StepMeta parentStepMeta;
        List<IExternalResourceInfo> resources = Collections.emptyList();
        if (!this.isDataDriven(meta) && (parentStepMeta = meta.getParentStepMeta()) != null && (parentTransMeta = parentStepMeta.getParentTransMeta()) != null && (paths = parentTransMeta.environmentSubstitute(meta.getFileName())) != null) {
            resources = new ArrayList<IExternalResourceInfo>(paths.length);
            for (String path : paths) {
                if (Utils.isEmpty((CharSequence)path)) continue;
                try {
                    IExternalResourceInfo resource = ExternalResourceInfoFactory.createFileResource((FileObject)KettleVFS.getFileObject((String)path), (boolean)true);
                    if (resource == null) {
                        throw new KettleFileException("Error getting file resource!");
                    }
                    resources.add(resource);
                }
                catch (KettleFileException kettleFileException) {
                    // empty catch block
                }
            }
        }
        return resources;
    }

    public Collection<IExternalResourceInfo> getResourcesFromRow(GetXMLData textFileInput, RowMetaInterface rowMeta, Object[] row) {
        LinkedList<IExternalResourceInfo> resources = new LinkedList<IExternalResourceInfo>();
        GetXMLDataMeta meta = (GetXMLDataMeta)textFileInput.getStepMetaInterface();
        if (meta == null) {
            meta = (GetXMLDataMeta)textFileInput.getStepMeta().getStepMetaInterface();
        }
        try {
            if (meta.getIsAFile()) {
                String filename;
                String string = filename = meta == null ? null : rowMeta.getString(row, meta.getXMLField(), null);
                if (!Utils.isEmpty(filename)) {
                    FileObject fileObject = KettleVFS.getFileObject((String)filename);
                    resources.add(ExternalResourceInfoFactory.createFileResource((FileObject)fileObject, (boolean)true));
                }
            }
        }
        catch (KettleException kettleException) {
            // empty catch block
        }
        return resources;
    }

    public Class<GetXMLDataMeta> getMetaClass() {
        return GetXMLDataMeta.class;
    }
}

