/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.osgi.legacy;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.osgi.framework.BundleContext;
import org.osgi.framework.wiring.BundleWiring;
import org.pentaho.di.core.exception.KettlePluginException;
import org.pentaho.di.core.plugins.PluginInterface;
import org.pentaho.di.core.plugins.PluginRegistry;

public class LegacyPluginExtenderFactory {
    private final ClassLoader legacyBridgingClassloader;

    public LegacyPluginExtenderFactory(BundleContext bundleContext, String pluginType, String pluginId) throws KettlePluginException {
        ClassLoader parentClassloader = LegacyPluginExtenderFactory.getPluginClassloader(pluginType, pluginId);
        if (parentClassloader == null) {
            throw new KettlePluginException("Unable to get parent classloader for pluginType: " + pluginType + " and pluginId " + pluginId);
        }
        System.out.println("Parent classloader: " + parentClassloader);
        this.legacyBridgingClassloader = new LegacyPluginExtenderClassLoader(parentClassloader, bundleContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ClassLoader getPluginClassloader(String pluginType, String pluginId) throws KettlePluginException {
        Class pluginTypeInterface = null;
        PluginRegistry pluginRegistry = PluginRegistry.getInstance();
        while (true) {
            PluginRegistry pluginRegistry2 = pluginRegistry;
            synchronized (pluginRegistry2) {
                PluginInterface plugin;
                if (pluginTypeInterface == null) {
                    for (Class potentialPluginTypeInterface : pluginRegistry.getPluginTypes()) {
                        if (!pluginType.equals(potentialPluginTypeInterface.getCanonicalName())) continue;
                        pluginTypeInterface = potentialPluginTypeInterface;
                    }
                }
                if ((plugin = pluginRegistry.getPlugin(pluginTypeInterface, pluginId)) != null) {
                    return pluginRegistry.getClassLoader(plugin);
                }
                try {
                    pluginRegistry.wait();
                }
                catch (InterruptedException e) {
                    throw new KettlePluginException((Throwable)e);
                }
            }
        }
    }

    public Object create(String className) throws ClassNotFoundException, InvocationTargetException, IllegalAccessException, InstantiationException {
        return this.create(className, null);
    }

    public Object create(String className, List<Object> arguments) throws ClassNotFoundException, IllegalAccessException, InstantiationException, InvocationTargetException {
        Class<?> clazz = Class.forName(className, true, this.legacyBridgingClassloader);
        if (arguments == null || arguments.size() == 0) {
            return clazz.newInstance();
        }
        for (Constructor<?> constructor : clazz.getConstructors()) {
            Class<?>[] parameterTypes = constructor.getParameterTypes();
            if (parameterTypes.length != arguments.size()) continue;
            boolean match = true;
            for (int i = 0; i < parameterTypes.length; ++i) {
                Object o = arguments.get(i);
                if (o == null || parameterTypes[i].isInstance(o)) continue;
                match = false;
                break;
            }
            if (!match) continue;
            return constructor.newInstance(arguments.toArray());
        }
        throw new InstantiationException("Unable to find constructor for class " + className + " with arguments " + arguments);
    }

    private static class PublicLoadResolveClassLoader
    extends ClassLoader {
        public PublicLoadResolveClassLoader(ClassLoader parent) {
            super(parent);
        }

        @Override
        public Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
            return super.loadClass(name, resolve);
        }
    }

    private static class LegacyPluginExtenderClassLoader
    extends ClassLoader {
        private final BundleWiring bundleWiring;
        private final PublicLoadResolveClassLoader bundleWiringClassloader;

        public LegacyPluginExtenderClassLoader(ClassLoader parentClassLoader, BundleContext bundleContext) {
            super(parentClassLoader);
            this.bundleWiring = (BundleWiring)bundleContext.getBundle().adapt(BundleWiring.class);
            this.bundleWiringClassloader = new PublicLoadResolveClassLoader(this.bundleWiring.getClassLoader());
        }

        @Override
        protected Class<?> findClass(String name) throws ClassNotFoundException {
            String translatedName;
            int lastIndexOfDot = name.lastIndexOf(46);
            String translatedPath = "/" + name.substring(0, lastIndexOfDot).replace('.', '/');
            List entries = this.bundleWiring.findEntries(translatedPath, translatedName = name.substring(lastIndexOfDot + 1) + ".class", 0);
            if (entries.size() == 1) {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                try {
                    IOUtils.copy((InputStream)((URL)entries.get(0)).openStream(), (OutputStream)byteArrayOutputStream);
                }
                catch (IOException e) {
                    throw new ClassNotFoundException("Unable to define class", e);
                }
                byte[] bytes = byteArrayOutputStream.toByteArray();
                return this.defineClass(name, bytes, 0, bytes.length);
            }
            throw new ClassNotFoundException();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
            Class<?> result = null;
            LegacyPluginExtenderClassLoader legacyPluginExtenderClassLoader = this;
            synchronized (legacyPluginExtenderClassLoader) {
                result = this.findLoadedClass(name);
            }
            if (result == null) {
                try {
                    result = this.findClass(name);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (result == null) {
                try {
                    return this.bundleWiringClassloader.loadClass(name, resolve);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (result == null) {
                return super.loadClass(name, resolve);
            }
            if (resolve) {
                this.resolveClass(result);
            }
            return result;
        }
    }
}

