/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.big.data.impl.shim.mapreduce;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.pentaho.big.data.impl.shim.mapreduce.TaskCompletionEventImpl;
import org.pentaho.bigdata.api.mapreduce.MapReduceJobAdvanced;
import org.pentaho.bigdata.api.mapreduce.MapReduceService;
import org.pentaho.bigdata.api.mapreduce.TaskCompletionEvent;
import org.pentaho.hadoop.shim.api.mapred.RunningJob;

public class RunningJobMapReduceJobAdvancedImpl
implements MapReduceJobAdvanced {
    private final RunningJob runningJob;

    public RunningJobMapReduceJobAdvancedImpl(RunningJob runningJob) {
        this.runningJob = runningJob;
    }

    public void killJob() throws IOException {
        this.runningJob.killJob();
    }

    public boolean waitOnCompletion(long timeout, TimeUnit timeUnit, MapReduceService.Stoppable stoppable) throws IOException, InterruptedException {
        long sleepTime;
        long stopTime = System.currentTimeMillis() + timeUnit.toMillis(timeout);
        while (!stoppable.isStopped() && (sleepTime = Math.min(50L, stopTime - System.currentTimeMillis())) > 0L && !this.runningJob.isComplete()) {
            Thread.sleep(Math.max(0L, sleepTime));
        }
        return this.runningJob.isComplete();
    }

    public double getSetupProgress() throws IOException {
        return this.runningJob.setupProgress();
    }

    public double getMapProgress() throws IOException {
        return this.runningJob.mapProgress();
    }

    public double getReduceProgress() throws IOException {
        return this.runningJob.reduceProgress();
    }

    public boolean isSuccessful() throws IOException {
        return this.runningJob.isSuccessful();
    }

    public boolean isComplete() throws IOException {
        return this.runningJob.isComplete();
    }

    public TaskCompletionEvent[] getTaskCompletionEvents(int startIndex) throws IOException {
        org.pentaho.hadoop.shim.api.mapred.TaskCompletionEvent[] taskCompletionEvents = this.runningJob.getTaskCompletionEvents(startIndex);
        TaskCompletionEvent[] result = new TaskCompletionEvent[taskCompletionEvents.length];
        for (int i = 0; i < taskCompletionEvents.length; ++i) {
            result[i] = new TaskCompletionEventImpl(taskCompletionEvents[i]);
        }
        return result;
    }

    public String[] getTaskDiagnostics(Object taskAttemptId) throws IOException {
        return this.runningJob.getTaskDiagnostics(taskAttemptId);
    }
}

