/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.pensol;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.vfs2.Capability;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.UserAuthenticationData;
import org.apache.commons.vfs2.provider.AbstractOriginatingFileProvider;
import org.apache.commons.vfs2.provider.FileNameParser;
import org.apache.commons.vfs2.provider.GenericFileName;
import org.apache.commons.vfs2.provider.LayeredFileName;
import org.apache.commons.vfs2.provider.LayeredFileNameParser;
import org.apache.commons.vfs2.util.UserAuthenticatorUtils;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.util.StringUtil;
import org.pentaho.reporting.engine.classic.core.util.HttpClientManager;
import org.pentaho.reporting.libraries.pensol.JCRSolutionDirectFileModel;
import org.pentaho.reporting.libraries.pensol.JCRSolutionDirectFileSystem;
import org.pentaho.reporting.libraries.pensol.JCRSolutionFileModel;
import org.pentaho.reporting.libraries.pensol.JCRSolutionFileSystem;
import org.pentaho.reporting.libraries.pensol.PentahoSolutionsFileSystemConfigBuilder;
import org.pentaho.reporting.libraries.pensol.vfs.LocalFileModel;
import org.pentaho.reporting.libraries.pensol.vfs.WebSolutionFileSystem;

public class PentahoSolutionFileProvider
extends AbstractOriginatingFileProvider {
    private static final Log logger = LogFactory.getLog(PentahoSolutionFileProvider.class);
    private boolean bypassAuthentication = false;
    public static final Collection capabilities = Collections.unmodifiableCollection(Arrays.asList(Capability.GET_TYPE, Capability.GET_LAST_MODIFIED, Capability.LIST_CHILDREN, Capability.READ_CONTENT, Capability.WRITE_CONTENT, Capability.CREATE, Capability.FS_ATTRIBUTES, Capability.URI));
    public static final UserAuthenticationData.Type[] AUTHENTICATOR_TYPES = new UserAuthenticationData.Type[]{UserAuthenticationData.USERNAME, UserAuthenticationData.PASSWORD};

    public PentahoSolutionFileProvider() {
        this.setFileNameParser((FileNameParser)LayeredFileNameParser.getInstance());
        try {
            IPentahoSession session = PentahoSessionHolder.getSession();
            if (session != null) {
                this.bypassAuthentication = true;
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
    }

    protected FileSystem doCreateFileSystem(FileName rootName, FileSystemOptions fileSystemOptions) throws FileSystemException {
        LayeredFileName genericRootName = (LayeredFileName)rootName;
        if ("jcr-solution".equals(rootName.getScheme())) {
            if (this.bypassAuthentication) {
                return this.createJCRDirectFileSystem(genericRootName, fileSystemOptions);
            }
            return this.createJCRFileSystem(genericRootName, fileSystemOptions);
        }
        return this.createWebFileSystem(genericRootName, fileSystemOptions);
    }

    private FileSystem createJCRDirectFileSystem(LayeredFileName genericRootName, FileSystemOptions fileSystemOptions) throws FileSystemException {
        JCRSolutionDirectFileModel model = new JCRSolutionDirectFileModel();
        return new JCRSolutionDirectFileSystem((FileName)genericRootName, fileSystemOptions, model);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileSystem createJCRFileSystem(LayeredFileName genericRootName, FileSystemOptions fileSystemOptions) {
        UserAuthenticationData authData = null;
        try {
            authData = UserAuthenticatorUtils.authenticate((FileSystemOptions)fileSystemOptions, (UserAuthenticationData.Type[])AUTHENTICATOR_TYPES);
            GenericFileName outerName = (GenericFileName)genericRootName.getOuterName();
            String username = UserAuthenticatorUtils.toString((char[])UserAuthenticatorUtils.getData((UserAuthenticationData)authData, (UserAuthenticationData.Type)UserAuthenticationData.USERNAME, (char[])UserAuthenticatorUtils.toChar((String)outerName.getUserName())));
            String password = UserAuthenticatorUtils.toString((char[])UserAuthenticatorUtils.getData((UserAuthenticationData)authData, (UserAuthenticationData.Type)UserAuthenticationData.PASSWORD, (char[])UserAuthenticatorUtils.toChar((String)outerName.getPassword())));
            PentahoSolutionsFileSystemConfigBuilder configBuilder = new PentahoSolutionsFileSystemConfigBuilder();
            int timeOut = configBuilder.getTimeOut(fileSystemOptions);
            JCRSolutionFileModel model = new JCRSolutionFileModel(outerName.getURI(), username, password, timeOut);
            JCRSolutionFileSystem jCRSolutionFileSystem = new JCRSolutionFileSystem((FileName)genericRootName, fileSystemOptions, model);
            return jCRSolutionFileSystem;
        }
        finally {
            UserAuthenticatorUtils.cleanup((UserAuthenticationData)authData);
        }
    }

    private FileSystem createWebFileSystem(LayeredFileName genericRootName, FileSystemOptions fileSystemOptions) throws FileSystemException {
        GenericFileName outerName = (GenericFileName)genericRootName.getOuterName();
        String scheme = outerName.getScheme();
        String hostName = outerName.getHostName();
        int port = outerName.getPort();
        String userName = outerName.getUserName();
        String password = outerName.getPassword();
        HttpClientManager.HttpClientBuilderFacade clientBuilder = HttpClientManager.getInstance().createBuilder();
        if (!StringUtil.isEmpty((String)hostName)) {
            clientBuilder.setProxy(hostName, port, scheme);
        }
        if (!StringUtil.isEmpty((String)userName)) {
            clientBuilder.setCredentials(userName, password);
        }
        PentahoSolutionsFileSystemConfigBuilder configBuilder = new PentahoSolutionsFileSystemConfigBuilder();
        int timeOut = configBuilder.getTimeOut(fileSystemOptions);
        clientBuilder.setSocketTimeout(Math.max(0, timeOut));
        return new WebSolutionFileSystem((FileName)genericRootName, fileSystemOptions, new LocalFileModel(outerName.getURI(), clientBuilder, userName, password, hostName, port));
    }

    public Collection getCapabilities() {
        return capabilities;
    }
}

