/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.pensol;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.api.client.filter.HTTPBasicAuthFilter;
import com.sun.jersey.core.header.ContentDisposition;
import com.sun.jersey.core.header.FormDataContentDisposition;
import com.sun.jersey.multipart.BodyPart;
import com.sun.jersey.multipart.FormDataBodyPart;
import com.sun.jersey.multipart.FormDataMultiPart;
import com.sun.jersey.multipart.impl.MultiPartWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.Properties;
import javax.ws.rs.core.MediaType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PublishRestUtil {
    private static final Log logger = LogFactory.getLog(PublishRestUtil.class);
    public static final String REPORT_TITLE_KEY = "reportTitle";
    public static final String OVERWRITE_FILE_KEY = "overwriteFile";
    public static final String IMPORT_PATH_KEY = "importPath";
    public static final String REPO_FILES_IMPORT = "api/repo/publish/file";
    private static final String REPO_FILES_IMPORT_WITH_OPTIONS = "api/repo/publish/fileWithOptions";
    private final String baseUrl;
    private final String username;
    private final String password;
    private Client client = null;

    public PublishRestUtil(String baseUrl, String username, String password) {
        this.baseUrl = baseUrl.endsWith("/") ? baseUrl : baseUrl + '/';
        this.username = username;
        this.password = password;
        this.initRestService();
    }

    private void initRestService() {
        DefaultClientConfig clientConfig = new DefaultClientConfig();
        clientConfig.getClasses().add(MultiPartWriter.class);
        clientConfig.getFeatures().put("com.sun.jersey.api.json.POJOMappingFeature", Boolean.TRUE);
        this.client = Client.create((ClientConfig)clientConfig);
        this.client.addFilter((ClientFilter)new HTTPBasicAuthFilter(this.username, this.password));
    }

    public int publishFile(String filePath, byte[] data, Properties fileProperties) throws IOException {
        if (filePath == null || data == null || data.length == 0) {
            throw new IOException("missing file path and/or data");
        }
        String path = filePath;
        String fileName = null;
        int fileNameIdx = filePath.lastIndexOf("/");
        if (fileNameIdx >= 0) {
            fileName = filePath.substring(fileNameIdx + 1);
            path = filePath.substring(0, fileNameIdx);
        }
        try {
            return this.publishFile(path, fileName, (InputStream)new ByteArrayInputStream(data), fileProperties);
        }
        catch (Exception ex) {
            logger.error((Object)ex);
            throw new IOException(ex);
        }
    }

    public int publishFile(String repositoryPath, String fileName, InputStream fileInputStream, Properties fileProperties) throws IOException {
        String url = this.baseUrl + REPO_FILES_IMPORT_WITH_OPTIONS;
        WebResource resource = this.client.resource(url);
        int responseCode = 504;
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            FormDataMultiPart fdmp = new FormDataMultiPart();
            String pathEncoded = URLEncoder.encode(repositoryPath + "/" + fileName, "UTF-8");
            String nameEncoded = URLEncoder.encode(fileName, "UTF-8");
            if (fileProperties == null) {
                fileProperties = new Properties();
            }
            fileProperties.storeToXML((OutputStream)baos, "file properties", "UTF-8");
            fdmp.bodyPart((BodyPart)new FormDataBodyPart("properties", (Object)baos.toString("UTF-8"), MediaType.APPLICATION_XML_TYPE));
            fdmp.field(IMPORT_PATH_KEY, (Object)pathEncoded, MediaType.MULTIPART_FORM_DATA_TYPE);
            fdmp.field("fileUpload", (Object)fileInputStream, MediaType.MULTIPART_FORM_DATA_TYPE);
            fdmp.getField("fileUpload").setContentDisposition((ContentDisposition)((FormDataContentDisposition.FormDataContentDispositionBuilder)FormDataContentDisposition.name((String)"fileUpload").fileName(nameEncoded)).build());
            WebResource.Builder builder = resource.type(MediaType.MULTIPART_FORM_DATA_TYPE);
            ClientResponse response = (ClientResponse)builder.post(ClientResponse.class, (Object)fdmp);
            if (response != null) {
                String message = (String)response.getEntity(String.class);
                logger.info((Object)message);
                responseCode = response.getStatus();
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
        return responseCode;
    }

    @Deprecated
    public int publishFile(String filePath, byte[] data, boolean overwriteIfExists) throws IOException {
        Properties fileProperties = new Properties();
        fileProperties.setProperty(OVERWRITE_FILE_KEY, String.valueOf(overwriteIfExists));
        return this.publishFile(filePath, data, fileProperties);
    }

    @Deprecated
    public int publishFile(String repositoryPath, String fileName, InputStream fileInputStream, boolean overwriteIfExists) throws IOException {
        Properties fileProperties = new Properties();
        fileProperties.setProperty(OVERWRITE_FILE_KEY, String.valueOf(overwriteIfExists));
        return this.publishFile(repositoryPath, fileName, fileInputStream, fileProperties);
    }
}

