/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.pensol;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.pentaho.reporting.libraries.pensol.WebSolutionFileObject;

public class SolutionFileOutputStream
extends OutputStream {
    private ByteArrayOutputStream outputStream;
    private boolean closed;
    private WebSolutionFileObject item;

    public SolutionFileOutputStream(WebSolutionFileObject item, byte[] existingData) throws IOException {
        this.item = item;
        this.outputStream = new ByteArrayOutputStream(Math.max(8192, existingData.length));
        this.outputStream.write(existingData);
    }

    @Override
    public void write(int b) throws IOException {
        if (this.closed) {
            throw new IOException("Already closed");
        }
        this.outputStream.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.closed) {
            throw new IOException("Already closed");
        }
        this.outputStream.write(b, off, len);
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            throw new IOException("Already closed");
        }
        this.closed = true;
        this.outputStream.close();
        byte[] data = this.outputStream.toByteArray();
        this.item.writeData(data);
    }

    @Override
    public void write(byte[] b) throws IOException {
        if (this.closed) {
            throw new IOException("Already closed");
        }
        this.outputStream.write(b);
    }

    @Override
    public void flush() throws IOException {
        if (this.closed) {
            throw new IOException("Already closed");
        }
        this.outputStream.flush();
    }
}

