/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.client;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.oozie.BuildInfo;
import org.apache.oozie.client.BulkResponse;
import org.apache.oozie.client.BundleJob;
import org.apache.oozie.client.CoordinatorAction;
import org.apache.oozie.client.CoordinatorJob;
import org.apache.oozie.client.JMSConnectionInfo;
import org.apache.oozie.client.Job;
import org.apache.oozie.client.OozieClientException;
import org.apache.oozie.client.WorkflowAction;
import org.apache.oozie.client.WorkflowJob;
import org.apache.oozie.client.rest.JsonTags;
import org.apache.oozie.client.rest.JsonToBean;
import org.apache.oozie.client.retry.ConnectionRetriableClient;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class OozieClient {
    public static final long WS_PROTOCOL_VERSION_0 = 0L;
    public static final long WS_PROTOCOL_VERSION_1 = 1L;
    public static final long WS_PROTOCOL_VERSION = 2L;
    public static final String USER_NAME = "user.name";
    @Deprecated
    public static final String GROUP_NAME = "group.name";
    public static final String JOB_ACL = "oozie.job.acl";
    public static final String APP_PATH = "oozie.wf.application.path";
    public static final String COORDINATOR_APP_PATH = "oozie.coord.application.path";
    public static final String BUNDLE_APP_PATH = "oozie.bundle.application.path";
    public static final String BUNDLE_ID = "oozie.bundle.id";
    public static final String EXTERNAL_ID = "oozie.wf.external.id";
    public static final String WORKFLOW_NOTIFICATION_URL = "oozie.wf.workflow.notification.url";
    public static final String WORKFLOW_NOTIFICATION_PROXY = "oozie.wf.workflow.notification.proxy";
    public static final String ACTION_NOTIFICATION_URL = "oozie.wf.action.notification.url";
    public static final String COORD_ACTION_NOTIFICATION_URL = "oozie.coord.action.notification.url";
    public static final String COORD_ACTION_NOTIFICATION_PROXY = "oozie.coord.action.notification.proxy";
    public static final String RERUN_SKIP_NODES = "oozie.wf.rerun.skip.nodes";
    public static final String RERUN_FAIL_NODES = "oozie.wf.rerun.failnodes";
    public static final String LOG_TOKEN = "oozie.wf.log.token";
    public static final String ACTION_MAX_RETRIES = "oozie.wf.action.max.retries";
    public static final String ACTION_RETRY_INTERVAL = "oozie.wf.action.retry.interval";
    public static final String FILTER_USER = "user";
    public static final String FILTER_TEXT = "text";
    public static final String FILTER_GROUP = "group";
    public static final String FILTER_NAME = "name";
    public static final String FILTER_STATUS = "status";
    public static final String FILTER_NOMINAL_TIME = "nominaltime";
    public static final String FILTER_FREQUENCY = "frequency";
    public static final String FILTER_ID = "id";
    public static final String FILTER_UNIT = "unit";
    public static final String FILTER_JOBID = "jobid";
    public static final String FILTER_APPNAME = "appname";
    public static final String FILTER_SLA_APPNAME = "app_name";
    public static final String FILTER_SLA_ID = "id";
    public static final String FILTER_SLA_PARENT_ID = "parent_id";
    public static final String FILTER_SLA_EVENT_STATUS = "event_status";
    public static final String FILTER_SLA_NOMINAL_START = "nominal_start";
    public static final String FILTER_SLA_NOMINAL_END = "nominal_end";
    public static final String FILTER_CREATED_TIME_START = "startcreatedtime";
    public static final String FILTER_CREATED_TIME_END = "endcreatedtime";
    public static final String CHANGE_VALUE_ENDTIME = "endtime";
    public static final String CHANGE_VALUE_PAUSETIME = "pausetime";
    public static final String CHANGE_VALUE_CONCURRENCY = "concurrency";
    public static final String CHANGE_VALUE_STATUS = "status";
    public static final String LIBPATH = "oozie.libpath";
    public static final String USE_SYSTEM_LIBPATH = "oozie.use.system.libpath";
    public static final String OOZIE_SUSPEND_ON_NODES = "oozie.suspend.on.nodes";
    public static final String FILTER_SORT_BY = "sortby";
    private static final Set<String> COMPLETED_WF_STATUSES = new HashSet<String>();
    private static final Set<String> COMPLETED_COORD_AND_BUNDLE_STATUSES = new HashSet<String>();
    private static final Set<String> COMPLETED_COORD_ACTION_STATUSES = new HashSet<String>();
    public int debugMode = 0;
    private int retryCount = 4;
    private String baseUrl;
    private String protocolUrl;
    private boolean validatedVersion = false;
    private JSONArray supportedVersions;
    private final Map<String, String> headers = new HashMap<String, String>();
    private static final ThreadLocal<String> USER_NAME_TL;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T doAs(String userName, Callable<T> callable) throws Exception {
        OozieClient.notEmpty(userName, "userName");
        OozieClient.notNull(callable, "callable");
        try {
            USER_NAME_TL.set(userName);
            T t = callable.call();
            return t;
        }
        finally {
            USER_NAME_TL.remove();
        }
    }

    protected OozieClient() {
    }

    public OozieClient(String oozieUrl) {
        this.baseUrl = OozieClient.notEmpty(oozieUrl, "oozieUrl");
        if (!this.baseUrl.endsWith("/")) {
            this.baseUrl = this.baseUrl + "/";
        }
    }

    public String getOozieUrl() {
        return this.baseUrl;
    }

    public String getProtocolUrl() throws OozieClientException {
        this.validateWSVersion();
        return this.protocolUrl;
    }

    public int getDebugMode() {
        return this.debugMode;
    }

    public void setDebugMode(int debugMode) {
        this.debugMode = debugMode;
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    public void setRetryCount(int retryCount) {
        this.retryCount = retryCount;
    }

    private String getBaseURLForVersion(long protocolVersion) throws OozieClientException {
        try {
            if (this.supportedVersions == null) {
                this.supportedVersions = this.getSupportedProtocolVersions();
            }
            if (this.supportedVersions == null) {
                throw new OozieClientException("HTTP error", "no response message");
            }
            if (this.supportedVersions.contains((Object)protocolVersion)) {
                return this.baseUrl + "v" + protocolVersion + "/";
            }
            throw new OozieClientException("UNSUPPORTED_VERSION", "Protocol version " + protocolVersion + " is not supported");
        }
        catch (IOException e) {
            throw new OozieClientException("IO_ERROR", e);
        }
    }

    public synchronized void validateWSVersion() throws OozieClientException {
        if (!this.validatedVersion) {
            try {
                this.supportedVersions = this.getSupportedProtocolVersions();
                if (this.supportedVersions == null) {
                    throw new OozieClientException("HTTP error", "no response message");
                }
                if (!(this.supportedVersions.contains((Object)2L) || this.supportedVersions.contains((Object)1L) || this.supportedVersions.contains((Object)0L))) {
                    StringBuilder msg = new StringBuilder();
                    msg.append("Supported version [").append(2L).append("] or less, Unsupported versions[");
                    String separator = "";
                    for (Object version : this.supportedVersions) {
                        msg.append(separator).append(version);
                    }
                    msg.append("]");
                    throw new OozieClientException("UNSUPPORTED_VERSION", msg.toString());
                }
                if (this.supportedVersions.contains((Object)2L)) {
                    this.protocolUrl = this.baseUrl + "v" + 2L + "/";
                } else if (this.supportedVersions.contains((Object)1L)) {
                    this.protocolUrl = this.baseUrl + "v" + 1L + "/";
                } else if (this.supportedVersions.contains((Object)0L)) {
                    this.protocolUrl = this.baseUrl + "v" + 0L + "/";
                }
            }
            catch (IOException ex) {
                throw new OozieClientException("IO_ERROR", ex);
            }
            this.validatedVersion = true;
        }
    }

    private JSONArray getSupportedProtocolVersions() throws IOException, OozieClientException {
        JSONArray versions = null;
        URL url = new URL(this.baseUrl + "versions");
        HttpURLConnection conn = this.createRetryableConnection(url, "GET");
        if (conn.getResponseCode() == 200) {
            versions = (JSONArray)JSONValue.parse((Reader)new InputStreamReader(conn.getInputStream()));
        } else {
            OozieClient.handleError(conn);
        }
        return versions;
    }

    public Properties createConfiguration() {
        Properties conf = new Properties();
        String userName = USER_NAME_TL.get();
        if (userName == null) {
            userName = System.getProperty(USER_NAME);
        }
        conf.setProperty(USER_NAME, userName);
        return conf;
    }

    public void setHeader(String name, String value) {
        this.headers.put(OozieClient.notEmpty(name, FILTER_NAME), OozieClient.notNull(value, "value"));
    }

    public String getHeader(String name) {
        return this.headers.get(OozieClient.notEmpty(name, FILTER_NAME));
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public void removeHeader(String name) {
        this.headers.remove(OozieClient.notEmpty(name, FILTER_NAME));
    }

    public Iterator<String> getHeaderNames() {
        return Collections.unmodifiableMap(this.headers).keySet().iterator();
    }

    private URL createURL(Long protocolVersion, String collection, String resource, Map<String, String> parameters) throws IOException, OozieClientException {
        this.validateWSVersion();
        StringBuilder sb = new StringBuilder();
        if (protocolVersion == null) {
            sb.append(this.protocolUrl);
        } else {
            sb.append(this.getBaseURLForVersion(protocolVersion));
        }
        sb.append(collection);
        if (resource != null && resource.length() > 0) {
            sb.append("/").append(resource);
        }
        if (parameters.size() > 0) {
            String separator = "?";
            for (Map.Entry<String, String> param : parameters.entrySet()) {
                if (param.getValue() == null) continue;
                sb.append(separator).append(URLEncoder.encode(param.getKey(), "UTF-8")).append("=").append(URLEncoder.encode(param.getValue(), "UTF-8"));
                separator = "&";
            }
        }
        return new URL(sb.toString());
    }

    private boolean validateCommand(String url) {
        return !this.protocolUrl.contains(this.baseUrl + "v0") || !url.contains("dryrun") && !url.contains("jobtype=c") && !url.contains("systemmode");
    }

    protected HttpURLConnection createRetryableConnection(URL url, String method) throws IOException {
        return (HttpURLConnection)new ConnectionRetriableClient(this.getRetryCount()){

            @Override
            public Object doExecute(URL url, String method) throws IOException, OozieClientException {
                HttpURLConnection conn = OozieClient.this.createConnection(url, method);
                return conn;
            }
        }.execute(url, method);
    }

    protected HttpURLConnection createConnection(URL url, String method) throws IOException, OozieClientException {
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod(method);
        if (method.equals("POST") || method.equals("PUT")) {
            conn.setDoOutput(true);
        }
        for (Map.Entry<String, String> header : this.headers.entrySet()) {
            conn.setRequestProperty(header.getKey(), header.getValue());
        }
        return conn;
    }

    static void handleError(HttpURLConnection conn) throws IOException, OozieClientException {
        int status = conn.getResponseCode();
        String error = conn.getHeaderField("oozie-error-code");
        String message = conn.getHeaderField("oozie-error-message");
        if (error == null) {
            error = "HTTP error code: " + status;
        }
        if (message == null) {
            message = conn.getResponseMessage();
        }
        throw new OozieClientException(error, message);
    }

    static Map<String, String> prepareParams(String ... params) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        for (int i = 0; i < params.length; i += 2) {
            map.put(params[i], params[i + 1]);
        }
        String doAsUserName = USER_NAME_TL.get();
        if (doAsUserName != null) {
            map.put("doAs", doAsUserName);
        }
        return map;
    }

    public void writeToXml(Properties props, OutputStream out) throws IOException {
        try {
            Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element conf = doc.createElement("configuration");
            doc.appendChild(conf);
            conf.appendChild(doc.createTextNode("\n"));
            for (String name : props.stringPropertyNames()) {
                String value = props.getProperty(name);
                Element propNode = doc.createElement("property");
                conf.appendChild(propNode);
                Element nameNode = doc.createElement(FILTER_NAME);
                nameNode.appendChild(doc.createTextNode(name.trim()));
                propNode.appendChild(nameNode);
                Element valueNode = doc.createElement("value");
                valueNode.appendChild(doc.createTextNode(value.trim()));
                propNode.appendChild(valueNode);
                conf.appendChild(doc.createTextNode("\n"));
            }
            DOMSource source = new DOMSource(doc);
            StreamResult result = new StreamResult(out);
            TransformerFactory transFactory = TransformerFactory.newInstance();
            transFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            Transformer transformer = transFactory.newTransformer();
            transformer.transform(source, result);
            if (this.getDebugMode() > 0) {
                result = new StreamResult(System.out);
                transformer.transform(source, result);
                System.out.println();
            }
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public String submit(Properties conf) throws OozieClientException {
        return (String)new JobSubmit(conf, false).call();
    }

    public String updateCoord(String jobId, Properties conf, String dryrun, String showDiff) throws OozieClientException {
        return (String)new UpdateCoord(jobId, conf, dryrun, showDiff).call();
    }

    public String updateCoord(String jobId, String dryrun, String showDiff) throws OozieClientException {
        return (String)new UpdateCoord(jobId, dryrun, showDiff).call();
    }

    public String dryrun(Properties conf) throws OozieClientException {
        return (String)new JobSubmit(conf, "dryrun").call();
    }

    public void start(String jobId) throws OozieClientException {
        new JobAction(jobId, "start").call();
    }

    public String run(Properties conf) throws OozieClientException {
        return (String)new JobSubmit(conf, true).call();
    }

    public void reRun(String jobId, Properties conf) throws OozieClientException {
        new JobSubmit(jobId, conf).call();
    }

    public void suspend(String jobId) throws OozieClientException {
        new JobAction(jobId, "suspend").call();
    }

    public void resume(String jobId) throws OozieClientException {
        new JobAction(jobId, "resume").call();
    }

    public void kill(String jobId) throws OozieClientException {
        new JobAction(jobId, "kill").call();
    }

    public List<CoordinatorAction> kill(String jobId, String rangeType, String scope) throws OozieClientException {
        return (List)new CoordActionsKill(jobId, rangeType, scope).call();
    }

    public JSONObject bulkModifyJobs(String actionType, String filter, String jobType, int start, int len) throws OozieClientException {
        return (JSONObject)new JobsAction(actionType, filter, jobType, start, len).call();
    }

    public JSONObject killJobs(String filter, String jobType, int start, int len) throws OozieClientException {
        return this.bulkModifyJobs("kill", filter, jobType, start, len);
    }

    public JSONObject suspendJobs(String filter, String jobType, int start, int len) throws OozieClientException {
        return this.bulkModifyJobs("suspend", filter, jobType, start, len);
    }

    public JSONObject resumeJobs(String filter, String jobType, int start, int len) throws OozieClientException {
        return this.bulkModifyJobs("resume", filter, jobType, start, len);
    }

    public void change(String jobId, String changeValue) throws OozieClientException {
        new JobAction(jobId, "change", changeValue).call();
    }

    public List<CoordinatorAction> ignore(String jobId, String scope) throws OozieClientException {
        return (List)new CoordIgnore(jobId, "action", scope).call();
    }

    public WorkflowJob getJobInfo(String jobId) throws OozieClientException {
        return this.getJobInfo(jobId, 0, 0);
    }

    public JMSConnectionInfo getJMSConnectionInfo() throws OozieClientException {
        return (JMSConnectionInfo)new JMSInfo().call();
    }

    public WorkflowJob getJobInfo(String jobId, int start, int len) throws OozieClientException {
        return (WorkflowJob)new JobInfo(jobId, start, len).call();
    }

    public WorkflowAction getWorkflowActionInfo(String actionId) throws OozieClientException {
        return (WorkflowAction)new WorkflowActionInfo(actionId).call();
    }

    public String getJobLog(String jobId) throws OozieClientException {
        return (String)new JobLog(jobId).call();
    }

    public void getJobLog(String jobId, String logRetrievalType, String logRetrievalScope, String logFilter, PrintStream ps) throws OozieClientException {
        new JobLog(jobId, logRetrievalType, logRetrievalScope, logFilter, ps).call();
    }

    public void getJobLog(String jobId, String logRetrievalType, String logRetrievalScope, PrintStream ps) throws OozieClientException {
        this.getJobLog(jobId, logRetrievalType, logRetrievalScope, null, ps);
    }

    public String getJMSTopicName(String jobId) throws OozieClientException {
        return (String)new JMSTopic(jobId).call();
    }

    public String getJobDefinition(String jobId) throws OozieClientException {
        return (String)new JobDefinition(jobId).call();
    }

    public BundleJob getBundleJobInfo(String jobId) throws OozieClientException {
        return (BundleJob)new BundleJobInfo(jobId).call();
    }

    public CoordinatorJob getCoordJobInfo(String jobId) throws OozieClientException {
        return (CoordinatorJob)new CoordJobInfo(jobId, null, -1, -1, "asc").call();
    }

    public CoordinatorJob getCoordJobInfo(String jobId, String filter, int start, int len) throws OozieClientException {
        return (CoordinatorJob)new CoordJobInfo(jobId, filter, start, len, "asc").call();
    }

    public CoordinatorJob getCoordJobInfo(String jobId, String filter, int start, int len, String order) throws OozieClientException {
        return (CoordinatorJob)new CoordJobInfo(jobId, filter, start, len, order).call();
    }

    public List<WorkflowJob> getWfsForCoordAction(String coordActionId) throws OozieClientException {
        return (List)new WfsForCoordAction(coordActionId).call();
    }

    public CoordinatorAction getCoordActionInfo(String actionId) throws OozieClientException {
        return (CoordinatorAction)new CoordActionInfo(actionId).call();
    }

    public List<CoordinatorAction> reRunCoord(String jobId, String rerunType, String scope, boolean refresh, boolean noCleanup) throws OozieClientException {
        return (List)new CoordRerun(jobId, rerunType, scope, refresh, noCleanup, false).call();
    }

    public List<CoordinatorAction> reRunCoord(String jobId, String rerunType, String scope, boolean refresh, boolean noCleanup, boolean failed) throws OozieClientException {
        return (List)new CoordRerun(jobId, rerunType, scope, refresh, noCleanup, failed).call();
    }

    public Void reRunBundle(String jobId, String coordScope, String dateScope, boolean refresh, boolean noCleanup) throws OozieClientException {
        return (Void)new BundleRerun(jobId, coordScope, dateScope, refresh, noCleanup).call();
    }

    public List<WorkflowJob> getJobsInfo(String filter, int start, int len) throws OozieClientException {
        return (List)new JobsStatus(filter, start, len).call();
    }

    public List<WorkflowJob> getJobsInfo(String filter) throws OozieClientException {
        return this.getJobsInfo(filter, 1, 50);
    }

    public void getSlaInfo(int start, int len, String filter) throws OozieClientException {
        new SlaInfo(start, len, filter).call();
    }

    public String getJobId(String externalId) throws OozieClientException {
        return (String)new JobIdAction(externalId).call();
    }

    public void setSystemMode(SYSTEM_MODE status) throws OozieClientException {
        new SetSystemMode(status).call();
    }

    public SYSTEM_MODE getSystemMode() throws OozieClientException {
        return (SYSTEM_MODE)((Object)new GetSystemMode().call());
    }

    public String updateShareLib() throws OozieClientException {
        return (String)new UpdateSharelib().call();
    }

    public String listShareLib(String sharelibKey) throws OozieClientException {
        return (String)new ListShareLib(sharelibKey).call();
    }

    public String getServerBuildVersion() throws OozieClientException {
        return (String)new GetBuildVersion().call();
    }

    public String getClientBuildVersion() {
        return BuildInfo.getBuildInfo().getProperty("build.version");
    }

    public String validateXML(String file) throws OozieClientException {
        String user;
        String fileName = file;
        if (file.startsWith("file://")) {
            fileName = file.substring(7, file.length());
        }
        if (!fileName.contains("://")) {
            File f = new File(fileName);
            if (!f.isFile()) {
                throw new OozieClientException("File error", "File does not exist : " + f.getAbsolutePath());
            }
            fileName = f.getAbsolutePath();
        }
        if ((user = USER_NAME_TL.get()) == null) {
            user = System.getProperty(USER_NAME);
        }
        return (String)new ValidateXML(fileName, user).call();
    }

    public List<CoordinatorJob> getCoordJobsInfo(String filter, int start, int len) throws OozieClientException {
        return (List)new CoordJobsStatus(filter, start, len).call();
    }

    public List<BundleJob> getBundleJobsInfo(String filter, int start, int len) throws OozieClientException {
        return (List)new BundleJobsStatus(filter, start, len).call();
    }

    public List<BulkResponse> getBulkInfo(String filter, int start, int len) throws OozieClientException {
        return (List)new BulkResponseStatus(filter, start, len).call();
    }

    public void pollJob(String id, int timeout, int interval, boolean verbose) throws OozieClientException {
        Set<String> completedStatuses;
        OozieClient.notEmpty("id", id);
        if (interval < 1) {
            throw new IllegalArgumentException("interval must be a positive integer");
        }
        boolean noTimeout = timeout < 1;
        long endTime = System.currentTimeMillis() + (long)(timeout * 60 * 1000);
        interval *= 60000;
        if (id.endsWith("-W")) {
            completedStatuses = COMPLETED_WF_STATUSES;
        } else if (id.endsWith("-C")) {
            completedStatuses = COMPLETED_COORD_AND_BUNDLE_STATUSES;
        } else if (id.endsWith("-B")) {
            completedStatuses = COMPLETED_COORD_AND_BUNDLE_STATUSES;
        } else if (id.contains("-C@")) {
            completedStatuses = COMPLETED_COORD_ACTION_STATUSES;
        } else {
            throw new IllegalArgumentException("invalid job type");
        }
        String status = this.getStatus(id);
        if (verbose) {
            System.out.println(status);
        }
        while (!completedStatuses.contains(status) && (noTimeout || System.currentTimeMillis() <= endTime)) {
            try {
                Thread.sleep(interval);
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
            status = this.getStatus(id);
            if (!verbose) continue;
            System.out.println(status);
        }
    }

    public String getStatus(String jobId) throws OozieClientException {
        return (String)new Status(jobId).call();
    }

    public List<String> getQueueDump() throws OozieClientException {
        return (List)new GetQueueDump().call();
    }

    public Map<String, String> getAvailableOozieServers() throws OozieClientException {
        return (Map)new GetAvailableOozieServers().call();
    }

    public Map<String, String> getServerConfiguration() throws OozieClientException {
        return (Map)new GetServerConfiguration().call();
    }

    public Map<String, String> getJavaSystemProperties() throws OozieClientException {
        return (Map)new GetJavaSystemProperties().call();
    }

    public Map<String, String> getOSEnv() throws OozieClientException {
        return (Map)new GetOSEnv().call();
    }

    public Metrics getMetrics() throws OozieClientException {
        return (Metrics)new GetMetrics().call();
    }

    public Instrumentation getInstrumentation() throws OozieClientException {
        return (Instrumentation)new GetInstrumentation().call();
    }

    public static String notEmpty(String str, String name) {
        if (str == null) {
            throw new IllegalArgumentException(name + " cannot be null");
        }
        if (str.length() == 0) {
            throw new IllegalArgumentException(name + " cannot be empty");
        }
        return str;
    }

    public static <T> T notNull(T obj, String name) {
        if (obj == null) {
            throw new IllegalArgumentException(name + " cannot be null");
        }
        return obj;
    }

    static {
        COMPLETED_WF_STATUSES.add(WorkflowJob.Status.FAILED.toString());
        COMPLETED_WF_STATUSES.add(WorkflowJob.Status.KILLED.toString());
        COMPLETED_WF_STATUSES.add(WorkflowJob.Status.SUCCEEDED.toString());
        COMPLETED_COORD_AND_BUNDLE_STATUSES.add(Job.Status.FAILED.toString());
        COMPLETED_COORD_AND_BUNDLE_STATUSES.add(Job.Status.KILLED.toString());
        COMPLETED_COORD_AND_BUNDLE_STATUSES.add(Job.Status.SUCCEEDED.toString());
        COMPLETED_COORD_AND_BUNDLE_STATUSES.add(Job.Status.DONEWITHERROR.toString());
        COMPLETED_COORD_AND_BUNDLE_STATUSES.add(Job.Status.IGNORED.toString());
        COMPLETED_COORD_ACTION_STATUSES.add(CoordinatorAction.Status.FAILED.toString());
        COMPLETED_COORD_ACTION_STATUSES.add(CoordinatorAction.Status.IGNORED.toString());
        COMPLETED_COORD_ACTION_STATUSES.add(CoordinatorAction.Status.KILLED.toString());
        COMPLETED_COORD_ACTION_STATUSES.add(CoordinatorAction.Status.SKIPPED.toString());
        COMPLETED_COORD_ACTION_STATUSES.add(CoordinatorAction.Status.SUCCEEDED.toString());
        COMPLETED_COORD_ACTION_STATUSES.add(CoordinatorAction.Status.TIMEDOUT.toString());
        USER_NAME_TL = new ThreadLocal();
    }

    public class Instrumentation {
        private Map<String, Long> counters;
        private Map<String, Object> variables;
        private Map<String, Double> samplers;
        private Map<String, Timer> timers;

        public Instrumentation(JSONObject json) {
            JSONArray jCounters = (JSONArray)json.get((Object)"counters");
            this.counters = new HashMap<String, Long>(jCounters.size());
            for (Object groupO : jCounters) {
                JSONObject group = (JSONObject)groupO;
                String groupName = group.get((Object)OozieClient.FILTER_GROUP).toString() + ".";
                JSONArray data = (JSONArray)group.get((Object)"data");
                for (Object datO : data) {
                    JSONObject dat = (JSONObject)datO;
                    this.counters.put(groupName + dat.get((Object)OozieClient.FILTER_NAME).toString(), Long.valueOf(dat.get((Object)"value").toString()));
                }
            }
            JSONArray jVariables = (JSONArray)json.get((Object)"variables");
            this.variables = new HashMap<String, Object>(jVariables.size());
            for (Object groupO : jVariables) {
                JSONObject group = (JSONObject)groupO;
                String groupName = group.get((Object)OozieClient.FILTER_GROUP).toString() + ".";
                JSONArray data = (JSONArray)group.get((Object)"data");
                for (Object datO : data) {
                    JSONObject dat = (JSONObject)datO;
                    this.variables.put(groupName + dat.get((Object)OozieClient.FILTER_NAME).toString(), dat.get((Object)"value"));
                }
            }
            JSONArray jSamplers = (JSONArray)json.get((Object)"samplers");
            this.samplers = new HashMap<String, Double>(jSamplers.size());
            for (Object groupO : jSamplers) {
                JSONObject group = (JSONObject)groupO;
                String groupName = group.get((Object)OozieClient.FILTER_GROUP).toString() + ".";
                JSONArray data = (JSONArray)group.get((Object)"data");
                for (Object datO : data) {
                    JSONObject dat = (JSONObject)datO;
                    this.samplers.put(groupName + dat.get((Object)OozieClient.FILTER_NAME).toString(), Double.valueOf(dat.get((Object)"value").toString()));
                }
            }
            JSONArray jTimers = (JSONArray)json.get((Object)"timers");
            this.timers = new HashMap<String, Timer>(jTimers.size());
            for (Object groupO : jTimers) {
                JSONObject group = (JSONObject)groupO;
                String groupName = group.get((Object)OozieClient.FILTER_GROUP).toString() + ".";
                JSONArray data = (JSONArray)group.get((Object)"data");
                for (Object datO : data) {
                    JSONObject dat = (JSONObject)datO;
                    this.timers.put(groupName + dat.get((Object)OozieClient.FILTER_NAME).toString(), new Timer(dat));
                }
            }
        }

        public Map<String, Long> getCounters() {
            return this.counters;
        }

        public Map<String, Object> getVariables() {
            return this.variables;
        }

        public Map<String, Double> getSamplers() {
            return this.samplers;
        }

        public Map<String, Timer> getTimers() {
            return this.timers;
        }

        public class Timer {
            private double ownTimeStdDev;
            private long ownTimeAvg;
            private long ownMaxTime;
            private long ownMinTime;
            private double totalTimeStdDev;
            private long totalTimeAvg;
            private long totalMaxTime;
            private long totalMinTime;
            private long ticks;

            public Timer(JSONObject json) {
                this.ownTimeStdDev = Double.valueOf(json.get((Object)"ownTimeStdDev").toString());
                this.ownTimeAvg = Long.valueOf(json.get((Object)"ownTimeAvg").toString());
                this.ownMaxTime = Long.valueOf(json.get((Object)"ownMaxTime").toString());
                this.ownMinTime = Long.valueOf(json.get((Object)"ownMinTime").toString());
                this.totalTimeStdDev = Double.valueOf(json.get((Object)"totalTimeStdDev").toString());
                this.totalTimeAvg = Long.valueOf(json.get((Object)"totalTimeAvg").toString());
                this.totalMaxTime = Long.valueOf(json.get((Object)"totalMaxTime").toString());
                this.totalMinTime = Long.valueOf(json.get((Object)"totalMinTime").toString());
                this.ticks = Long.valueOf(json.get((Object)"ticks").toString());
            }

            public double getOwnTimeStandardDeviation() {
                return this.ownTimeStdDev;
            }

            public long getOwnTimeAverage() {
                return this.ownTimeAvg;
            }

            public long getOwnMaxTime() {
                return this.ownMaxTime;
            }

            public long getOwnMinTime() {
                return this.ownMinTime;
            }

            public double getTotalTimeStandardDeviation() {
                return this.totalTimeStdDev;
            }

            public long getTotalTimeAverage() {
                return this.totalTimeAvg;
            }

            public long getTotalMaxTime() {
                return this.totalMaxTime;
            }

            public long getTotalMinTime() {
                return this.totalMinTime;
            }

            public long getTicks() {
                return this.ticks;
            }

            public String toString() {
                StringBuilder sb = new StringBuilder();
                sb.append("\town time standard deviation : ").append(this.ownTimeStdDev);
                sb.append("\n\town average time : ").append(this.ownTimeAvg);
                sb.append("\n\town max time : ").append(this.ownMaxTime);
                sb.append("\n\town min time : ").append(this.ownMinTime);
                sb.append("\n\ttotal time standard deviation : ").append(this.totalTimeStdDev);
                sb.append("\n\ttotal average time : ").append(this.totalTimeAvg);
                sb.append("\n\ttotal max time : ").append(this.totalMaxTime);
                sb.append("\n\ttotal min time : ").append(this.totalMinTime);
                sb.append("\n\tticks : ").append(this.ticks);
                return sb.toString();
            }
        }
    }

    private class GetInstrumentation
    extends ClientCallable<Instrumentation> {
        GetInstrumentation() {
            super("GET", "admin", "instrumentation", OozieClient.prepareParams(new String[0]));
        }

        @Override
        protected Instrumentation call(HttpURLConnection conn) throws IOException, OozieClientException {
            if (conn.getResponseCode() == 200) {
                InputStreamReader reader = new InputStreamReader(conn.getInputStream());
                JSONObject json = (JSONObject)JSONValue.parse((Reader)reader);
                Instrumentation instrumentation = new Instrumentation(json);
                return instrumentation;
            }
            if (conn.getResponseCode() == 503) {
                return null;
            }
            OozieClient.handleError(conn);
            return null;
        }
    }

    public class Metrics {
        private Map<String, Long> counters;
        private Map<String, Object> gauges;
        private Map<String, Timer> timers;
        private Map<String, Histogram> histograms;

        public Metrics(JSONObject json) {
            JSONObject jCounters = (JSONObject)json.get((Object)"counters");
            this.counters = new HashMap<String, Long>(jCounters.size());
            for (Object entO : jCounters.entrySet()) {
                Map.Entry ent = (Map.Entry)entO;
                this.counters.put((String)ent.getKey(), (Long)((JSONObject)ent.getValue()).get((Object)"count"));
            }
            JSONObject jGuages = (JSONObject)json.get((Object)"gauges");
            this.gauges = new HashMap<String, Object>(jGuages.size());
            for (Object entO : jGuages.entrySet()) {
                Map.Entry ent = (Map.Entry)entO;
                this.gauges.put((String)ent.getKey(), ((JSONObject)ent.getValue()).get((Object)"value"));
            }
            JSONObject jTimers = (JSONObject)json.get((Object)"timers");
            this.timers = new HashMap<String, Timer>(jTimers.size());
            for (Object entO : jTimers.entrySet()) {
                Map.Entry ent = (Map.Entry)entO;
                this.timers.put((String)ent.getKey(), new Timer((JSONObject)ent.getValue()));
            }
            JSONObject jHistograms = (JSONObject)json.get((Object)"histograms");
            this.histograms = new HashMap<String, Histogram>(jHistograms.size());
            for (Object entO : jHistograms.entrySet()) {
                Map.Entry ent = (Map.Entry)entO;
                this.histograms.put((String)ent.getKey(), new Histogram((JSONObject)ent.getValue()));
            }
        }

        public Map<String, Long> getCounters() {
            return this.counters;
        }

        public Map<String, Object> getGauges() {
            return this.gauges;
        }

        public Map<String, Timer> getTimers() {
            return this.timers;
        }

        public Map<String, Histogram> getHistograms() {
            return this.histograms;
        }

        public class Histogram {
            private double p999;
            private double p99;
            private double p98;
            private double p95;
            private double p75;
            private double p50;
            private double mean;
            private double min;
            private double max;
            private double stdDev;
            private long count;

            public Histogram(JSONObject json) {
                this.p999 = Double.valueOf(json.get((Object)"p999").toString());
                this.p99 = Double.valueOf(json.get((Object)"p99").toString());
                this.p98 = Double.valueOf(json.get((Object)"p98").toString());
                this.p95 = Double.valueOf(json.get((Object)"p95").toString());
                this.p75 = Double.valueOf(json.get((Object)"p75").toString());
                this.p50 = Double.valueOf(json.get((Object)"p50").toString());
                this.mean = Double.valueOf(json.get((Object)"mean").toString());
                this.min = Double.valueOf(json.get((Object)"min").toString());
                this.max = Double.valueOf(json.get((Object)"max").toString());
                this.stdDev = Double.valueOf(json.get((Object)"stddev").toString());
                this.count = Long.valueOf(json.get((Object)"count").toString());
            }

            public double get999thPercentile() {
                return this.p999;
            }

            public double get99thPercentile() {
                return this.p99;
            }

            public double get98thPercentile() {
                return this.p98;
            }

            public double get95thPercentile() {
                return this.p95;
            }

            public double get75thPercentile() {
                return this.p75;
            }

            public double get50thPercentile() {
                return this.p50;
            }

            public double getMean() {
                return this.mean;
            }

            public double getMin() {
                return this.min;
            }

            public double getMax() {
                return this.max;
            }

            public double getStandardDeviation() {
                return this.stdDev;
            }

            public long getCount() {
                return this.count;
            }

            public String toString() {
                StringBuilder sb = new StringBuilder();
                sb.append("\t999th percentile : ").append(this.p999);
                sb.append("\n\t99th percentile : ").append(this.p99);
                sb.append("\n\t98th percentile : ").append(this.p98);
                sb.append("\n\t95th percentile : ").append(this.p95);
                sb.append("\n\t75th percentile : ").append(this.p75);
                sb.append("\n\t50th percentile : ").append(this.p50);
                sb.append("\n\tmean : ").append(this.mean);
                sb.append("\n\tmax : ").append(this.max);
                sb.append("\n\tmin : ").append(this.min);
                sb.append("\n\tcount : ").append(this.count);
                sb.append("\n\tstandard deviation : ").append(this.stdDev);
                return sb.toString();
            }
        }

        public class Timer
        extends Histogram {
            private double m15Rate;
            private double m5Rate;
            private double m1Rate;
            private double meanRate;
            private String durationUnits;
            private String rateUnits;

            public Timer(JSONObject json) {
                super(json);
                this.m15Rate = Double.valueOf(json.get((Object)"m15_rate").toString());
                this.m5Rate = Double.valueOf(json.get((Object)"m5_rate").toString());
                this.m1Rate = Double.valueOf(json.get((Object)"m1_rate").toString());
                this.meanRate = Double.valueOf(json.get((Object)"mean_rate").toString());
                this.durationUnits = json.get((Object)"duration_units").toString();
                this.rateUnits = json.get((Object)"rate_units").toString();
            }

            public double get15MinuteRate() {
                return this.m15Rate;
            }

            public double get5MinuteRate() {
                return this.m5Rate;
            }

            public double get1MinuteRate() {
                return this.m1Rate;
            }

            public double getMeanRate() {
                return this.meanRate;
            }

            public String getDurationUnits() {
                return this.durationUnits;
            }

            public String getRateUnits() {
                return this.rateUnits;
            }

            @Override
            public String toString() {
                StringBuilder sb = new StringBuilder(super.toString());
                sb.append("\n\t15 minute rate : ").append(this.m15Rate);
                sb.append("\n\t5 minute rate : ").append(this.m5Rate);
                sb.append("\n\t1 minute rate : ").append(this.m15Rate);
                sb.append("\n\tmean rate : ").append(this.meanRate);
                sb.append("\n\tduration units : ").append(this.durationUnits);
                sb.append("\n\trate units : ").append(this.rateUnits);
                return sb.toString();
            }
        }
    }

    private class GetMetrics
    extends ClientCallable<Metrics> {
        GetMetrics() {
            super("GET", "admin", "metrics", OozieClient.prepareParams(new String[0]));
        }

        @Override
        protected Metrics call(HttpURLConnection conn) throws IOException, OozieClientException {
            if (conn.getResponseCode() == 200) {
                InputStreamReader reader = new InputStreamReader(conn.getInputStream());
                JSONObject json = (JSONObject)JSONValue.parse((Reader)reader);
                Metrics metrics = new Metrics(json);
                return metrics;
            }
            if (conn.getResponseCode() == 503) {
                return null;
            }
            OozieClient.handleError(conn);
            return null;
        }
    }

    private class GetOSEnv
    extends MapClientCallable {
        GetOSEnv() {
            super("GET", "admin", "os-env", OozieClient.prepareParams(new String[0]));
        }
    }

    private class GetJavaSystemProperties
    extends MapClientCallable {
        GetJavaSystemProperties() {
            super("GET", "admin", "java-sys-properties", OozieClient.prepareParams(new String[0]));
        }
    }

    private class GetServerConfiguration
    extends MapClientCallable {
        GetServerConfiguration() {
            super("GET", "admin", "configuration", OozieClient.prepareParams(new String[0]));
        }
    }

    private class GetAvailableOozieServers
    extends MapClientCallable {
        GetAvailableOozieServers() {
            super("GET", "admin", "available-oozie-servers", OozieClient.prepareParams(new String[0]));
        }
    }

    private class GetQueueDump
    extends ClientCallable<List<String>> {
        GetQueueDump() {
            super("GET", "admin", "queue-dump", OozieClient.prepareParams(new String[0]));
        }

        @Override
        protected List<String> call(HttpURLConnection conn) throws IOException, OozieClientException {
            if (conn.getResponseCode() == 200) {
                InputStreamReader reader = new InputStreamReader(conn.getInputStream());
                JSONObject json = (JSONObject)JSONValue.parse((Reader)reader);
                JSONArray queueDumpArray = (JSONArray)json.get((Object)"queueDump");
                ArrayList<String> list = new ArrayList<String>();
                list.add("[Server Queue Dump]:");
                for (Object o : queueDumpArray) {
                    JSONObject entry = (JSONObject)o;
                    if (entry.get((Object)"callableDump") == null) continue;
                    String value = (String)entry.get((Object)"callableDump");
                    list.add(value);
                }
                if (queueDumpArray.size() == 0) {
                    list.add("Queue dump is null!");
                }
                list.add("******************************************");
                list.add("[Server Uniqueness Map Dump]:");
                JSONArray uniqueDumpArray = (JSONArray)json.get((Object)"uniqueMapDump");
                for (Object o : uniqueDumpArray) {
                    JSONObject entry = (JSONObject)o;
                    if (entry.get((Object)"uniqueEntryDump") == null) continue;
                    String value = (String)entry.get((Object)"uniqueEntryDump");
                    list.add(value);
                }
                if (uniqueDumpArray.size() == 0) {
                    list.add("Uniqueness dump is null!");
                }
                return list;
            }
            OozieClient.handleError(conn);
            return null;
        }
    }

    private class Status
    extends ClientCallable<String> {
        Status(String jobId) {
            super("GET", "job", OozieClient.notEmpty(jobId, "jobId"), OozieClient.prepareParams("show", "status"));
        }

        @Override
        protected String call(HttpURLConnection conn) throws IOException, OozieClientException {
            if (conn.getResponseCode() == 200) {
                InputStreamReader reader = new InputStreamReader(conn.getInputStream());
                JSONObject json = (JSONObject)JSONValue.parse((Reader)reader);
                return (String)json.get((Object)"status");
            }
            OozieClient.handleError(conn);
            return null;
        }
    }

    private class ListShareLib
    extends ClientCallable<String> {
        ListShareLib(String sharelibKey) {
            super("GET", "admin", "list_sharelib", OozieClient.prepareParams("lib", sharelibKey));
        }

        @Override
        protected String call(HttpURLConnection conn) throws IOException, OozieClientException {
            if (conn.getResponseCode() == 200) {
                StringBuffer bf = new StringBuffer();
                InputStreamReader reader = new InputStreamReader(conn.getInputStream());
                JSONObject json = (JSONObject)JSONValue.parse((Reader)reader);
                Object sharelib = json.get((Object)"sharelib");
                bf.append("[Available ShareLib]").append(System.getProperty("line.separator"));
                if (sharelib instanceof JSONArray) {
                    for (Object o : (JSONArray)sharelib) {
                        JSONObject obj = (JSONObject)o;
                        bf.append(obj.get((Object)OozieClient.FILTER_NAME)).append(System.getProperty("line.separator"));
                        if (obj.get((Object)"files") == null) continue;
                        for (Object file : (JSONArray)obj.get((Object)"files")) {
                            bf.append("\t").append(file).append(System.getProperty("line.separator"));
                        }
                    }
                    return bf.toString();
                }
            } else {
                OozieClient.handleError(conn);
            }
            return null;
        }
    }

    private class UpdateSharelib
    extends ClientCallable<String> {
        UpdateSharelib() {
            super("GET", "admin", "update_sharelib", OozieClient.prepareParams("allservers", "true"));
        }

        @Override
        protected String call(HttpURLConnection conn) throws IOException, OozieClientException {
            StringBuffer bf = new StringBuffer();
            if (conn.getResponseCode() == 200) {
                InputStreamReader reader = new InputStreamReader(conn.getInputStream());
                Object sharelib = JSONValue.parse((Reader)reader);
                bf.append("[ShareLib update status]").append(System.getProperty("line.separator"));
                if (sharelib instanceof JSONArray) {
                    for (Object o : (JSONArray)sharelib) {
                        JSONObject obj = (JSONObject)((JSONObject)o).get((Object)"sharelibUpdate");
                        for (Object key : obj.keySet()) {
                            bf.append("\t").append(key).append(" = ").append(obj.get(key)).append(System.getProperty("line.separator"));
                        }
                        bf.append(System.getProperty("line.separator"));
                    }
                } else {
                    JSONObject obj = (JSONObject)((JSONObject)sharelib).get((Object)"sharelibUpdate");
                    for (Object key : obj.keySet()) {
                        bf.append("\t").append(key).append(" = ").append(obj.get(key)).append(System.getProperty("line.separator"));
                    }
                    bf.append(System.getProperty("line.separator"));
                }
                return bf.toString();
            }
            OozieClient.handleError(conn);
            return null;
        }
    }

    private class ValidateXML
    extends ClientCallable<String> {
        String file;

        ValidateXML(String file, String user) {
            super("POST", "validate", "", OozieClient.prepareParams("file", file, OozieClient.FILTER_USER, user));
            this.file = null;
            this.file = file;
        }

        @Override
        protected String call(HttpURLConnection conn) throws IOException, OozieClientException {
            conn.setRequestProperty("content-type", "application/xml");
            if (this.file.startsWith("/")) {
                FileInputStream fi = new FileInputStream(new File(this.file));
                byte[] buffer = new byte[1024];
                int n = 0;
                while (-1 != (n = fi.read(buffer))) {
                    conn.getOutputStream().write(buffer, 0, n);
                }
            }
            if (conn.getResponseCode() == 200) {
                InputStreamReader reader = new InputStreamReader(conn.getInputStream());
                JSONObject json = (JSONObject)JSONValue.parse((Reader)reader);
                return (String)json.get((Object)"validate");
            }
            if (conn.getResponseCode() == 404) {
                return null;
            }
            OozieClient.handleError(conn);
            return null;
        }
    }

    private class GetBuildVersion
    extends ClientCallable<String> {
        GetBuildVersion() {
            super("GET", "admin", "build-version", OozieClient.prepareParams(new String[0]));
        }

        @Override
        protected String call(HttpURLConnection conn) throws IOException, OozieClientException {
            if (conn.getResponseCode() == 200) {
                InputStreamReader reader = new InputStreamReader(conn.getInputStream());
                JSONObject json = (JSONObject)JSONValue.parse((Reader)reader);
                return (String)json.get((Object)"buildVersion");
            }
            OozieClient.handleError(conn);
            return null;
        }
    }

    private class GetSystemMode
    extends ClientCallable<SYSTEM_MODE> {
        GetSystemMode() {
            super("GET", "admin", "status", OozieClient.prepareParams(new String[0]));
        }

        @Override
        protected SYSTEM_MODE call(HttpURLConnection conn) throws IOException, OozieClientException {
            if (conn.getResponseCode() == 200) {
                InputStreamReader reader = new InputStreamReader(conn.getInputStream());
                JSONObject json = (JSONObject)JSONValue.parse((Reader)reader);
                return SYSTEM_MODE.valueOf((String)json.get((Object)"systemMode"));
            }
            OozieClient.handleError(conn);
            return SYSTEM_MODE.NORMAL;
        }
    }

    private class SetSystemMode
    extends ClientCallable<Void> {
        public SetSystemMode(SYSTEM_MODE status) {
            super("PUT", "admin", "status", OozieClient.prepareParams("systemmode", (Object)((Object)status) + ""));
        }

        @Override
        public Void call(HttpURLConnection conn) throws IOException, OozieClientException {
            if (conn.getResponseCode() != 200) {
                OozieClient.handleError(conn);
            }
            return null;
        }
    }

    private class JobIdAction
    extends ClientCallable<String> {
        JobIdAction(String externalId) {
            super("GET", "jobs", "", OozieClient.prepareParams("jobtype", "wf", "external-id", externalId));
        }

        @Override
        protected String call(HttpURLConnection conn) throws IOException, OozieClientException {
            if (conn.getResponseCode() == 200) {
                InputStreamReader reader = new InputStreamReader(conn.getInputStream());
                JSONObject json = (JSONObject)JSONValue.parse((Reader)reader);
                return (String)json.get((Object)"id");
            }
            OozieClient.handleError(conn);
            return null;
        }
    }

    private class SlaInfo
    extends ClientCallable<Void> {
        SlaInfo(int start, int len, String filter) {
            super("GET", 1L, "sla", "", OozieClient.prepareParams("gt-sequence-id", Integer.toString(start), "max-events", Integer.toString(len), "filter", filter));
        }

        @Override
        protected Void call(HttpURLConnection conn) throws IOException, OozieClientException {
            conn.setRequestProperty("content-type", "application/xml");
            if (conn.getResponseCode() == 200) {
                BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                String line = null;
                while ((line = br.readLine()) != null) {
                    System.out.println(line);
                }
            } else {
                OozieClient.handleError(conn);
            }
            return null;
        }
    }

    private class BundleRerun
    extends ClientCallable<Void> {
        BundleRerun(String jobId, String coordScope, String dateScope, boolean refresh, boolean noCleanup) {
            super("PUT", "job", OozieClient.notEmpty(jobId, "jobId"), OozieClient.prepareParams("action", "bundle-rerun", "coord-scope", coordScope, "date-scope", dateScope, "refresh", Boolean.toString(refresh), "nocleanup", Boolean.toString(noCleanup)));
        }

        @Override
        protected Void call(HttpURLConnection conn) throws IOException, OozieClientException {
            conn.setRequestProperty("content-type", "application/xml");
            if (conn.getResponseCode() == 200) {
                return null;
            }
            OozieClient.handleError(conn);
            return null;
        }
    }

    private class CoordRerun
    extends ClientCallable<List<CoordinatorAction>> {
        CoordRerun(String jobId, String rerunType, String scope, boolean refresh, boolean noCleanup, boolean failed) {
            super("PUT", "job", OozieClient.notEmpty(jobId, "jobId"), OozieClient.prepareParams("action", "coord-rerun", "type", rerunType, "scope", scope, "refresh", Boolean.toString(refresh), "nocleanup", Boolean.toString(noCleanup), "failed", Boolean.toString(failed)));
        }

        @Override
        protected List<CoordinatorAction> call(HttpURLConnection conn) throws IOException, OozieClientException {
            conn.setRequestProperty("content-type", "application/xml");
            if (conn.getResponseCode() == 200) {
                InputStreamReader reader = new InputStreamReader(conn.getInputStream());
                JSONObject json = (JSONObject)JSONValue.parse((Reader)reader);
                JSONArray coordActions = (JSONArray)json.get((Object)"actions");
                return JsonToBean.createCoordinatorActionList(coordActions);
            }
            OozieClient.handleError(conn);
            return null;
        }
    }

    private class CoordIgnore
    extends ClientCallable<List<CoordinatorAction>> {
        CoordIgnore(String jobId, String rerunType, String scope) {
            super("PUT", "job", OozieClient.notEmpty(jobId, "jobId"), OozieClient.prepareParams("action", "ignore", "type", rerunType, "scope", scope));
        }

        @Override
        protected List<CoordinatorAction> call(HttpURLConnection conn) throws IOException, OozieClientException {
            conn.setRequestProperty("content-type", "application/xml");
            if (conn.getResponseCode() == 200) {
                InputStreamReader reader = new InputStreamReader(conn.getInputStream());
                JSONObject json = (JSONObject)JSONValue.parse((Reader)reader);
                if (json != null) {
                    JSONArray coordActions = (JSONArray)json.get((Object)"actions");
                    return JsonToBean.createCoordinatorActionList(coordActions);
                }
            } else {
                OozieClient.handleError(conn);
            }
            return null;
        }
    }

    private class CoordActionsKill
    extends ClientCallable<List<CoordinatorAction>> {
        CoordActionsKill(String jobId, String rangeType, String scope) {
            super("PUT", "job", OozieClient.notEmpty(jobId, "jobId"), OozieClient.prepareParams("action", "kill", "type", rangeType, "scope", scope));
        }

        @Override
        protected List<CoordinatorAction> call(HttpURLConnection conn) throws IOException, OozieClientException {
            conn.setRequestProperty("content-type", "application/xml");
            if (conn.getResponseCode() == 200) {
                InputStreamReader reader = new InputStreamReader(conn.getInputStream());
                JSONObject json = (JSONObject)JSONValue.parse((Reader)reader);
                JSONArray coordActions = (JSONArray)json.get((Object)"actions");
                return JsonToBean.createCoordinatorActionList(coordActions);
            }
            OozieClient.handleError(conn);
            return null;
        }
    }

    private class BulkResponseStatus
    extends ClientCallable<List<BulkResponse>> {
        BulkResponseStatus(String filter, int start, int len) {
            super("GET", "jobs", "", OozieClient.prepareParams("bulk", filter, "offset", Integer.toString(start), "len", Integer.toString(len)));
        }

        @Override
        protected List<BulkResponse> call(HttpURLConnection conn) throws IOException, OozieClientException {
            conn.setRequestProperty("content-type", "application/xml");
            if (conn.getResponseCode() == 200) {
                InputStreamReader reader = new InputStreamReader(conn.getInputStream());
                JSONObject json = (JSONObject)JSONValue.parse((Reader)reader);
                JSONArray results = (JSONArray)json.get(JsonTags.BULK_RESPONSES);
                if (results == null) {
                    results = new JSONArray();
                }
                return JsonToBean.createBulkResponseList(results);
            }
            OozieClient.handleError(conn);
            return null;
        }
    }

    private class BundleJobsStatus
    extends ClientCallable<List<BundleJob>> {
        BundleJobsStatus(String filter, int start, int len) {
            super("GET", "jobs", "", OozieClient.prepareParams("filter", filter, "jobtype", "bundle", "offset", Integer.toString(start), "len", Integer.toString(len)));
        }

        @Override
        protected List<BundleJob> call(HttpURLConnection conn) throws IOException, OozieClientException {
            conn.setRequestProperty("content-type", "application/xml");
            if (conn.getResponseCode() == 200) {
                InputStreamReader reader = new InputStreamReader(conn.getInputStream());
                JSONObject json = (JSONObject)JSONValue.parse((Reader)reader);
                JSONArray jobs = (JSONArray)json.get(JsonTags.BUNDLE_JOBS);
                if (jobs == null) {
                    jobs = new JSONArray();
                }
                return JsonToBean.createBundleJobList(jobs);
            }
            OozieClient.handleError(conn);
            return null;
        }
    }

    private class CoordJobsStatus
    extends ClientCallable<List<CoordinatorJob>> {
        CoordJobsStatus(String filter, int start, int len) {
            super("GET", "jobs", "", OozieClient.prepareParams("filter", filter, "jobtype", "coord", "offset", Integer.toString(start), "len", Integer.toString(len)));
        }

        @Override
        protected List<CoordinatorJob> call(HttpURLConnection conn) throws IOException, OozieClientException {
            conn.setRequestProperty("content-type", "application/xml");
            if (conn.getResponseCode() == 200) {
                InputStreamReader reader = new InputStreamReader(conn.getInputStream());
                JSONObject json = (JSONObject)JSONValue.parse((Reader)reader);
                JSONArray jobs = (JSONArray)json.get(JsonTags.COORDINATOR_JOBS);
                if (jobs == null) {
                    jobs = new JSONArray();
                }
                return JsonToBean.createCoordinatorJobList(jobs);
            }
            OozieClient.handleError(conn);
            return null;
        }
    }

    private class JobsStatus
    extends ClientCallable<List<WorkflowJob>> {
        JobsStatus(String filter, int start, int len) {
            super("GET", "jobs", "", OozieClient.prepareParams("filter", filter, "jobtype", "wf", "offset", Integer.toString(start), "len", Integer.toString(len)));
        }

        @Override
        protected List<WorkflowJob> call(HttpURLConnection conn) throws IOException, OozieClientException {
            conn.setRequestProperty("content-type", "application/xml");
            if (conn.getResponseCode() == 200) {
                InputStreamReader reader = new InputStreamReader(conn.getInputStream());
                JSONObject json = (JSONObject)JSONValue.parse((Reader)reader);
                JSONArray workflows = (JSONArray)json.get((Object)"workflows");
                if (workflows == null) {
                    workflows = new JSONArray();
                }
                return JsonToBean.createWorkflowJobList(workflows);
            }
            OozieClient.handleError(conn);
            return null;
        }
    }

    private class CoordActionInfo
    extends ClientCallable<CoordinatorAction> {
        CoordActionInfo(String actionId) {
            super("GET", "job", OozieClient.notEmpty(actionId, "id"), OozieClient.prepareParams("show", "info"));
        }

        @Override
        protected CoordinatorAction call(HttpURLConnection conn) throws IOException, OozieClientException {
            if (conn.getResponseCode() == 200) {
                InputStreamReader reader = new InputStreamReader(conn.getInputStream());
                JSONObject json = (JSONObject)JSONValue.parse((Reader)reader);
                return JsonToBean.createCoordinatorAction(json);
            }
            OozieClient.handleError(conn);
            return null;
        }
    }

    private class BundleJobInfo
    extends ClientCallable<BundleJob> {
        BundleJobInfo(String jobId) {
            super("GET", "job", OozieClient.notEmpty(jobId, "jobId"), OozieClient.prepareParams("show", "info"));
        }

        @Override
        protected BundleJob call(HttpURLConnection conn) throws IOException, OozieClientException {
            if (conn.getResponseCode() == 200) {
                InputStreamReader reader = new InputStreamReader(conn.getInputStream());
                JSONObject json = (JSONObject)JSONValue.parse((Reader)reader);
                return JsonToBean.createBundleJob(json);
            }
            OozieClient.handleError(conn);
            return null;
        }
    }

    private class WfsForCoordAction
    extends ClientCallable<List<WorkflowJob>> {
        WfsForCoordAction(String coordActionId) {
            super("GET", "job", OozieClient.notEmpty(coordActionId, "coordActionId"), OozieClient.prepareParams("show", "allruns"));
        }

        @Override
        protected List<WorkflowJob> call(HttpURLConnection conn) throws IOException, OozieClientException {
            if (conn.getResponseCode() == 200) {
                InputStreamReader reader = new InputStreamReader(conn.getInputStream());
                JSONObject json = (JSONObject)JSONValue.parse((Reader)reader);
                JSONArray workflows = (JSONArray)json.get((Object)"workflows");
                if (workflows == null) {
                    workflows = new JSONArray();
                }
                return JsonToBean.createWorkflowJobList(workflows);
            }
            OozieClient.handleError(conn);
            return null;
        }
    }

    private class CoordJobInfo
    extends ClientCallable<CoordinatorJob> {
        CoordJobInfo(String jobId, String filter, int start, int len, String order) {
            super("GET", "job", OozieClient.notEmpty(jobId, "jobId"), OozieClient.prepareParams("show", "info", "filter", filter, "offset", Integer.toString(start), "len", Integer.toString(len), "order", order));
        }

        @Override
        protected CoordinatorJob call(HttpURLConnection conn) throws IOException, OozieClientException {
            if (conn.getResponseCode() == 200) {
                InputStreamReader reader = new InputStreamReader(conn.getInputStream());
                JSONObject json = (JSONObject)JSONValue.parse((Reader)reader);
                return JsonToBean.createCoordinatorJob(json);
            }
            OozieClient.handleError(conn);
            return null;
        }
    }

    private class JobMetadata
    extends ClientCallable<String> {
        PrintStream printStream;

        JobMetadata(String jobId, String metaType) {
            super("GET", "job", OozieClient.notEmpty(jobId, "jobId"), OozieClient.prepareParams("show", metaType));
        }

        JobMetadata(String jobId, String logRetrievalType, String logRetrievalScope, String metaType, String logFilter, PrintStream ps) {
            super("GET", "job", OozieClient.notEmpty(jobId, "jobId"), OozieClient.prepareParams("show", metaType, "type", logRetrievalType, "scope", logRetrievalScope, "logfilter", logFilter));
            this.printStream = ps;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected String call(HttpURLConnection conn) throws IOException, OozieClientException {
            String returnVal = null;
            if (conn.getResponseCode() == 200) {
                InputStream is = conn.getInputStream();
                try (InputStreamReader isr = new InputStreamReader(is);){
                    if (this.printStream != null) {
                        this.sendToOutputStream(isr, -1);
                    }
                    returnVal = this.getReaderAsString(isr, -1);
                }
            } else {
                OozieClient.handleError(conn);
            }
            return returnVal;
        }

        private void sendToOutputStream(Reader reader, int maxLen) throws IOException {
            int read;
            if (reader == null) {
                throw new IllegalArgumentException("reader cannot be null");
            }
            StringBuilder sb = new StringBuilder();
            char[] buffer = new char[2048];
            int count = 0;
            int noOfCharstoFlush = 1024;
            while ((read = reader.read(buffer)) > -1 && (maxLen <= -1 || (count += read) <= maxLen)) {
                sb.append(buffer, 0, read);
                if (sb.length() <= noOfCharstoFlush) continue;
                this.printStream.print(sb.toString());
                sb = new StringBuilder("");
            }
            this.printStream.print(sb.toString());
        }

        private String getReaderAsString(Reader reader, int maxLen) throws IOException {
            int read;
            if (reader == null) {
                throw new IllegalArgumentException("reader cannot be null");
            }
            StringBuffer sb = new StringBuffer();
            char[] buffer = new char[2048];
            int count = 0;
            while ((read = reader.read(buffer)) > -1 && (maxLen <= -1 || (count += read) <= maxLen)) {
                sb.append(buffer, 0, read);
            }
            reader.close();
            return sb.toString();
        }
    }

    private class JobDefinition
    extends JobMetadata {
        JobDefinition(String jobId) {
            super(jobId, "definition");
        }
    }

    private class JMSTopic
    extends ClientCallable<String> {
        JMSTopic(String jobId) {
            super("GET", "job", OozieClient.notEmpty(jobId, "jobId"), OozieClient.prepareParams("show", "jmstopic"));
        }

        @Override
        protected String call(HttpURLConnection conn) throws IOException, OozieClientException {
            if (conn.getResponseCode() == 200) {
                InputStreamReader reader = new InputStreamReader(conn.getInputStream());
                JSONObject json = (JSONObject)JSONValue.parse((Reader)reader);
                return (String)json.get((Object)"jmsTopicName");
            }
            OozieClient.handleError(conn);
            return null;
        }
    }

    private class JobLog
    extends JobMetadata {
        JobLog(String jobId) {
            super(jobId, "log");
        }

        JobLog(String jobId, String logRetrievalType, String logRetrievalScope, String logFilter, PrintStream ps) {
            super(jobId, logRetrievalType, logRetrievalScope, "log", logFilter, ps);
        }
    }

    private class WorkflowActionInfo
    extends ClientCallable<WorkflowAction> {
        WorkflowActionInfo(String actionId) {
            super("GET", "job", OozieClient.notEmpty(actionId, "id"), OozieClient.prepareParams("show", "info"));
        }

        @Override
        protected WorkflowAction call(HttpURLConnection conn) throws IOException, OozieClientException {
            if (conn.getResponseCode() == 200) {
                InputStreamReader reader = new InputStreamReader(conn.getInputStream());
                JSONObject json = (JSONObject)JSONValue.parse((Reader)reader);
                return JsonToBean.createWorkflowAction(json);
            }
            OozieClient.handleError(conn);
            return null;
        }
    }

    private class JMSInfo
    extends ClientCallable<JMSConnectionInfo> {
        JMSInfo() {
            super("GET", "admin", "jmsinfo", OozieClient.prepareParams(new String[0]));
        }

        @Override
        protected JMSConnectionInfo call(HttpURLConnection conn) throws IOException, OozieClientException {
            if (conn.getResponseCode() == 200) {
                InputStreamReader reader = new InputStreamReader(conn.getInputStream());
                JSONObject json = (JSONObject)JSONValue.parse((Reader)reader);
                return JsonToBean.createJMSConnectionInfo(json);
            }
            OozieClient.handleError(conn);
            return null;
        }
    }

    private class JobInfo
    extends ClientCallable<WorkflowJob> {
        JobInfo(String jobId, int start, int len) {
            super("GET", "job", OozieClient.notEmpty(jobId, "jobId"), OozieClient.prepareParams("show", "info", "offset", Integer.toString(start), "len", Integer.toString(len)));
        }

        @Override
        protected WorkflowJob call(HttpURLConnection conn) throws IOException, OozieClientException {
            if (conn.getResponseCode() == 200) {
                InputStreamReader reader = new InputStreamReader(conn.getInputStream());
                JSONObject json = (JSONObject)JSONValue.parse((Reader)reader);
                return JsonToBean.createWorkflowJob(json);
            }
            OozieClient.handleError(conn);
            return null;
        }
    }

    private class UpdateCoord
    extends ClientCallable<String> {
        private final Properties conf;

        public UpdateCoord(String jobId, Properties conf, String jobActionDryrun, String showDiff) {
            super("PUT", "job", OozieClient.notEmpty(jobId, "jobId"), OozieClient.prepareParams("action", "update", "dryrun", jobActionDryrun, "diff", showDiff));
            this.conf = conf;
        }

        public UpdateCoord(String jobId, String jobActionDryrun, String showDiff) {
            this(jobId, new Properties(), jobActionDryrun, showDiff);
        }

        @Override
        protected String call(HttpURLConnection conn) throws IOException, OozieClientException {
            conn.setRequestProperty("content-type", "application/xml");
            OozieClient.this.writeToXml(this.conf, conn.getOutputStream());
            if (conn.getResponseCode() == 200) {
                JSONObject json = (JSONObject)JSONValue.parse((Reader)new InputStreamReader(conn.getInputStream()));
                JSONObject update = (JSONObject)json.get((Object)"update");
                if (update != null) {
                    return (String)update.get((Object)"diff");
                }
                return "";
            }
            if (conn.getResponseCode() != 200) {
                OozieClient.handleError(conn);
            }
            return null;
        }
    }

    private class JobsAction
    extends ClientCallable<JSONObject> {
        JobsAction(String action, String filter, String jobType, int start, int len) {
            super("PUT", "jobs", "", OozieClient.prepareParams("action", action, "filter", filter, "jobtype", jobType, "offset", Integer.toString(start), "len", Integer.toString(len)));
        }

        @Override
        protected JSONObject call(HttpURLConnection conn) throws IOException, OozieClientException {
            conn.setRequestProperty("content-type", "application/xml");
            if (conn.getResponseCode() == 200) {
                InputStreamReader reader = new InputStreamReader(conn.getInputStream());
                JSONObject json = (JSONObject)JSONValue.parse((Reader)reader);
                return json;
            }
            OozieClient.handleError(conn);
            return null;
        }
    }

    private class JobAction
    extends ClientCallable<Void> {
        JobAction(String jobId, String action) {
            super("PUT", "job", OozieClient.notEmpty(jobId, "jobId"), OozieClient.prepareParams("action", action));
        }

        JobAction(String jobId, String action, String params) {
            super("PUT", "job", OozieClient.notEmpty(jobId, "jobId"), OozieClient.prepareParams("action", action, "value", params));
        }

        @Override
        protected Void call(HttpURLConnection conn) throws IOException, OozieClientException {
            if (conn.getResponseCode() != 200) {
                OozieClient.handleError(conn);
            }
            return null;
        }
    }

    private class JobSubmit
    extends ClientCallable<String> {
        private final Properties conf;

        JobSubmit(Properties conf, boolean start) {
            super("POST", "jobs", "", start ? OozieClient.prepareParams("action", "start") : OozieClient.prepareParams(new String[0]));
            this.conf = OozieClient.notNull(conf, "conf");
        }

        JobSubmit(String jobId, Properties conf) {
            super("PUT", "job", OozieClient.notEmpty(jobId, "jobId"), OozieClient.prepareParams("action", "rerun"));
            this.conf = OozieClient.notNull(conf, "conf");
        }

        public JobSubmit(Properties conf, String jobActionDryrun) {
            super("POST", "jobs", "", OozieClient.prepareParams("action", "dryrun"));
            this.conf = OozieClient.notNull(conf, "conf");
        }

        @Override
        protected String call(HttpURLConnection conn) throws IOException, OozieClientException {
            conn.setRequestProperty("content-type", "application/xml");
            OozieClient.this.writeToXml(this.conf, conn.getOutputStream());
            if (conn.getResponseCode() == 201) {
                JSONObject json = (JSONObject)JSONValue.parse((Reader)new InputStreamReader(conn.getInputStream()));
                return (String)json.get((Object)"id");
            }
            if (conn.getResponseCode() != 200) {
                OozieClient.handleError(conn);
            }
            return null;
        }
    }

    protected abstract class MapClientCallable
    extends ClientCallable<Map<String, String>> {
        MapClientCallable(String method, String collection, String resource, Map<String, String> params) {
            super(method, collection, resource, params);
        }

        @Override
        protected Map<String, String> call(HttpURLConnection conn) throws IOException, OozieClientException {
            if (conn.getResponseCode() == 200) {
                InputStreamReader reader = new InputStreamReader(conn.getInputStream());
                JSONObject json = (JSONObject)JSONValue.parse((Reader)reader);
                HashMap<String, String> map = new HashMap<String, String>();
                for (Object key : json.keySet()) {
                    map.put((String)key, (String)json.get(key));
                }
                return map;
            }
            OozieClient.handleError(conn);
            return null;
        }
    }

    protected abstract class ClientCallable<T>
    implements Callable<T> {
        private final String method;
        private final String collection;
        private final String resource;
        private final Map<String, String> params;
        private final Long protocolVersion;

        public ClientCallable(String method, String collection, String resource, Map<String, String> params) {
            this(method, null, collection, resource, params);
        }

        public ClientCallable(String method, Long protocolVersion, String collection, String resource, Map<String, String> params) {
            this.method = method;
            this.protocolVersion = protocolVersion;
            this.collection = collection;
            this.resource = resource;
            this.params = params;
        }

        @Override
        public T call() throws OozieClientException {
            try {
                URL url = OozieClient.this.createURL(this.protocolVersion, this.collection, this.resource, this.params);
                if (OozieClient.this.validateCommand(url.toString())) {
                    if (OozieClient.this.getDebugMode() > 0) {
                        System.out.println(this.method + " " + url);
                    }
                    return this.call(OozieClient.this.createRetryableConnection(url, this.method));
                }
                System.out.println("Option not supported in target server. Supported only on Oozie-2.0 or greater. Use 'oozie help' for details");
                throw new OozieClientException("UNSUPPORTED_VERSION", new Exception());
            }
            catch (IOException ex) {
                throw new OozieClientException("IO_ERROR", ex);
            }
        }

        protected abstract T call(HttpURLConnection var1) throws IOException, OozieClientException;
    }

    public static enum SYSTEM_MODE {
        NORMAL,
        NOWEBSERVICE,
        SAFEMODE;

    }

    public static enum SORT_BY {
        createdTime("createdTimestamp"),
        lastModifiedTime("lastModifiedTimestamp");

        private final String fullname;

        private SORT_BY(String fullname) {
            this.fullname = fullname;
        }

        public String getFullname() {
            return this.fullname;
        }
    }
}

