/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.engine.core.audit;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.pentaho.platform.api.engine.AuditException;
import org.pentaho.platform.api.engine.IAuditEntry;
import org.pentaho.platform.engine.core.system.PentahoSystem;

public class AuditEntry {
    private static final Map<String, Long> messageTypeCountMap = new HashMap<String, Long>();
    private static final Date counterResetDateTime = new Date();

    public static void auditJobDuration(String jobId, String instId, String objId, String objType, String actor, String messageType, String messageName, String messageTxtValue, float duration) throws AuditException {
        AuditEntry.auditAll(jobId, instId, objId, objType, actor, messageType, messageName, messageTxtValue, null, duration);
    }

    public static void auditAll(String jobId, String instId, String objId, String objType, String actor, String messageType, String messageName, String messageTxtValue, BigDecimal messageNumValue, float duration) throws AuditException {
        Long count;
        IAuditEntry auditEntry = null;
        if (PentahoSystem.getObjectFactory().objectDefined(IAuditEntry.class.getSimpleName())) {
            auditEntry = PentahoSystem.get(IAuditEntry.class, null);
            auditEntry.auditAll(jobId, instId, objId, objType, actor, messageType, messageName, messageTxtValue, messageNumValue, (double)duration);
        }
        if ((count = messageTypeCountMap.get(messageType)) == null) {
            messageTypeCountMap.put(messageType, new Long(1L));
        } else {
            messageTypeCountMap.put(messageType, new Long(count + 1L));
        }
    }

    public static void auditJobTxtValue(String jobId, String instId, String objId, String objType, String actor, String messageType, String messageName, String messageTxtValue) throws AuditException {
        AuditEntry.auditAll(jobId, instId, objId, objType, actor, messageType, messageName, messageTxtValue, null, 0.0f);
    }

    public static void auditJobNumValue(String jobId, String instId, String objId, String objType, String actor, String messageType, String messageName, BigDecimal messageNumValue) throws AuditException {
        AuditEntry.auditAll(jobId, instId, objId, objType, actor, messageType, messageName, null, messageNumValue, 0.0f);
    }

    public static void clearCounts() {
        messageTypeCountMap.clear();
        counterResetDateTime.setTime(new Date().getTime());
    }

    public static Map<String, Long> getCounts() {
        return messageTypeCountMap;
    }

    public static Date getCounterResetDateTime() {
        return counterResetDateTime;
    }
}

