/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.engine.services.runtime;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.pentaho.commons.connection.IPentahoMetaData;
import org.pentaho.commons.connection.IPentahoResultSet;
import org.pentaho.platform.api.engine.IActionParameter;
import org.pentaho.platform.api.engine.ISelectionMapper;

public class SelectionMapper
implements ISelectionMapper {
    Map selNames;
    List selValues;
    String displayName;
    String displayStyle;

    public static SelectionMapper create(IPentahoResultSet resultSet, String displayName, String displayStyle) {
        return SelectionMapper.create(resultSet, 1, -1, displayName, displayStyle);
    }

    public static SelectionMapper create(IPentahoResultSet resultSet, String valueColName, String dispColName, String displayName, String displayStyle) {
        int valueColumnNo;
        if (resultSet == null) {
            return null;
        }
        IPentahoMetaData metaData = resultSet.getMetaData();
        if (metaData == null || metaData.getColumnCount() < 1) {
            return null;
        }
        int n = valueColumnNo = valueColName == null ? 0 : metaData.getColumnIndex(valueColName);
        if (valueColumnNo < 0) {
            return null;
        }
        int dispColumnNo = -1;
        if (dispColName != null && (dispColumnNo = metaData.getColumnIndex(dispColName)) < 0) {
            return null;
        }
        return SelectionMapper.create(resultSet, ++valueColumnNo, ++dispColumnNo, displayName, displayStyle);
    }

    public static SelectionMapper create(IPentahoResultSet resultSet, int valueColIndex, int dispColIndex, String displayName, String displayStyle) {
        --dispColIndex;
        if (resultSet == null || --valueColIndex < 0) {
            return null;
        }
        IPentahoMetaData metaData = resultSet.getMetaData();
        if (metaData == null || metaData.getColumnCount() < valueColIndex || metaData.getColumnCount() < dispColIndex) {
            return null;
        }
        ArrayList<Object> values = new ArrayList<Object>();
        HashMap<Object, Object> displayNames = dispColIndex < 0 ? null : new HashMap<Object, Object>();
        Object[] row = resultSet.next();
        while (row != null) {
            Object value = row[valueColIndex];
            if (value != null) {
                value = value.toString();
                values.add(value);
                if (displayNames != null) {
                    Object name = row[dispColIndex];
                    displayNames.put(value, name != null ? name.toString() : value);
                }
            }
            row = resultSet.next();
        }
        resultSet.close();
        return new SelectionMapper(values, displayNames, displayName, displayStyle);
    }

    public static SelectionMapper create(IActionParameter actionParam, String valueColName, String dispColName, String displayName, String displayStyle) {
        if (actionParam == null) {
            return null;
        }
        Object value = actionParam.getValue();
        if (value instanceof IPentahoResultSet) {
            return SelectionMapper.create((IPentahoResultSet)value, valueColName, dispColName, displayName, displayStyle);
        }
        if ("property-map-list".equals(actionParam.getType())) {
            return SelectionMapper.createFromPropMapList((List)value, valueColName, dispColName, displayName, displayStyle);
        }
        if (value instanceof List) {
            return new SelectionMapper((List)value, null, displayName, displayStyle);
        }
        return null;
    }

    public static SelectionMapper createFromPropMapList(List aList, String valueColName, String dispColName, String displayName, String displayStyle) {
        if (aList == null) {
            return null;
        }
        ArrayList<String> selValues = new ArrayList<String>();
        HashMap<String, String> dispMap = new HashMap<String, String>();
        Iterator it = aList.iterator();
        while (it.hasNext()) {
            try {
                String disp;
                Map hm = (Map)it.next();
                String val = hm.get(valueColName).toString();
                if (val != null) {
                    selValues.add(val);
                }
                if ((disp = hm.get(dispColName).toString()) == null) continue;
                dispMap.put(val, disp);
            }
            catch (Exception exception) {}
        }
        return new SelectionMapper(selValues, dispMap, displayName, displayStyle);
    }

    private SelectionMapper(List selValues, Map selNames, String displayName, String displayStyle) {
        this.displayName = displayName != null ? displayName : "";
        this.selNames = selNames;
        this.selValues = selValues != null ? selValues : new ArrayList();
        this.displayStyle = displayStyle;
    }

    public String getDisplayStyle() {
        return this.displayStyle;
    }

    public String getSelectionDisplayName() {
        return this.displayName;
    }

    public String getSelectionNameForValue(String val) {
        Object rtn = null;
        if (this.selNames != null) {
            rtn = this.selNames.get(val);
        }
        return rtn == null ? val : rtn.toString();
    }

    public List getSelectionValues() {
        return this.selValues;
    }

    public Map getSelectionNameMap() {
        return this.selNames;
    }

    public boolean hasValue(String value) {
        return this.selValues.contains(value);
    }

    public int selectionCount() {
        return this.selValues.size();
    }

    public String getValueAt(int index) {
        return this.selValues.get(index).toString();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("Display Name: ").append(this.getSelectionDisplayName()).append(" [");
        Iterator it = this.selValues.iterator();
        while (it.hasNext()) {
            String value = it.next().toString();
            sb.append(" [").append(value).append(" : ").append(this.getSelectionNameForValue(value)).append("] ");
        }
        sb.append("]");
        return sb.toString();
    }
}

