/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.util.messages;

import java.text.MessageFormat;
import java.util.ResourceBundle;

public class MessageUtil {
    public static String formatErrorMessage(String key, String msg) {
        int end = key.indexOf(".ERROR_");
        end = end < 0 ? key.length() : Math.min(end + ".ERROR_0000".length(), key.length());
        return key.substring(0, end) + " - " + msg;
    }

    public static String getString(ResourceBundle bundle, String key) {
        try {
            return bundle.getString(key);
        }
        catch (Exception e) {
            return '!' + key + '!';
        }
    }

    public static String getString(ResourceBundle bundle, String key, Object ... params) {
        try {
            return MessageFormat.format(bundle.getString(key), params);
        }
        catch (Exception e) {
            return '!' + key + '!';
        }
    }

    public static String getErrorString(ResourceBundle bundle, String key) {
        return MessageUtil.formatErrorMessage(key, MessageUtil.getString(bundle, key));
    }

    public static String getErrorString(ResourceBundle bundle, String key, Object ... params) {
        return MessageUtil.formatErrorMessage(key, MessageUtil.getString(bundle, key, params));
    }

    public static String formatMessage(String pattern, Object ... params) {
        try {
            return MessageFormat.format(pattern, params);
        }
        catch (Exception e) {
            return '!' + pattern + '!';
        }
    }
}

