/*
 * Decompiled with CFR 0.152.
 */
package com.debortoliwines.openerp.api;

import com.debortoliwines.openerp.api.SelectionOption;
import java.util.ArrayList;
import java.util.HashMap;

public class Field {
    private final String name;
    private final HashMap<String, Object> openERPFieldData;

    public Field(String fieldName, HashMap<String, Object> openERPFieldData) {
        this.openERPFieldData = openERPFieldData;
        this.name = fieldName;
    }

    public Object getFieldProperty(String propertyName) {
        Object value = null;
        if (this.openERPFieldData.containsKey(propertyName)) {
            value = this.openERPFieldData.get(propertyName);
        }
        return value;
    }

    public Object[][] getStateProperties(String propertyName) {
        ArrayList<Object[]> stateValues = new ArrayList<Object[]>();
        HashMap states = (HashMap)this.getFieldProperty("states");
        if (states != null) {
            Object[] stateValue = new Object[2];
            for (String stateKey : states.keySet()) {
                stateValue[0] = stateKey.toString();
                for (Object stateProperty : (Object[])states.get(stateKey)) {
                    Object[] statePropertyArr = (Object[])stateProperty;
                    if (!statePropertyArr[0].toString().equals(propertyName)) continue;
                    stateValue[1] = statePropertyArr[1];
                    stateValues.add(stateValue);
                }
            }
        }
        return (Object[][])stateValues.toArray((T[])new Object[0][]);
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return (String)this.getFieldProperty("string");
    }

    public FieldType getType() {
        String fieldType = (String)this.getFieldProperty("type");
        if (fieldType.equalsIgnoreCase("char")) {
            return FieldType.CHAR;
        }
        if (fieldType.equalsIgnoreCase("text")) {
            return FieldType.TEXT;
        }
        if (fieldType.equalsIgnoreCase("integer")) {
            return FieldType.INTEGER;
        }
        if (fieldType.equalsIgnoreCase("binary")) {
            return FieldType.BINARY;
        }
        if (fieldType.equalsIgnoreCase("boolean")) {
            return FieldType.BOOLEAN;
        }
        if (fieldType.equalsIgnoreCase("float")) {
            return FieldType.FLOAT;
        }
        if (fieldType.equalsIgnoreCase("datetime")) {
            return FieldType.DATETIME;
        }
        if (fieldType.equalsIgnoreCase("date")) {
            return FieldType.DATE;
        }
        if (fieldType.equalsIgnoreCase("many2one")) {
            return FieldType.MANY2ONE;
        }
        if (fieldType.equalsIgnoreCase("one2many")) {
            return FieldType.ONE2MANY;
        }
        if (fieldType.equalsIgnoreCase("many2many")) {
            return FieldType.MANY2MANY;
        }
        if (fieldType.equalsIgnoreCase("selection")) {
            return FieldType.SELECTION;
        }
        return FieldType.CHAR;
    }

    public boolean getRequired() {
        Object value = this.getFieldProperty("required");
        if (value == null) {
            return false;
        }
        return (Boolean)value;
    }

    public boolean getSelectable() {
        Object value = this.getFieldProperty("selectable");
        if (value == null) {
            return true;
        }
        return (Boolean)value;
    }

    public ArrayList<SelectionOption> getSelectionOptions() {
        if (this.getType() != FieldType.SELECTION) {
            return null;
        }
        ArrayList<SelectionOption> options = new ArrayList<SelectionOption>();
        Object values = this.getFieldProperty("selection");
        if (values instanceof Object[]) {
            for (Object val : (Object[])values) {
                Object[] multiVal = (Object[])val;
                options.add(new SelectionOption(multiVal[0].toString(), multiVal[1].toString()));
            }
        }
        return options;
    }

    public int getSize() {
        Object value = this.getFieldProperty("size");
        if (value == null) {
            return 64;
        }
        return (Integer)value;
    }

    public String getHelp() {
        return (String)this.getFieldProperty("help");
    }

    public boolean getStore() {
        Object value = this.getFieldProperty("store");
        if (value == null) {
            return true;
        }
        return (Boolean)value;
    }

    public boolean getFunc_method() {
        Object value = this.getFieldProperty("func_method");
        if (value == null) {
            return false;
        }
        return (Boolean)value;
    }

    public String getRelation() {
        Object value = this.getFieldProperty("relation");
        if (value == null) {
            return "";
        }
        return (String)value;
    }

    public boolean getReadonly() {
        Object value = this.getFieldProperty("readonly");
        if (value == null) {
            return false;
        }
        return (Boolean)(value instanceof Integer ? Boolean.valueOf((Integer)value == 1) : value);
    }

    public static enum FieldType {
        INTEGER,
        CHAR,
        TEXT,
        BINARY,
        BOOLEAN,
        FLOAT,
        DATETIME,
        DATE,
        MANY2ONE,
        ONE2MANY,
        MANY2MANY,
        SELECTION;

    }
}

