/*
 * Decompiled with CFR 0.152.
 */
package com.debortoliwines.openerp.api.helpers;

import com.debortoliwines.openerp.api.Field;
import com.debortoliwines.openerp.api.FieldCollection;
import com.debortoliwines.openerp.api.Row;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import org.apache.xmlrpc.XmlRpcException;

public class FlatViewHelper {
    public static FlatViewFieldCollection getFields(String objectName, FieldCollection fields) throws XmlRpcException {
        FlatViewFieldCollection flatViewFields = new FlatViewFieldCollection();
        flatViewFields.add(new FlatViewField("id", null, -1, objectName, "id", "Database ID", Integer.class));
        block8: for (Field fld : fields) {
            Field.FieldType fieldType = fld.getType();
            switch (fieldType) {
                case BINARY: {
                    flatViewFields.add(new FlatViewField(fld.getName(), fld, -1, objectName, fld.getName(), fld.getDescription(), Byte[].class));
                    continue block8;
                }
                case BOOLEAN: {
                    flatViewFields.add(new FlatViewField(fld.getName(), fld, -1, objectName, fld.getName(), fld.getDescription(), Boolean.class));
                    continue block8;
                }
                case INTEGER: {
                    flatViewFields.add(new FlatViewField(fld.getName(), fld, -1, objectName, fld.getName(), fld.getDescription(), Integer.class));
                    continue block8;
                }
                case FLOAT: {
                    flatViewFields.add(new FlatViewField(fld.getName(), fld, -1, objectName, fld.getName(), fld.getDescription(), Float.class));
                    continue block8;
                }
                case DATETIME: 
                case DATE: {
                    flatViewFields.add(new FlatViewField(fld.getName(), fld, -1, objectName, fld.getName(), fld.getDescription(), Date.class));
                    continue block8;
                }
                case MANY2ONE: {
                    flatViewFields.add(new FlatViewField(fld.getName() + "##id", fld, 0, fld.getRelation(), fld.getName() + "_id", fld.getDescription() + "/Id", Integer.class));
                    flatViewFields.add(new FlatViewField(fld.getName() + "##name", fld, 1, fld.getRelation(), fld.getName() + "_name", fld.getDescription() + "/Id", String.class));
                    continue block8;
                }
            }
            flatViewFields.add(new FlatViewField(fld.getName(), fld, -1, objectName, fld.getName(), fld.getDescription(), String.class));
        }
        return flatViewFields;
    }

    public static String[] getFieldNames(String objectName, FieldCollection fields) throws XmlRpcException {
        ArrayList<String> fieldNames = new ArrayList<String>();
        for (FlatViewField fld : FlatViewHelper.getFields(objectName, fields)) {
            fieldNames.add(fld.getName());
        }
        return fieldNames.toArray(new String[0]);
    }

    public static String[] getOriginalFieldNames(String objectName, FlatViewFieldCollection fields) {
        ArrayList<String> fieldNames = new ArrayList<String>();
        for (FlatViewField fld : fields) {
            if (fieldNames.indexOf(fld.getSourceField().getName()) >= 0) continue;
            fieldNames.add(fld.getName());
        }
        return fieldNames.toArray(new String[0]);
    }

    public static Object getRowValue(Row row, FlatViewField fld) {
        Object value = fld.getName().equals("id") ? row.get("id") : row.get(fld.getSourceField());
        if (fld.getSourceFieldIndex() >= 0 && value != null && value instanceof Object[]) {
            value = ((Object[])value)[fld.getSourceFieldIndex()];
        }
        if (value instanceof Object[]) {
            String stringValue = "";
            for (Object singleValue : (Object[])value) {
                stringValue = stringValue + "," + singleValue.toString();
            }
            value = stringValue.substring(1);
        }
        return value;
    }

    public static class FlatViewField {
        private final String uniqueID;
        private final Field sourceField;
        private final int sourceFieldIndex;
        private final String relatedModel;
        private final String name;
        private final String label;
        private final Class type;

        protected FlatViewField(String uniqueID, Field sourceField, int sourceFieldIndex, String relatedModel, String name, String label, Class<?> type) {
            this.uniqueID = uniqueID;
            this.sourceField = sourceField;
            this.sourceFieldIndex = sourceFieldIndex;
            this.relatedModel = relatedModel;
            this.name = name;
            this.label = label;
            this.type = type;
        }

        public String getUniqueID() {
            return this.uniqueID;
        }

        public Field getSourceField() {
            return this.sourceField;
        }

        public int getSourceFieldIndex() {
            return this.sourceFieldIndex;
        }

        public String getRelatedModel() {
            return this.relatedModel;
        }

        public String getName() {
            return this.name;
        }

        public String getLabel() {
            return this.label;
        }

        public Class getType() {
            return this.type;
        }
    }

    public static class FlatViewFieldCollection
    extends ArrayList<FlatViewField> {
        private static final long serialVersionUID = -5920069477471978489L;

        public void SortByFieldName(final boolean idFirst) {
            Collections.sort(this, new Comparator<FlatViewField>(){

                @Override
                public int compare(FlatViewField arg0, FlatViewField arg1) {
                    if (idFirst && arg0.getName().equals("id")) {
                        return -1;
                    }
                    return arg0.getName().compareTo(arg1.getName());
                }
            });
        }
    }
}

